/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.SeatSelectionAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.OrderServiceExtension;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.MiscTicketItemDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.ui.dialog.ReorderDialog;
import com.floreantpos.ui.dialog.SalesAreaSelectionDialog;
import com.floreantpos.ui.order.CourseOrganizeDialog;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.CategoryView;
import com.floreantpos.ui.views.order.GroupView;
import com.floreantpos.ui.views.order.MenuItemView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.TicketView;
import com.floreantpos.ui.views.order.ViewPanel;
import com.floreantpos.ui.views.order.actions.TicketEditListener;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentView;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class OrderView
extends ViewPanel
implements PaymentListener,
TicketEditListener,
RefreshableView {
    private HashMap<String, JComponent> views = new HashMap();
    private SettleTicketProcessor ticketProcessor = new SettleTicketProcessor(Application.getCurrentUser(), this);
    public static final String VIEW_NAME = "ORDER_VIEW";
    private static OrderView instance;
    private Ticket currentTicket;
    private CategoryView categoryView = new CategoryView();
    private GroupView groupView = new GroupView();
    private MenuItemView itemView = new MenuItemView();
    private TicketView ticketView = new TicketView();
    private TransparentPanel midContainer = new TransparentPanel(new BorderLayout(5, 5));
    private JPanel ticketViewContainer = new JPanel(new BorderLayout());
    private JPanel ticketSummaryView = this.createTicketSummeryPanel();
    private OrderController orderController = new OrderController(this);
    private JPanel actionButtonPanel = new JPanel((LayoutManager)new MigLayout("fill, ins 2, hidemode 3", "fill", "fill"));
    private PosButton btnHold = new PosButton(POSConstants.HOLD_BUTTON_TEXT);
    private PosButton btnDone = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
    private PosButton btnSend = new PosButton(POSConstants.SEND_TO_KITCHEN);
    private PosButton btnCancel = new PosButton(POSConstants.CANCEL_BUTTON_TEXT);
    private PosButton btnGuestNo = new PosButton(POSConstants.GUEST_NO_BUTTON_TEXT);
    private PosButton btnSeatNo = new PosButton(Messages.getString("OrderView.3"));
    private PosButton btnMisc = new PosButton(POSConstants.MISC_BUTTON_TEXT);
    private PosButton btnOrderType = new PosButton(POSConstants.ORDER_TYPE_BUTTON_TEXT);
    private PosButton btnTableNumber = new PosButton(POSConstants.TABLE_NO_BUTTON_TEXT);
    private PosButton btnCustomer = new PosButton(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
    private PosButton btnReorder = new PosButton("REORDER");
    private PosButton btnOrganizeCourse = new PosButton(POSConstants.ORGANIZE_COURSE.toUpperCase());
    private PosButton btnDeliveryInfo = new PosButton("DELIVERY INFO");
    private PosButton btnSalesArea = new PosButton("SALES AREA");
    private SeatSelectionAction seatAction = new SeatSelectionAction();
    private PosButton btnDiscount = new PosButton(Messages.getString("TicketView.43"));
    private boolean _86Mode;
    private boolean returnMode;
    private JTextField tfSubtotal;
    private JTextField tfDiscount;
    private JTextField tfDeliveryCharge;
    private JTextField tfTax;
    private JTextField tfGratuity;
    private JTextField tfTotal;
    private PaymentView paymentView;

    private OrderView() {
        this.initComponents();
        this.ticketView.getTicketViewerTable().addTicketUpdateListener(this);
        this.orderController.addTicketUpdateListener(this);
        this.ticketProcessor.addPaymentListener(this);
    }

    public void addView(String viewName, JComponent view) {
        JComponent oldView = this.views.get(viewName);
        if (oldView != null) {
            return;
        }
        this.midContainer.add((Component)view, viewName);
    }

    private void initComponents() {
        this.setOpaque(false);
        this.setLayout(new BorderLayout(2, 1));
        JPanel ticketViewInnerCon = new JPanel(new BorderLayout());
        ticketViewInnerCon.add(this.ticketView);
        ticketViewInnerCon.add((Component)this.ticketSummaryView, "South");
        this.ticketViewContainer.add(ticketViewInnerCon);
        this.midContainer.setOpaque(false);
        this.midContainer.setBorder(null);
        this.midContainer.add((Component)this.groupView, "North");
        this.midContainer.add(this.itemView);
        this.addActionButtonPanel();
        this.btnOrderType.setVisible(false);
        this.showView("VIEW_EMPTY");
    }

    private void handleTicketItemSelection() {
        ITicketItem selectedItem = this.ticketView.getTicketViewerTable().getSelected();
        if (selectedItem == null) {
            this.btnDiscount.setEnabled(false);
        } else {
            this.btnDiscount.setEnabled(selectedItem.canAddDiscount());
        }
    }

    private void addActionButtonPanel() {
        this.ticketView.getTicketViewerTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    OrderView.this.handleTicketItemSelection();
                }
            }
        });
        this.btnSalesArea.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderView.this.doAddSalesArea();
            }
        });
        this.btnDone.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    OrderView.this.ticketView.doFinishOrder();
                }
                catch (StaleStateException x) {
                    POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
                }
                catch (PosException x) {
                    POSMessageDialog.showError(x.getMessage());
                }
                catch (Exception x) {
                    POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (OrderView.this.ticketView.isCancelable()) {
                    OrderView.this.ticketView.doCancelOrder();
                    OrderView.this.orderController.fireTicketEditingFinish(OrderView.this.currentTicket);
                    return;
                }
                int result = POSMessageDialog.showYesNoQuestionDialog(null, Messages.getString("OrderView.4"), Messages.getString("OrderView.7"));
                if (result != 0) {
                    return;
                }
                VoidTicketAction action = new VoidTicketAction(OrderView.this.currentTicket);
                action.execute();
                if (OrderView.this.currentTicket.isVoided().booleanValue()) {
                    OrderView.this.ticketView.doCancelOrder();
                    OrderView.this.ticketView.setAllowToLogOut(true);
                }
                OrderView.this.orderController.fireTicketEditingFinish(OrderView.this.currentTicket);
            }
        });
        this.btnSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderView.this.doSendTicketToKitchen();
            }
        });
        this.btnReorder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderView.this.doReorder();
            }
        });
        this.btnOrganizeCourse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderView.this.doOrganizeTicketItemsByCourse();
            }
        });
        this.btnOrderType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        this.btnCustomer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderView.this.doAddEditCustomer();
            }
        });
        this.btnMisc.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderView.this.doInsertMisc(evt);
            }
        });
        this.btnGuestNo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderView.this.btnCustomerNumberActionPerformed();
            }
        });
        this.seatAction.setSource(this.btnSeatNo);
        this.btnSeatNo.setAction(this.seatAction);
        this.btnTableNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderView.this.doSetTables();
            }
        });
        this.btnHold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderView.this.doHoldOrder();
            }
        });
        this.btnDiscount.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrderView.this.addDiscount();
            }
        });
        this.btnDeliveryInfo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OrderView.this.doShowDeliveryDialog();
            }
        });
        this.actionButtonPanel.add(this.btnOrderType);
        this.actionButtonPanel.add(this.btnCustomer);
        this.actionButtonPanel.add(this.btnDeliveryInfo);
        this.actionButtonPanel.add(this.btnTableNumber);
        this.actionButtonPanel.add(this.btnGuestNo);
        this.actionButtonPanel.add(this.btnSeatNo);
        this.actionButtonPanel.add(this.btnSalesArea);
        this.actionButtonPanel.add(this.btnOrganizeCourse);
        this.actionButtonPanel.add(this.btnMisc);
        this.actionButtonPanel.add(this.btnHold);
        this.actionButtonPanel.add(this.btnSend);
        this.actionButtonPanel.add(this.btnReorder);
        this.actionButtonPanel.add(this.btnCancel);
        this.actionButtonPanel.add(this.btnDone);
        this.btnDeliveryInfo.setVisible(false);
    }

    private void doOrganizeTicketItemsByCourse() {
        if (DataProvider.get().getCourses().isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Course not found.");
            return;
        }
        CourseOrganizeDialog dialog = new CourseOrganizeDialog(this.currentTicket);
        dialog.setSize(950, 650);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.ticketView.getTicketViewerTable().updateView();
    }

    private JPanel createTicketSummeryPanel() {
        JLabel lblSubtotal = new JLabel();
        lblSubtotal.setHorizontalAlignment(4);
        lblSubtotal.setText(POSConstants.SUBTOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfSubtotal = new JTextField(10);
        this.tfSubtotal.setHorizontalAlignment(11);
        this.tfSubtotal.setEditable(false);
        JLabel lblDiscount = new JLabel();
        lblDiscount.setHorizontalAlignment(4);
        lblDiscount.setText(Messages.getString("TicketView.9") + " " + CurrencyUtil.getCurrencySymbol());
        this.tfDiscount = new JTextField(10);
        this.tfDiscount.setHorizontalAlignment(11);
        this.tfDiscount.setEditable(false);
        JLabel lblDeliveryCharge = new JLabel();
        lblDeliveryCharge.setHorizontalAlignment(4);
        lblDeliveryCharge.setText("Delivery Charge: " + CurrencyUtil.getCurrencySymbol());
        this.tfDeliveryCharge = new JTextField(10);
        this.tfDeliveryCharge.setHorizontalAlignment(11);
        this.tfDeliveryCharge.setEditable(false);
        JLabel lblTax = new JLabel();
        lblTax.setHorizontalAlignment(4);
        lblTax.setText(POSConstants.TAX + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfTax = new JTextField(10);
        this.tfTax.setEditable(false);
        this.tfTax.setHorizontalAlignment(11);
        JLabel lblGratuity = new JLabel();
        lblGratuity.setHorizontalAlignment(4);
        lblGratuity.setText(Messages.getString("SettleTicketDialog.5") + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfGratuity = new JTextField(10);
        this.tfGratuity.setEditable(false);
        this.tfGratuity.setHorizontalAlignment(11);
        JLabel lblTotal = new JLabel();
        lblTotal.setFont(lblTotal.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        lblTotal.setHorizontalAlignment(4);
        lblTotal.setText(POSConstants.TOTAL + ": " + CurrencyUtil.getCurrencySymbol());
        this.tfTotal = new JTextField(10);
        this.tfTotal.setFont(this.tfTotal.getFont().deriveFont(1, PosUIManager.getFontSize(18)));
        this.tfTotal.setHorizontalAlignment(11);
        this.tfTotal.setEditable(false);
        TransparentPanel ticketAmountPanel = new TransparentPanel((LayoutManager)new MigLayout("hidemode 3,ins 2 2 3 2,alignx trailing,fill", "[grow]2[]", ""));
        ticketAmountPanel.add((Component)lblSubtotal, "growx,aligny center");
        ticketAmountPanel.add((Component)this.tfSubtotal, "growx,aligny center");
        ticketAmountPanel.add((Component)lblDiscount, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfDiscount, "growx,aligny center");
        ticketAmountPanel.add((Component)lblTax, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfTax, "growx,aligny center");
        ticketAmountPanel.add((Component)lblGratuity, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfGratuity, "growx,aligny center");
        ticketAmountPanel.add((Component)lblTotal, "newline,growx,aligny center");
        ticketAmountPanel.add((Component)this.tfTotal, "growx,aligny center");
        return ticketAmountPanel;
    }

    public void updateTicketSummeryView() {
        Ticket ticket = this.ticketView.getTicket();
        if (ticket == null) {
            this.tfSubtotal.setText("");
            this.tfDiscount.setText("");
            this.tfDeliveryCharge.setText("");
            this.tfTax.setText("");
            this.tfTotal.setText("");
            this.tfGratuity.setText("");
            return;
        }
        this.tfSubtotal.setText(NumberUtil.formatNumber(ticket.getSubtotalAmount()));
        this.tfDiscount.setText(NumberUtil.formatNumber(ticket.getDiscountAmount()));
        this.tfDeliveryCharge.setText(NumberUtil.formatNumber(ticket.getDeliveryCharge()));
        if (Application.getInstance().isPriceIncludesTax()) {
            this.tfTax.setText(Messages.getString("TicketView.35"));
        } else {
            this.tfTax.setText(NumberUtil.formatNumber(ticket.getTaxAmount()));
        }
        if (ticket.getGratuity() != null) {
            this.tfGratuity.setText(NumberUtil.formatNumber(ticket.getGratuity().getAmount()));
        } else {
            this.tfGratuity.setText("0.00");
        }
        this.tfTotal.setText(NumberUtil.formatNumber(ticket.getTotalAmountWithTips()));
    }

    protected void doShowDeliveryDialog() {
        try {
            Customer customer = CustomerDAO.getInstance().findById(this.currentTicket.getCustomerId());
            OrderServiceFactory.getOrderService().showDeliveryInfo(this.currentTicket, this.currentTicket.getOrderType(), customer);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    public void doSetTables() {
        try {
            TableSelectorDialog dialog = TableSelectorFactory.createTableSelectorDialog(this.currentTicket.getOrderType());
            dialog.setCreateNewTicket(false);
            this.currentTicket.setShouldUpdateTableStatus(true);
            if (this.currentTicket != null) {
                dialog.setTicket(this.currentTicket);
            }
            dialog.openUndecoratedFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            List<ShopTable> tables = dialog.getSelectedTables();
            ArrayList<Integer> tableNumbers = new ArrayList<Integer>();
            for (ShopTable shopTable : tables) {
                SalesArea salesArea = shopTable.getSalesArea();
                if (salesArea != null) {
                    this.currentTicket.setSalesArea(salesArea);
                    this.currentTicket.setSalesAreaId(salesArea.getId());
                }
                tableNumbers.add(shopTable.getId());
            }
            ShopTableStatusDAO.getInstance().removeTicketFromShopTableStatus(this.currentTicket, null);
            this.currentTicket.setTableNumbers(tableNumbers);
            this.updateView();
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    protected void doAddSalesArea() {
        try {
            SalesAreaSelectionDialog dialog = new SalesAreaSelectionDialog();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            SalesArea selectedSalesArea = dialog.getSelectedSalesArea();
            this.setFocusable(true);
            this.currentTicket.setSalesArea(selectedSalesArea);
            this.currentTicket.setSalesAreaId(selectedSalesArea.getId());
            this.btnSalesArea.setText("<html><center>SALES AREA<br/>" + selectedSalesArea.getName() + "</center></html>");
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    protected void btnCustomerNumberActionPerformed() {
        try {
            Ticket thisTicket = this.currentTicket;
            int guestNumber = thisTicket.getNumberOfGuests();
            NumberSelectionDialog2 dialog = new NumberSelectionDialog2();
            dialog.setTitle(POSConstants.NUMBER_OF_GUESTS);
            dialog.setValue(guestNumber);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            guestNumber = (int)dialog.getValue();
            if (guestNumber == 0) {
                POSMessageDialog.showError(Application.getPosWindow(), POSConstants.GUEST_NUMBER_CANNOT_BE_0);
                return;
            }
            thisTicket.setNumberOfGuests(guestNumber);
            this.updateView();
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    protected void doInsertMisc(ActionEvent evt) {
        try {
            MiscTicketItemDialog dialog = new MiscTicketItemDialog();
            dialog.setOrderType(this.currentTicket.getOrderType());
            dialog.pack();
            dialog.open();
            if (!dialog.isCanceled()) {
                TicketItem ticketItem = dialog.getTicketItem();
                ticketItem.setTicket(this.currentTicket);
                ticketItem.calculatePrice();
                this.ticketView.addTicketItem(ticketItem);
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    protected void doAddEditCustomer() {
        try {
            CustomerSelectorDialog dialog = CustomerSelectorFactory.createCustomerSelectorDialog(this.currentTicket.getOrderType());
            dialog.setCreateNewTicket(false);
            if (this.currentTicket != null) {
                dialog.setTicket(this.currentTicket);
            }
            dialog.openUndecoratedFullScreen();
            if (!dialog.isCanceled()) {
                Customer selectedCustomer = dialog.getSelectedCustomer();
                this.currentTicket.setCustomer(selectedCustomer);
                if (selectedCustomer != null) {
                    this.btnCustomer.setText("<html><center>" + POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT + "<br><small>" + selectedCustomer.getName() + "</small></center></html>");
                }
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    protected void addDiscount() {
        try {
            ITicketItem selectedObject = this.ticketView.getTicketViewerTable().getSelected();
            if (!(selectedObject instanceof TicketItem)) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.20"));
                return;
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    public void updateView() {
        Terminal terminal = Application.getInstance().getTerminal();
        if (this.currentTicket != null) {
            OrderType type = this.currentTicket.getOrderType();
            if (type.isPrepaid().booleanValue()) {
                this.btnDone.setVisible(false);
            } else {
                this.btnDone.setVisible(true);
            }
            if (!type.isShouldPrintToKitchen().booleanValue()) {
                this.btnSend.setEnabled(false);
            } else {
                this.btnSend.setEnabled(true);
            }
            if (!type.isAllowSeatBasedOrder().booleanValue()) {
                this.btnSeatNo.setVisible(false);
            } else {
                this.btnSeatNo.setVisible(true);
                Integer lastSeatNumber = null;
                Object lastSeat = this.seatAction.getLastSeat(this.currentTicket);
                if (lastSeat instanceof Integer) {
                    lastSeatNumber = (Integer)lastSeat;
                    this.btnSeatNo.putClientProperty("SEAT_NO", lastSeatNumber);
                    if (lastSeatNumber != null && lastSeatNumber > 0) {
                        this.btnSeatNo.setText(Messages.getString("OrderView.20") + lastSeatNumber);
                    } else {
                        this.btnSeatNo.setText(Messages.getString("OrderView.21"));
                    }
                } else if (lastSeat instanceof TicketItemSeat) {
                    TicketItemSeat ticketItemSeat = (TicketItemSeat)this.seatAction.getLastSeat(this.currentTicket);
                    this.btnSeatNo.putClientProperty("SEAT_NO", ticketItemSeat);
                    this.btnSeatNo.setText("SEAT:");
                }
            }
            if (!type.isShowTableSelection().booleanValue()) {
                this.btnGuestNo.setVisible(false);
                this.btnTableNumber.setVisible(false);
            } else {
                this.btnGuestNo.setVisible(true);
                this.btnTableNumber.setVisible(true);
                if (!terminal.isShowTableNumber()) {
                    this.btnTableNumber.setText("<html><center>" + Messages.getString("OrderView.23") + ": " + this.currentTicket.getTableNames() + "</center><html/>");
                } else {
                    List<Integer> tableNumbers = this.currentTicket.getTableNumbers();
                    if (tableNumbers != null) {
                        String tables = this.getTableNumbers(this.currentTicket.getTableNumbers());
                        this.btnTableNumber.setText("<html><center>" + Messages.getString("OrderView.23") + ": " + tables + "</center><html/>");
                    } else {
                        this.btnTableNumber.setText(Messages.getString("OrderView.26"));
                    }
                }
                this.btnGuestNo.setText(Messages.getString("OrderView.27") + ": " + String.valueOf(this.currentTicket.getNumberOfGuests()));
            }
            if (type.isEnableReorder().booleanValue()) {
                this.btnReorder.setVisible(true);
            } else {
                this.btnReorder.setVisible(false);
            }
            this.btnOrganizeCourse.setVisible(type.isEnableCourse());
            OrderServiceExtension orderService = (OrderServiceExtension)ExtensionManager.getPlugin(OrderServiceExtension.class);
            if (orderService != null && type.isDelivery().booleanValue() && type.isRequiredCustomerData().booleanValue()) {
                this.btnDeliveryInfo.setVisible(true);
            }
            if (type.isRetailOrder().booleanValue()) {
                this.ticketView.updateView();
                this.updateTicketSummeryView();
                this.paymentView.setTicket(this.currentTicket);
                this.setHideButtonForRetailView();
            }
            if (this.currentTicket.getSalesArea() != null) {
                if (this.currentTicket.getSalesArea() != null) {
                    String salesAreaString = this.currentTicket.getSalesArea().toString();
                    this.btnSalesArea.setText("<html><center>SALES AREA <br>" + salesAreaString + "</center><html/>");
                }
            } else if (this.currentTicket.getId() != null) {
                this.btnSalesArea.setText("SALES AREA");
            } else {
                SalesArea salesArea = terminal.getSalesArea();
                if (salesArea != null) {
                    String salesAreaString = salesArea.toString();
                    this.btnSalesArea.setText("<html><center>SALES AREA <br>" + salesAreaString + "</center><html/>");
                }
                if (terminal.isFixedSalesArea().booleanValue()) {
                    this.btnSalesArea.setEnabled(false);
                } else {
                    this.btnSalesArea.setEnabled(true);
                }
            }
            if (this.currentTicket.getCustomer() != null) {
                this.btnCustomer.setText("<html><center>" + POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT + "<br>" + this.currentTicket.getCustomer().getName());
            } else {
                this.btnCustomer.setText(POSConstants.CUSTOMER_SELECTION_BUTTON_TEXT);
            }
        }
    }

    private String getTableNumbers(List<Integer> numbers) {
        String tableNumbers = "";
        if (numbers != null && !numbers.isEmpty()) {
            Iterator<Integer> iterator = numbers.iterator();
            while (iterator.hasNext()) {
                Integer n = iterator.next();
                tableNumbers = tableNumbers + n;
                if (!iterator.hasNext()) continue;
                tableNumbers = tableNumbers + ", ";
            }
            return tableNumbers;
        }
        return tableNumbers;
    }

    public void showView(String viewName) {
    }

    public CategoryView getCategoryView() {
        return this.categoryView;
    }

    public void setCategoryView(CategoryView categoryView) {
        this.categoryView = categoryView;
    }

    public GroupView getGroupView() {
        return this.groupView;
    }

    public void setGroupView(GroupView groupView) {
        this.groupView = groupView;
    }

    public MenuItemView getItemView() {
        return this.itemView;
    }

    public void setItemView(MenuItemView itemView) {
        this.itemView = itemView;
    }

    public TicketView getTicketView() {
        return this.ticketView;
    }

    public void setTicketView(TicketView ticketView) {
        this.ticketView = ticketView;
    }

    public OrderController getOrderController() {
        return this.orderController;
    }

    public Ticket getCurrentTicket() {
        return this.currentTicket;
    }

    private void changeViewForOrderType(OrderType orderType) {
        if (orderType.isRetailOrder().booleanValue()) {
            this.showRetailView();
        } else {
            this.showDefaultView();
        }
        this.revalidate();
        this.repaint();
    }

    private void setHideButtonForRetailView() {
        this.btnDone.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnDeliveryInfo.setVisible(false);
        this.btnDiscount.setVisible(false);
        this.btnGuestNo.setVisible(false);
        this.btnOrderType.setVisible(false);
        this.btnReorder.setVisible(false);
        this.btnSalesArea.setVisible(false);
        this.btnSeatNo.setVisible(false);
        this.btnTableNumber.setVisible(false);
        this.btnSend.setVisible(false);
    }

    private void setVisibleButtonForOrderView() {
        this.btnDone.setVisible(true);
        this.btnCancel.setVisible(true);
        this.btnDiscount.setVisible(true);
        this.btnGuestNo.setVisible(true);
        this.btnHold.setVisible(true);
        this.btnMisc.setVisible(true);
        this.btnSalesArea.setVisible(true);
        this.btnSeatNo.setVisible(true);
        this.btnSend.setVisible(true);
        this.btnTableNumber.setVisible(true);
    }

    private void showRetailView() {
        this.removeAll();
        if (this.paymentView == null) {
            this.paymentView = new PaymentView(this.ticketProcessor, this);
        }
        this.ticketView.showSettleButton(false);
        this.ticketSummaryView.setVisible(true);
        this.ticketViewContainer.add((Component)this.actionButtonPanel, "South");
        this.add((Component)this.ticketViewContainer, "Center");
        this.add((Component)this.paymentView, "East");
    }

    private void showDefaultView() {
        this.removeAll();
        this.setVisibleButtonForOrderView();
        this.ticketSummaryView.setVisible(false);
        this.ticketView.showSettleButton(true);
        this.add((Component)this.categoryView, "East");
        this.add((Component)this.ticketViewContainer, "West");
        this.add((Component)this.midContainer, "Center");
        this.add((Component)this.actionButtonPanel, "South");
    }

    public void setCurrentTicket(Ticket newTicket) {
        if (this.currentTicket != null && newTicket != null) {
            OrderType newOrderType;
            OrderType currentOrderType = this.currentTicket.getOrderType();
            if (!currentOrderType.equals(newOrderType = newTicket.getOrderType())) {
                this.currentTicket = newTicket;
                this.changeViewForOrderType(newOrderType);
            }
        } else if (this.currentTicket == null && newTicket != null) {
            OrderType newOrderType = newTicket.getOrderType();
            this.changeViewForOrderType(newOrderType);
        }
        this.currentTicket = newTicket;
        this.ticketView.setTicket(newTicket);
        if (this.paymentView != null) {
            this.paymentView.setTicket(newTicket);
        }
        this.seatAction.clearSelectedSeat();
        this.updateView();
        this.orderController.fireTicketEditingStart(newTicket);
    }

    public static synchronized OrderView getInstance() {
        if (instance == null) {
            instance = new OrderView();
        }
        return instance;
    }

    public void resetView() {
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.initializeCategoryView();
            this.ticketView.setVisible(true);
        } else {
            this.ticketView.setVisible(false);
            if (TerminalConfig.isActiveCustomerDisplay()) {
                DrawerUtil.setCustomerDisplayMessage(TerminalConfig.getCustomerDisplayPort(), "Thank You");
            }
        }
        this.setReturnMode(false);
    }

    @Override
    public String getViewName() {
        return VIEW_NAME;
    }

    private void initializeCategoryView() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    OrderView.this.categoryView.initialize();
                }
                catch (Throwable t) {
                    POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, t);
                }
            }
        });
    }

    private void doHoldOrder() {
        try {
            if (this.currentTicket.getOrderType().isShowTableSelection().booleanValue() && this.currentTicket.getOrderType().isRequiredCustomerData().booleanValue()) {
                String password = PasswordEntryDialog.show(Application.getPosWindow(), Messages.getString("OrderView.9"));
                if (StringUtils.isEmpty((String)password)) {
                    return;
                }
                User user2 = UserDAO.getInstance().findUserBySecretKey(password);
                if (user2 == null) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("OrderView.10"));
                    return;
                }
            }
            if (this.ticketView.getTicket().getTicketItems() == null || this.ticketView.getTicket().getTicketItems().size() == 0) {
                POSMessageDialog.showError(POSConstants.TICKET_IS_EMPTY_);
                return;
            }
            this.ticketView.doHoldOrder();
            this.ticketView.setAllowToLogOut(true);
            this.orderController.fireTicketEditingFinish(this.currentTicket);
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doReorder() {
        try {
            Ticket ticket = this.ticketView.getTicket();
            Ticket cloneTicket = ticket.clone(ticket);
            List<TicketItem> ticketItems = cloneTicket.getTicketItems();
            if (ticketItems == null || ticketItems.size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No items to reorder.");
                return;
            }
            Iterator<TicketItem> iterator = ticketItems.iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = iterator.next();
                if (ticketItem.isPrintedToKitchen().booleanValue()) continue;
                iterator.remove();
            }
            if (cloneTicket.getTicketItems().size() == 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No items to reorder.");
                return;
            }
            ReorderDialog dialog = new ReorderDialog(cloneTicket);
            dialog.setTitle("OROPOS");
            dialog.setDefaultCloseOperation(2);
            dialog.setResizable(false);
            dialog.openFullScreen();
            if (!dialog.isCanceled()) {
                List<TicketItem> ticketItemList = dialog.getTicketItems();
                if (ticketItemList == null) {
                    return;
                }
                for (TicketItem ticketItem : ticketItemList) {
                    this.ticketView.addTicketItem(ticketItem);
                }
                OrderController.saveOrder(this.ticketView.getTicket());
                this.ticketView.sendTicketToKitchen();
                this.ticketView.getTicketViewerTable().repaint();
                POSMessageDialog.showMessage(Messages.getString("OrderView.8"));
            }
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void doSendTicketToKitchen() {
        try {
            this.ticketView.sendTicketToKitchenByOption(this);
            this.ticketView.updateTicketTitle();
            this.ticketView.getTicketViewerTable().updateView();
        }
        catch (StaleStateException x) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this);
        }
        catch (PosException x) {
            POSMessageDialog.showError(x.getMessage());
        }
        catch (Exception x) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, x);
        }
    }

    public Object getSelectedSeatNumber() {
        Ticket currentTicket = this.getCurrentTicket();
        if (currentTicket.getOrderType() != null && currentTicket.getOrderType().isAllowSeatBasedOrder().booleanValue()) {
            return this.seatAction.getSelectedSeatNumber();
        }
        return null;
    }

    public boolean updateSeat(TicketItem ticketItem) {
        return this.seatAction.updateSeatNumber(ticketItem);
    }

    public boolean is_86Mode() {
        return this._86Mode;
    }

    public void set_86Mode(boolean _86Mode) {
        this._86Mode = _86Mode;
    }

    @Override
    public void paymentDone() {
        this.ticketView.doFinishOrder();
        this.updateView();
    }

    @Override
    public void paymentCanceled() {
        if (this.currentTicket == null) {
            return;
        }
        if (StringUtils.isNotEmpty((String)this.currentTicket.getId()) && this.currentTicket.getDueAmount() > 0.0) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Payment is not fully completed, ticket can not be cancelled!");
            return;
        }
        if (StringUtils.isNotEmpty((String)this.currentTicket.getId())) {
            TicketDAO.getInstance().delete(this.currentTicket);
        }
        this.currentTicket.getTicketItems().clear();
        this.ticketView.doCancelOrder();
        this.updateView();
    }

    @Override
    public void paymentDataChanged() {
        this.updateView();
    }

    public PaymentView getPaymentView() {
        return this.paymentView;
    }

    public SettleTicketProcessor getTicketProcessor() {
        return this.ticketProcessor;
    }

    @Override
    public void itemAdded(Ticket ticket, TicketItem item) {
        if (ticket.getOrderType().isRetailOrder().booleanValue()) {
            this.updateView();
            this.paymentView.updateView();
        }
    }

    @Override
    public void itemRemoved(TicketItem item) {
        if (this.currentTicket.getOrderType().isRetailOrder().booleanValue()) {
            this.updateView();
            this.paymentView.updateView();
        }
    }

    public boolean isReturnMode() {
        return this.returnMode;
    }

    public void setReturnMode(boolean returnMode) {
        this.returnMode = returnMode;
    }

    @Override
    public void refresh() {
        Ticket ticket = TicketDAO.getInstance().loadFullTicket(this.currentTicket.getId());
        this.setCurrentTicket(ticket);
    }
}

