/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public abstract class SelectionView
extends JPanel {
    private static final int HORIZONTAL_GAP = 5;
    private static final int VERTICAL_GAP = 5;
    protected PaginatedListModel dataModel;
    protected Dimension buttonSize;
    protected JPanel selectionButtonsPanel;
    protected TitledBorder border;
    protected JPanel actionButtonPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3, ins 2", "sg, fill", ""));
    protected PosButton btnNext;
    protected PosButton btnPrev;
    private boolean initialized = false;

    public SelectionView(String title, LayoutManager buttonPanelLayout, int buttonWidth, int buttonHeight) {
        this.selectionButtonsPanel = new JPanel(buttonPanelLayout);
        this.buttonSize = new Dimension(buttonWidth, buttonHeight);
        this.setLayout(new BorderLayout(5, 5));
        this.border = new TitledBorder(title);
        this.border.setTitleJustification(2);
        this.setBorder(new CompoundBorder(this.border, new EmptyBorder(2, 2, 2, 2)));
        this.add(this.selectionButtonsPanel);
        this.btnPrev = new PosButton();
        this.btnPrev.setText(POSConstants.CAPITAL_PREV);
        this.actionButtonPanel.add((Component)this.btnPrev, "grow, align center");
        this.btnNext = new PosButton();
        this.btnNext.setText(POSConstants.CAPITAL_NEXT);
        this.actionButtonPanel.add((Component)this.btnNext, "grow, align center");
        this.add((Component)this.actionButtonPanel, "South");
        ScrollAction action = new ScrollAction();
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(false);
    }

    public void setTitle(String title) {
        this.border.setTitle(title);
    }

    public void setDataModel(PaginatedListModel items) {
        this.dataModel = items;
        this.renderItems();
    }

    protected void updateButton() {
        boolean hasNext = this.dataModel.hasNext();
        boolean hasPrevious = this.dataModel.hasPrevious();
        this.btnNext.setVisible(hasNext || hasPrevious);
        this.btnPrev.setVisible(hasNext || hasPrevious);
        this.btnPrev.setEnabled(hasPrevious);
        this.btnNext.setEnabled(hasNext);
    }

    public PaginatedListModel getDataModel() {
        return this.dataModel;
    }

    public Dimension getButtonSize() {
        return this.buttonSize;
    }

    public void setButtonSize(Dimension buttonSize) {
        this.buttonSize = buttonSize;
    }

    protected abstract AbstractButton createItemButton(Object var1);

    public void reset() {
        Component[] components;
        for (Component component : components = this.selectionButtonsPanel.getComponents()) {
            ActionListener[] actionListeners;
            if (!(component instanceof AbstractButton)) continue;
            AbstractButton button = (AbstractButton)component;
            for (ActionListener actionListener : actionListeners = button.getActionListeners()) {
                button.removeActionListener(actionListener);
            }
        }
        this.selectionButtonsPanel.removeAll();
        this.selectionButtonsPanel.repaint();
        this.btnNext.setVisible(false);
        this.btnPrev.setVisible(false);
    }

    protected int getHorizontalButtonCount() {
        Dimension size = this.selectionButtonsPanel.getSize();
        Dimension itemButtonSize = this.getButtonSize();
        return this.getButtonCount(size.width, itemButtonSize.width);
    }

    protected int getFitableButtonCount() {
        Dimension size = this.selectionButtonsPanel.getSize();
        Insets insets = this.selectionButtonsPanel.getInsets();
        Dimension itemButtonSize = this.getButtonSize();
        int horizontalButtonCount = this.getButtonCount(size.width - insets.left - insets.right, itemButtonSize.width);
        int verticalButtonCount = this.getButtonCount(size.height - 50 - insets.top - insets.bottom, itemButtonSize.height);
        int totalItem = horizontalButtonCount * verticalButtonCount;
        return totalItem;
    }

    protected void renderItems() {
        try {
            this.reset();
            if (this.dataModel == null || this.dataModel.getSize() == 0) {
                return;
            }
            for (int i = 0; i < this.dataModel.getSize(); ++i) {
                Object item = this.dataModel.getElementAt(i);
                AbstractButton itemButton = this.createItemButton(item);
                if (itemButton == null) continue;
                this.selectionButtonsPanel.add(itemButton);
            }
            this.btnNext.setVisible(this.dataModel.hasNext());
            this.btnPrev.setVisible(this.dataModel.hasPrevious());
            this.revalidate();
            this.repaint();
        }
        catch (Exception e) {
            this.initialized = false;
            POSMessageDialog.showError(this, e.getMessage(), e);
        }
    }

    protected void scrollDown() {
    }

    protected void scrollUp() {
    }

    public JPanel getButtonsPanel() {
        return this.selectionButtonsPanel;
    }

    public AbstractButton getFirstItemButton() {
        int componentCount = this.selectionButtonsPanel.getComponentCount();
        if (componentCount == 0) {
            return null;
        }
        return (AbstractButton)this.selectionButtonsPanel.getComponent(0);
    }

    protected int getButtonCount(int containerSize, int itemSize) {
        int buttonCount = containerSize / (itemSize + 10);
        return buttonCount;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    private class ScrollAction
    implements ActionListener {
        private ScrollAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                Object source = e.getSource();
                if (source == SelectionView.this.btnPrev) {
                    SelectionView.this.scrollUp();
                } else if (source == SelectionView.this.btnNext) {
                    SelectionView.this.scrollDown();
                }
            }
            catch (Exception e2) {
                POSMessageDialog.showError(Application.getPosWindow(), e2.getMessage(), e2);
            }
        }
    }
}

