/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.TicketInfoButton;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;

public class StyledTicketSelectionDialog
extends OkCancelOptionDialog
implements MouseListener {
    private ScrollableFlowPanel buttonsPanel;
    private Map<String, Ticket> addedTicketListModel = new HashMap<String, Ticket>();
    private POSToggleButton btnSelectAll;
    private boolean isHasDiscounts;
    private boolean isMerge;
    private boolean allowPartialPayment;
    private Integer requiredNumber;
    public static Dimension tokenSize = PosUIManager.getSize(180, 160);

    public StyledTicketSelectionDialog() {
        this(false);
    }

    public StyledTicketSelectionDialog(boolean allowPartialPayment) {
        super((Window)Application.getPosWindow());
        this.allowPartialPayment = allowPartialPayment;
        this.initComponent();
        this.initData();
    }

    public StyledTicketSelectionDialog(List<Ticket> tickets) {
        this.initComponent();
        this.initData(tickets);
        this.setResizable(true);
    }

    private void initComponent() {
        this.setOkButtonText(Messages.getString("TicketSelectionDialog.3"));
        this.buttonsPanel = new ScrollableFlowPanel(3);
        this.btnSelectAll = new POSToggleButton("SELECT ALL");
        this.btnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StyledTicketSelectionDialog.this.addedTicketListModel.clear();
                for (Component c : StyledTicketSelectionDialog.this.buttonsPanel.getContentPane().getComponents()) {
                    TicketInfoButton button = (TicketInfoButton)c;
                    if (StyledTicketSelectionDialog.this.btnSelectAll.isSelected()) {
                        button.setSelected(true);
                        StyledTicketSelectionDialog.this.addedTicketListModel.put(button.getTicket().getId(), button.getTicket());
                        continue;
                    }
                    button.setSelected(false);
                }
            }
        });
        this.getButtonPanel().add((Component)this.btnSelectAll, 0);
        PosScrollPane scrollPane = new PosScrollPane(this.buttonsPanel, 20, 31);
        scrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(40, 0));
        this.getContentPanel().add((Component)scrollPane, "Center");
        this.setSize(1024, 600);
    }

    private void initData() {
        this.setCaption("Select tickets");
        this.initData(null);
    }

    private void initData(List<Ticket> tickets) {
        try {
            if (tickets == null || tickets.size() <= 0) {
                User user = Application.getCurrentUser();
                tickets = !user.hasPermission(UserPermission.EDIT_OTHER_USERS_TICKETS) ? TicketDAO.getInstance().findOpenTicketsForUser(user) : TicketDAO.getInstance().findOpenTickets();
            }
            for (Ticket ticket : tickets) {
                ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                if ((ticket.getDueAmount() <= 0.0 || !this.allowPartialPayment) && !ticket.getDueAmount().equals(ticket.getTotalAmountWithTips())) continue;
                TicketInfoButton btnTicket = new TicketInfoButton(ticket);
                btnTicket.addMouseListener(this);
                this.buttonsPanel.add(btnTicket);
                btnTicket.setPreferredSize(tokenSize);
                if (ticket.getDiscounts().size() <= 0) continue;
                this.isHasDiscounts = true;
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getLocalizedMessage(), e);
        }
    }

    @Override
    public void doOk() {
        int option;
        if (this.addedTicketListModel.isEmpty() && this.requiredNumber == null) {
            POSMessageDialog.showMessage(Messages.getString("TicketSelectionDialog.5"));
            return;
        }
        if (this.requiredNumber != null && this.addedTicketListModel.size() < this.requiredNumber) {
            POSMessageDialog.showMessage("Please select at least " + this.requiredNumber + " tickets.");
            return;
        }
        if (this.isHasDiscounts && (option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "All discounts will be removed from selected tickets.\nDo you want to proceed?", "Merge Tickets")) != 0) {
            this.setCanceled(true);
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.addedTicketListModel.clear();
        this.setCanceled(true);
        this.dispose();
    }

    public List<Ticket> getSelectedTickets() {
        return new ArrayList<Ticket>(this.addedTicketListModel.values());
    }

    public Ticket getMainTicket() {
        return this.addedTicketListModel.get("root");
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        TicketInfoButton button = (TicketInfoButton)e.getSource();
        if (this.isMerge) {
            this.setSelectedSectionForMerge(button);
        } else {
            this.setSelectedSection(button);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void setSelectedSectionForMerge(TicketInfoButton section) {
        for (Component c : this.buttonsPanel.getContentPane().getComponents()) {
            TicketInfoButton sec = (TicketInfoButton)c;
            if (sec != section) continue;
            if (sec.isSelected()) {
                if (this.addedTicketListModel.get("root") == sec.getTicket() && this.addedTicketListModel.values().size() > 1) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Root ticket cannot be removed until child empty!");
                    continue;
                }
                if (this.addedTicketListModel.get("root") == sec.getTicket()) {
                    this.addedTicketListModel.remove("root");
                } else {
                    this.addedTicketListModel.remove(sec.getTicket().getId());
                }
                sec.setSelected(false);
                continue;
            }
            sec.setSelected(true);
            if (this.addedTicketListModel.isEmpty()) {
                sec.setBorder(BorderFactory.createLineBorder(Color.GREEN, 4));
                this.addedTicketListModel.put("root", sec.getTicket());
                continue;
            }
            this.addedTicketListModel.put(sec.getTicket().getId(), sec.getTicket());
        }
    }

    public void setSelectedSection(TicketInfoButton btn) {
        for (Component c : this.buttonsPanel.getContentPane().getComponents()) {
            TicketInfoButton button = (TicketInfoButton)c;
            if (button != btn) continue;
            this.setColorOfBtn(button);
        }
    }

    private void setColorOfBtn(TicketInfoButton button) {
        if (button.isSelected()) {
            button.setSelected(false);
            this.addedTicketListModel.remove(button.getTicket().getId());
        } else {
            button.setSelected(true);
            this.addedTicketListModel.put(button.getTicket().getId(), button.getTicket());
        }
    }

    public TicketInfoButton getSelectedSection() {
        for (Component c : this.buttonsPanel.getComponents()) {
            TicketInfoButton button = (TicketInfoButton)c;
            if (!button.isSelected()) continue;
            return button;
        }
        return null;
    }

    public void setMerge(boolean isMerge) {
        this.isMerge = isMerge;
        if (isMerge) {
            this.setCaption("Select tickets to merge");
            this.btnSelectAll.setVisible(false);
        }
    }

    public int getRequiredNumber() {
        return this.requiredNumber;
    }

    public void setRequiredNumber(int requiredNumber) {
        this.requiredNumber = requiredNumber;
    }
}

