/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.multipart;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.dao.MenuItemModifierPageDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.SelectionView;
import com.floreantpos.ui.views.order.modifier.ModifierGroupSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierGroupView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionModel;
import com.floreantpos.ui.views.order.multipart.PizzaModifierSelectionDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.hibernate.Session;

public class PizzaModifierView
extends SelectionView
implements ModifierGroupSelectionListener {
    private ModifierSelectionListener modifierSelectionListener;
    private PosButton btnClear = new PosButton(POSConstants.CLEAR);
    private Multiplier selectedMultiplier;
    private MultiplierButton defaultMultiplierButton;
    private ModifierGroupView modifierGroupView;
    private PizzaModifierSelectionDialog pizzaModifierSelectionDialog;
    private MenuItemModifierSpec menuModifierGroup;
    private TitledBorder titledBorder;

    public PizzaModifierView(Ticket ticket, TicketItem ticketItem, MenuItem menuItem, PizzaModifierSelectionDialog pizzaModifierSelectionDialog) {
        super(POSConstants.MODIFIERS, new FlowLayout(), PosUIManager.getSize(120), PosUIManager.getSize(80));
        ModifierSelectionModel modifierSelectionModel = new ModifierSelectionModel(ticket, ticketItem, menuItem);
        this.pizzaModifierSelectionDialog = pizzaModifierSelectionDialog;
        this.setBorder(null);
        this.titledBorder = new TitledBorder(null, "MODIFIERS", 2, 2);
        this.selectionButtonsPanel.setBorder(this.titledBorder);
        this.modifierGroupView = new ModifierGroupView(modifierSelectionModel);
        this.dataModel = new PaginatedListModel();
        this.actionButtonPanel.add((Component)this.btnPrev, "grow,split 2,span");
        this.actionButtonPanel.add((Component)this.btnNext, "grow");
        this.add((Component)this.modifierGroupView, "East");
        this.addMultiplierButtons();
        this.modifierGroupView.addModifierGroupSelectionListener(this);
        this.modifierGroupView.selectFirst();
    }

    private void addMultiplierButtons() {
        JPanel multiplierPanel = new JPanel((LayoutManager)new MigLayout("fillx,center, gap 0, ins 0"));
        LineBorder lineBorder = new LineBorder(Color.lightGray, 1, true);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(new EmptyBorder(5, 0, 5, 0), lineBorder);
        multiplierPanel.setBorder(compoundBorder);
        multiplierPanel.setOpaque(true);
        List<Multiplier> multiplierList = MultiplierDAO.getInstance().findAll();
        ButtonGroup group = new ButtonGroup();
        if (multiplierList != null) {
            for (Multiplier multiplier : multiplierList) {
                MultiplierButton btnMultiplier = new MultiplierButton(multiplier);
                if (multiplier.isDefaultMultiplier().booleanValue()) {
                    this.selectedMultiplier = multiplier;
                    this.defaultMultiplierButton = btnMultiplier;
                    btnMultiplier.setSelected(true);
                }
                multiplierPanel.add((Component)btnMultiplier, "grow");
                group.add(btnMultiplier);
            }
        }
        this.actionButtonPanel.add((Component)multiplierPanel, "newline,span");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected AbstractButton createItemButton(Object item) {
        ModifierButton modifierButton;
        Session session = null;
        try {
            ModifierButton modifierButton2;
            MenuModifier modifier = (MenuModifier)item;
            session = MenuModifierDAO.getInstance().createNewSession();
            session.refresh((Object)modifier);
            modifier.setMenuItemModifierGroup(this.menuModifierGroup);
            modifierButton = modifierButton2 = new ModifierButton(modifier, this.selectedMultiplier, this.pizzaModifierSelectionDialog.getSelectedSize());
        }
        catch (Throwable throwable) {
            MenuModifierDAO.getInstance().closeSession(session);
            throw throwable;
        }
        MenuModifierDAO.getInstance().closeSession(session);
        return modifierButton;
    }

    public void addModifierSelectionListener(ModifierSelectionListener listener) {
        this.modifierSelectionListener = listener;
    }

    public void removeModifierSelectionListener(ModifierSelectionListener listener) {
        this.modifierSelectionListener = null;
    }

    public void updateView() {
        if (this.menuModifierGroup == null) {
            return;
        }
        this.renderTitle();
        try {
            this.dataModel.setPageSize(1);
            this.dataModel.setCurrentRowIndex(0);
            this.dataModel.setNumRows(MenuItemModifierPageDAO.getInstance().getRowCount(this.menuModifierGroup.getId()));
            MenuItemModifierPageDAO.getInstance().loadItems(this.menuModifierGroup, this.dataModel);
            this.setDataModel(this.dataModel);
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
        }
    }

    @Override
    public void setDataModel(PaginatedListModel items) {
        super.setDataModel(items);
        this.updateButton();
    }

    @Override
    protected void renderItems() {
        this.populateItems();
    }

    protected void populateItems() {
        this.reset();
        if (this.dataModel.getSize() == 0) {
            return;
        }
        MenuItemModifierPage modifierPage = (MenuItemModifierPage)this.dataModel.getElementAt(0);
        this.setButtonSize(new Dimension(modifierPage.getButtonWidth(), modifierPage.getButtonHeight()));
        Integer cols = modifierPage.getCols();
        MigLayout migLayout = new MigLayout("center,wrap " + cols);
        if (modifierPage.isFlixibleButtonSize().booleanValue()) {
            migLayout.setLayoutConstraints((Object)"fill");
            migLayout.setColumnConstraints((Object)"fill,grow");
            migLayout.setRowConstraints((Object)"fill,grow");
        }
        this.selectionButtonsPanel.setLayout((LayoutManager)migLayout);
        for (int row = 0; row < modifierPage.getRows(); ++row) {
            for (int col = 0; col < modifierPage.getCols(); ++col) {
                MenuItemModifierPageItem itemForCell;
                String constraint = String.format("cell %s %s", col, row);
                if (!modifierPage.isFlixibleButtonSize().booleanValue()) {
                    constraint = constraint + String.format(", w %s!, h %s!", modifierPage.getButtonWidth(), modifierPage.getButtonHeight());
                }
                if ((itemForCell = modifierPage.getItemForCell(col, row)) == null) {
                    this.selectionButtonsPanel.add((Component)new JLabel(), constraint);
                    continue;
                }
                AbstractButton itemButton = this.createItemButton(itemForCell.getMenuModifier());
                if (itemButton == null) continue;
                this.selectionButtonsPanel.add((Component)itemButton, constraint);
            }
        }
        this.revalidate();
        this.repaint();
        this.btnNext.setVisible(this.dataModel.hasNext());
        this.btnPrev.setVisible(this.dataModel.hasPrevious());
    }

    private void renderTitle() {
        String displayName = this.menuModifierGroup.getName();
        String instruction = this.menuModifierGroup.getInstruction();
        int minQuantity = this.menuModifierGroup.getMinQuantity();
        int maxQuantity = this.menuModifierGroup.getMaxQuantity();
        this.titledBorder.setTitle(displayName + Messages.getString("ModifierView.2") + minQuantity + Messages.getString("ModifierView.3") + maxQuantity + (instruction == null ? "" : " " + instruction));
    }

    public void setActionButtonsVisible(boolean b) {
        this.btnClear.setVisible(b);
    }

    @Override
    public void modifierGroupSelected(MenuItemModifierSpec menuModifierGroup) {
        if (menuModifierGroup == null) {
            return;
        }
        if (this.menuModifierGroup != null && menuModifierGroup.getId().equals(this.menuModifierGroup.getId())) {
            return;
        }
        this.menuModifierGroup = menuModifierGroup;
        this.updateView();
    }

    public ModifierGroupView getModifierGroupView() {
        return this.modifierGroupView;
    }

    public Multiplier getSelectedMultiplier() {
        return this.selectedMultiplier;
    }

    @Override
    protected void scrollDown() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
        MenuItemModifierPageDAO.getInstance().loadItems(this.menuModifierGroup, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    @Override
    protected void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        MenuItemModifierPageDAO.getInstance().loadItems(this.menuModifierGroup, this.dataModel);
        this.setDataModel(this.dataModel);
    }

    private class MultiplierButton
    extends POSToggleButton
    implements ActionListener {
        private Multiplier multiplier;

        public MultiplierButton(Multiplier multiplier) {
            Integer textColor;
            this.multiplier = multiplier;
            this.setText(multiplier.getId());
            Integer buttonColor = multiplier.getButtonColor();
            if (buttonColor != null) {
                this.setBackground(new Color(buttonColor));
            }
            if ((textColor = multiplier.getTextColor()) != null) {
                this.setForeground(new Color(textColor));
            }
            this.setBorder(null);
            this.setBorderPainted(false);
            this.addActionListener(this);
        }

        public Multiplier getMultiplier() {
            return this.multiplier;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PizzaModifierView.this.selectedMultiplier = this.multiplier;
            PizzaModifierView.this.updateView();
        }
    }

    private class ModifierButton
    extends PosButton
    implements ActionListener {
        private MenuModifier menuModifier;

        public ModifierButton(MenuModifier modifier, Multiplier multiplier, MenuItemSize menuItemSize) {
            this.menuModifier = modifier;
            this.setText("<html><center>" + modifier.getDisplayName() + "<br/>" + modifier.getPriceForSizeAndMultiplier(menuItemSize, true, multiplier) + "</center></html>");
            if (modifier.getButtonColor() != null) {
                this.setBackground(new Color(modifier.getButtonColor()));
            }
            if (modifier.getTextColor() != null) {
                this.setForeground(new Color(modifier.getTextColor()));
            }
            this.setFocusable(true);
            this.setFocusPainted(true);
            this.addActionListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PizzaModifierView.this.modifierSelectionListener.modifierSelected(this.menuModifier, PizzaModifierView.this.selectedMultiplier);
            if (PizzaModifierView.this.selectedMultiplier == null) {
                PizzaModifierView.this.selectedMultiplier = PizzaModifierView.this.defaultMultiplierButton.getMultiplier();
            }
        }
    }
}

