/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.PosException;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.util.POSUtil;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class PosGiftCardProcessor
implements GiftCardProcessor {
    private GiftCard giftCard;

    @Override
    public void addBalance(GiftCard giftCard) {
        GiftCardDAO.getInstance().saveOrUpdate(giftCard);
    }

    @Override
    public void activate(GiftCard giftCard) {
        GiftCardDAO.getInstance().saveOrUpdate(giftCard);
    }

    @Override
    public void deactivate(GiftCard giftCard) {
        GiftCardDAO.getInstance().saveOrUpdate(giftCard);
    }

    @Override
    public boolean supportActivation() {
        return true;
    }

    @Override
    public boolean supportDeActivation() {
        return true;
    }

    @Override
    public boolean supportPinNumberChange() {
        return true;
    }

    @Override
    public boolean supportDisable() {
        return true;
    }

    @Override
    public boolean supportAddBalance() {
        return true;
    }

    public boolean isValid(String cardNo) {
        this.giftCard = GiftCardDAO.getInstance().findByCardNumber(cardNo);
        if (this.giftCard == null) {
            throw new PosException("Sorry, card is not valid.");
        }
        if (!this.giftCard.isActive().booleanValue()) {
            throw new PosException("Sorry, card is not active.");
        }
        Date today = new Date();
        Date expDate = this.giftCard.getExpiryDate();
        if (today.compareTo(expDate) > 0) {
            throw new PosException("Sorry, card validity has expired!");
        }
        return true;
    }

    @Override
    public double getBalance(String cardNo) throws Exception {
        this.giftCard = GiftCardDAO.getInstance().findByCardNumber(cardNo);
        if (this.giftCard != null) {
            Double cardBalance = this.giftCard.getBalance();
            return cardBalance;
        }
        return 0.0;
    }

    @Override
    public void chargeAmount(PosTransaction transaction) throws Exception {
        Double totalAmount = transaction.getTenderAmount();
        String cardNo = transaction.getGiftCertNumber();
        this.giftCard = GiftCardDAO.getInstance().findByCardNumber(cardNo);
        if (this.giftCard == null) {
            throw new PosException("Sorry, card not found!.");
        }
        Double cardBalance = this.giftCard.getBalance() != null ? POSUtil.getRoundedDouble(this.giftCard.getBalance()) : 0.0;
        if (!this.giftCard.isActive().booleanValue()) {
            throw new PosException("Sorry, card is not active.");
        }
        if (cardBalance <= 0.0) {
            throw new PosException("Gift card balance is 0.");
        }
        Date today = new Date();
        Date expDate = this.giftCard.getExpiryDate();
        if (today.compareTo(expDate) > 0) {
            throw new PosException("Sorry, card validity has expired!");
        }
        if (cardBalance < totalAmount) {
            totalAmount = cardBalance;
            double paidAmount = cardBalance;
            transaction.setAmount(paidAmount);
            transaction.setTenderAmount(paidAmount);
        } else {
            transaction.setAmount(totalAmount);
        }
        Double updatedAmount = cardBalance - totalAmount;
        this.giftCard.setBalance(POSUtil.getRoundedDouble(updatedAmount));
        GiftCardDAO.getInstance().saveOrUpdate(this.giftCard);
    }

    @Override
    public GiftCard getCard(String strGiftCardNumber) {
        GiftCard findByCardNumber = GiftCardDAO.getInstance().findByCardNumber(strGiftCardNumber);
        return findByCardNumber;
    }

    @Override
    public void disable(GiftCard giftCard) {
        GiftCardDAO.getInstance().saveOrUpdate(giftCard);
    }

    @Override
    public void changePinNumber(GiftCard giftCard) {
        GiftCardDAO.getInstance().saveOrUpdate(giftCard);
    }

    @Override
    public boolean supportShowTransaction() {
        return true;
    }

    @Override
    public List<PosTransaction> getTransactionList(String cardNumber, Date fromDate, Date toDate) {
        List<PosTransaction> findTransactionListByGiftCardNumber = PosTransactionDAO.getInstance().findTransactionListByGiftCardNumber(cardNumber, fromDate, toDate);
        return findTransactionListByGiftCardNumber;
    }

    @Override
    public void refund(String cardNo, double amount) throws Exception {
        if (!this.isValid(cardNo)) {
            return;
        }
        this.giftCard.setBalance(this.giftCard.getBalance() + amount);
        GiftCardDAO.getInstance().saveOrUpdate(this.giftCard);
    }

    @Override
    public void validateCardNo(String giftCardNo) throws Exception {
        if (StringUtils.isEmpty((String)giftCardNo)) {
            throw new PosException("Invalid gift card number.");
        }
        GiftCard giftCard = this.getCard(giftCardNo);
        if (giftCard == null) {
            throw new PosException("Invalid gift card number.");
        }
    }
}

