/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.voidticket;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VoidReason;
import com.floreantpos.model.dao.VoidReasonDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.POSComboBox;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.NotesDialog;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.NumberSelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class VoidTicketItemDialog
extends OkCancelOptionDialog {
    private TicketItem ticketItem;
    private POSComboBox cbVoidItemReason;
    private POSToggleButton tbItemWasted;
    private VoidReason voidReason;
    private ComboBoxModel comboBoxModel;
    private NumberSelectionView numberSelectionView;
    private Ticket ticket;

    public VoidTicketItemDialog(Ticket ticket, TicketItem ticketItem) {
        super(POSUtil.getFocusedWindow(), "VOID ITEM");
        this.ticket = ticket;
        this.ticketItem = ticketItem;
        this.inItComponents();
        this.updateView();
    }

    public void inItComponents() {
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Void " + this.ticketItem.getName());
        this.add((Component)titlePanel, "North");
        JPanel centerPanel = new JPanel((LayoutManager)new MigLayout("fill", "[]", "[][][grow]"));
        this.numberSelectionView = new NumberSelectionView();
        this.numberSelectionView.setDecimalAllowed(this.ticketItem.isFractionalUnit());
        this.numberSelectionView.setBorder(null);
        this.numberSelectionView.setVisibleControlsButton(true);
        JLabel lblReason = new JLabel("Void Reason :");
        this.comboBoxModel = new ComboBoxModel();
        this.cbVoidItemReason = new POSComboBox();
        this.cbVoidItemReason.setModel(this.comboBoxModel);
        PosButton addReasonBtn = new PosButton("+");
        addReasonBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VoidTicketItemDialog.this.doAddNewVoidReason();
            }
        });
        this.tbItemWasted = new POSToggleButton("Item Wasted");
        centerPanel.add((Component)lblReason, "wrap");
        centerPanel.add((Component)this.cbVoidItemReason, "growx,split 3");
        centerPanel.add((Component)addReasonBtn, "w 50!");
        centerPanel.add(this.tbItemWasted);
        this.add((Component)centerPanel, "Center");
        centerPanel.add((Component)this.numberSelectionView, "newline,span,grow,center,gaptop 5");
    }

    private void updateView() {
        this.comboBoxModel.setDataList(VoidReasonDAO.getInstance().findAll());
        if (this.cbVoidItemReason.getMaximumRowCount() > 5) {
            this.cbVoidItemReason.setMaximumRowCount(5);
        }
        this.numberSelectionView.setValue(Math.abs(this.ticketItem.getQuantity()));
        if (this.comboBoxModel.getSize() > 0) {
            this.cbVoidItemReason.setSelectedIndex(0);
        }
    }

    private boolean updateModel() {
        try {
            double quantity = Math.abs(this.numberSelectionView.getValue());
            String voidReasonText = null;
            this.voidReason = (VoidReason)this.cbVoidItemReason.getSelectedItem();
            if (this.voidReason != null) {
                voidReasonText = this.voidReason.getReasonText();
            }
            boolean itemWasted = this.tbItemWasted.isSelected();
            this.ticket.voidItem(this.ticketItem, voidReasonText, itemWasted, quantity);
            this.ticketItem.calculatePrice();
            return true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(this, e.getMessage());
            return false;
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, e);
            return false;
        }
    }

    @Override
    public void doOk() {
        if (!this.updateModel()) {
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void doAddNewVoidReason() {
        try {
            NotesDialog noteDialogue = new NotesDialog();
            noteDialogue.setTitle("Add Void Reason");
            noteDialogue.open();
            if (noteDialogue.isCanceled()) {
                return;
            }
            String note = noteDialogue.getNote();
            for (VoidReason voidReason : this.comboBoxModel.getDataList()) {
                if (!voidReason.getReasonText().equalsIgnoreCase(note)) continue;
                this.comboBoxModel.setSelectedItem(voidReason);
                return;
            }
            this.voidReason = new VoidReason();
            this.voidReason.setReasonText(note);
            VoidReasonDAO.getInstance().saveOrUpdate(this.voidReason);
            this.comboBoxModel.addElement(this.voidReason);
            this.comboBoxModel.setSelectedItem(this.voidReason);
        }
        catch (Exception e) {
            POSMessageDialog.showError(this, "Error while creating void reason.", e);
        }
    }
}

