/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.voidticket;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.VoidItem;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.ticket.VoidTicketItemViewerTable;
import com.floreantpos.ui.views.VoidItemFormDialog;
import com.floreantpos.ui.views.order.actions.VoidTicketItemSplitListener;
import com.floreantpos.ui.views.voidticket.VoidItemSplitView;
import com.floreantpos.util.NumberUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class VoidTicketItemView
extends TransparentPanel
implements TableModelListener {
    private Ticket ticket;
    private VoidItemSplitView voidItemSplitView;
    private PosButton btnScrollDown;
    private PosButton btnScrollUp;
    private PosButton btnTransferToTicket1;
    private JScrollPane scrollPane;
    private JTextField tfDiscount;
    private JTextField tfSubtotal;
    private JTextField tfTax;
    private JTextField tfTotal;
    private VoidTicketItemViewerTable ticketViewerTable;
    private VoidTicketItemSplitListener listener;
    private VoidItem voidItem;

    public VoidTicketItemView(VoidTicketItemSplitListener listener) {
        this.listener = listener;
        this.initComponents();
        this.setOpaque(true);
        this.setTicket(this.ticket);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 5));
        this.setBorder(BorderFactory.createTitledBorder(null, "Ticket Item", 2, 0));
        this.setPreferredSize(PosUIManager.getSize(280, 463));
        TransparentPanel ticketTableViewPanel = new TransparentPanel(new BorderLayout(5, 5));
        ticketTableViewPanel.setBorder(new EmptyBorder(0, 5, 0, 0));
        int rightGap = PosUIManager.getSize(60) + 10;
        TransparentPanel ticketTotalPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 2,ins 5 0 5 0,right", "[][]" + rightGap + "", ""));
        TransparentPanel rightButtonPanel = new TransparentPanel((LayoutManager)new MigLayout("wrap 1,fill,hidemode 3,inset 1"));
        JLabel lblSubtotal = new JLabel(POSConstants.SUBTOTAL + ":");
        JLabel lblTotal = new JLabel(POSConstants.TOTAL + ":");
        JLabel lblDiscount = new JLabel(POSConstants.DISCOUNT + ":");
        JLabel lblTax = new JLabel(POSConstants.TAX + ":");
        this.tfSubtotal = new JTextField();
        this.tfSubtotal.setHorizontalAlignment(11);
        this.tfSubtotal.setColumns(10);
        this.tfTax = new JTextField();
        this.tfTax.setHorizontalAlignment(11);
        this.tfTax.setColumns(10);
        this.tfDiscount = new JTextField();
        this.tfDiscount.setHorizontalAlignment(11);
        this.tfDiscount.setColumns(10);
        this.tfTotal = new JTextField();
        this.tfTotal.setHorizontalAlignment(11);
        this.tfTotal.setColumns(10);
        this.btnScrollUp = new PosButton();
        this.btnScrollDown = new PosButton();
        this.btnTransferToTicket1 = new PosButton();
        this.btnTransferToTicket1.setIcon(IconFactory.getIcon("next.png"));
        this.scrollPane = new JScrollPane();
        this.ticketViewerTable = new VoidTicketItemViewerTable();
        lblSubtotal.setHorizontalAlignment(4);
        ticketTotalPanel.add((Component)lblSubtotal, "right");
        this.tfSubtotal.setEditable(false);
        ticketTotalPanel.add(this.tfSubtotal);
        lblTax.setHorizontalAlignment(4);
        ticketTotalPanel.add((Component)lblTax, "right");
        this.tfTax.setEditable(false);
        ticketTotalPanel.add(this.tfTax);
        lblDiscount.setHorizontalAlignment(4);
        ticketTotalPanel.add((Component)lblDiscount, "right");
        this.tfDiscount.setEditable(false);
        ticketTotalPanel.add(this.tfDiscount);
        lblTotal.setHorizontalAlignment(4);
        ticketTotalPanel.add((Component)lblTotal, "right");
        this.tfTotal.setEditable(false);
        ticketTotalPanel.add((Component)this.tfTotal, "wrap");
        this.btnScrollUp.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.btnScrollUp.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnScrollUp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoidTicketItemView.this.doScrollUp(evt);
            }
        });
        rightButtonPanel.add((Component)this.btnScrollUp, "grow");
        this.btnScrollDown.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.btnScrollDown.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnScrollDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoidTicketItemView.this.doScrollDown(evt);
            }
        });
        rightButtonPanel.add((Component)this.btnScrollDown, "grow");
        this.btnTransferToTicket1.setPreferredSize(PosUIManager.getSize(60, 50));
        this.btnTransferToTicket1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                VoidTicketItemView.this.btnTransferToTicket1ActionPerformed();
            }
        });
        rightButtonPanel.add((Component)this.btnTransferToTicket1, "grow");
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setViewportView(this.ticketViewerTable);
        ticketTableViewPanel.add((Component)this.scrollPane, "Center");
        ticketTableViewPanel.add((Component)rightButtonPanel, "East");
        ticketTableViewPanel.add((Component)ticketTotalPanel, "South");
        this.add((Component)ticketTableViewPanel, "Center");
        this.ticketViewerTable.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.ticketViewerTable.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 35));
        this.resizeTableColumns();
    }

    private void resizeTableColumns() {
        this.ticketViewerTable.setAutoResizeMode(4);
        this.setColumnWidth(1, PosUIManager.getSize(50));
        this.setColumnWidth(2, PosUIManager.getSize(50));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.ticketViewerTable.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    private void btnTransferToTicket1ActionPerformed() {
        int selectedRow;
        ITicketItem selectedItem;
        if (this.voidItemSplitView != null && this.voidItemSplitView.isVisible() && (selectedItem = this.ticketViewerTable.get(selectedRow = this.ticketViewerTable.getSelectedRow())) != null && selectedItem instanceof TicketItem) {
            VoidItemFormDialog dialog = new VoidItemFormDialog((TicketItem)selectedItem);
            dialog.pack();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.voidItem = dialog.getVoidItem();
            if (this.voidItem != null) {
                this.listener.voidTicketItemSelected((TicketItem)selectedItem, this, this.voidItemSplitView, this.voidItem);
            }
        }
    }

    private void doScrollDown(ActionEvent evt) {
        this.ticketViewerTable.scrollDown();
    }

    private void doScrollUp(ActionEvent evt) {
        this.ticketViewerTable.scrollUp();
    }

    public void updateView() {
        if (this.ticket == null || this.ticket.getTicketItems() == null || this.ticket.getTicketItems().size() <= 0) {
            this.tfSubtotal.setText("");
            this.tfDiscount.setText("");
            this.tfTax.setText("");
            this.tfTotal.setText("");
            return;
        }
        this.ticket.calculatePrice();
        this.tfSubtotal.setText(NumberUtil.formatNumber(this.ticket.getSubtotalAmount()));
        this.tfDiscount.setText(NumberUtil.formatNumber(this.ticket.getDiscountAmount()));
        this.tfTax.setText(NumberUtil.formatNumber(this.ticket.getTaxAmount()));
        this.tfTotal.setText(NumberUtil.formatNumber(this.ticket.getTotalAmountWithTips()));
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket _ticket) {
        this.ticket = _ticket;
        this.ticketViewerTable.setTicket(_ticket);
        this.updateView();
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        if (this.ticket == null || this.ticket.getTicketItems() == null || this.ticket.getTicketItems().size() <= 0) {
            this.tfSubtotal.setText("");
            this.tfDiscount.setText("");
            this.tfTax.setText("");
            this.tfTotal.setText("");
            return;
        }
        this.ticket.calculatePrice();
        this.tfSubtotal.setText(NumberUtil.formatNumber(this.ticket.getSubtotalAmount()));
        this.tfDiscount.setText(NumberUtil.formatNumber(this.ticket.getDiscountAmount()));
        this.tfTax.setText(NumberUtil.formatNumber(this.ticket.getTaxAmount()));
        this.tfTotal.setText(NumberUtil.formatNumber(this.ticket.getTotalAmountWithTips()));
    }

    public void setVoidItemSplitView(VoidItemSplitView voidItemSplitView) {
        this.voidItemSplitView = voidItemSplitView;
    }

    public VoidTicketItemViewerTable getTicketViewerTable() {
        return this.ticketViewerTable;
    }
}

