/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.StoreAlreadyOpenException;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionControlDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import java.util.Date;

public class StoreUtil {
    public static StoreSession getCurrentStoreSession() {
        StoreSessionControl storeOperation = StoreUtil.getCurrentStoreOperation();
        if (storeOperation == null) {
            return null;
        }
        return storeOperation.getCurrentData();
    }

    public static StoreSessionControl getCurrentStoreOperation() {
        return StoreSessionControlDAO.getInstance().getCurrent();
    }

    public static boolean isStoreOpen() {
        return StoreUtil.getCurrentStoreOperation().getCurrentData() != null;
    }

    public static void openStore(User openByUser) {
        StoreSessionControl currentStoreOperation = StoreUtil.getCurrentStoreOperation();
        if (currentStoreOperation.getCurrentData() != null) {
            throw new StoreAlreadyOpenException("Store is already open.");
        }
        StoreSession data = new StoreSession();
        data.setOpenedBy(openByUser);
        data.setOpenTime(new Date());
        currentStoreOperation.setCurrentData(data);
        SequenceNumber sequenceNumber = SequenceNumberDAO.getInstance().get("TICKET_TOKEN_NUMBER");
        if (sequenceNumber == null) {
            sequenceNumber = new SequenceNumber("TICKET_TOKEN_NUMBER");
        }
        sequenceNumber.setNextSequenceNumber(1);
        TerminalDAO.getInstance().performBatchSave(data, currentStoreOperation, sequenceNumber);
        DataProvider.get().setStoreSession(data);
    }

    public static void closeStore(User closeByUser) throws Exception {
        StoreDAO.getInstance().closeStore(closeByUser);
        DataProvider.get().setStoreSession(null);
    }
}

