/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util.datamigrate;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.config.AppConfig;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import java.awt.Component;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class DatabaseConfigurationView
extends JPanel {
    private POSTextField tfServerAddress;
    private POSTextField tfServerPort;
    private POSTextField tfDatabaseName;
    private POSTextField tfUserName;
    private POSPasswordField tfPassword;
    private JComboBox cbDatabase;
    private JLabel labelComboDBName;
    private JLabel lblServerAddress;
    private JLabel lblServerPort;
    private JLabel lblDbName;
    private JLabel lblUserName;
    private JLabel lblDbPassword;

    public DatabaseConfigurationView() throws HeadlessException {
        this.initUI();
    }

    protected void initUI() {
        Database database;
        this.setLayout((LayoutManager)new MigLayout("fill", "[][fill, grow]", ""));
        this.tfServerAddress = new POSTextField();
        this.tfServerPort = new POSTextField();
        this.tfDatabaseName = new POSTextField();
        this.tfUserName = new POSTextField();
        this.tfPassword = new POSPasswordField();
        this.cbDatabase = new JComboBox();
        ComboBoxModel model = new ComboBoxModel();
        for (Database db : Database.values()) {
            if (db.equals((Object)Database.DERBY_SINGLE)) continue;
            model.addElement((Object)db);
        }
        this.cbDatabase.setModel(model);
        String databaseProviderName = AppConfig.getDatabaseProviderName();
        if (StringUtils.isNotEmpty((String)databaseProviderName) && (database = Database.getByProviderName(databaseProviderName)) != null) {
            this.cbDatabase.setSelectedItem((Object)database);
        }
        this.labelComboDBName = new JLabel(Messages.getString("DatabaseConfigurationDialog.8"));
        this.add(this.labelComboDBName);
        this.add((Component)this.cbDatabase, "grow, wrap");
        this.lblServerAddress = new JLabel(Messages.getString("DatabaseConfigurationDialog.10") + ":");
        this.add(this.lblServerAddress);
        this.add((Component)this.tfServerAddress, "grow, wrap");
        this.lblServerPort = new JLabel(Messages.getString("DatabaseConfigurationDialog.13") + ":");
        this.add(this.lblServerPort);
        this.add((Component)this.tfServerPort, "grow, wrap");
        this.lblDbName = new JLabel(Messages.getString("DatabaseConfigurationDialog.16") + ":");
        this.add(this.lblDbName);
        this.add((Component)this.tfDatabaseName, "grow, wrap");
        this.lblUserName = new JLabel(Messages.getString("DatabaseConfigurationDialog.19") + ":");
        this.add(this.lblUserName);
        this.add((Component)this.tfUserName, "grow, wrap");
        this.lblDbPassword = new JLabel(Messages.getString("DatabaseConfigurationDialog.22") + ":");
        this.add(this.lblDbPassword);
        this.add((Component)this.tfPassword, "grow, wrap");
    }

    public boolean checkSourceField() {
        String server = this.tfServerAddress.getText();
        String port = this.tfServerPort.getText();
        String dbname = this.tfDatabaseName.getText();
        return !StringUtils.isEmpty((String)server) && !StringUtils.isEmpty((String)port) && !StringUtils.isEmpty((String)dbname);
    }

    public boolean checkDestField() {
        String server = this.tfServerAddress.getText();
        String port = this.tfServerPort.getText();
        String dbname = this.tfDatabaseName.getText();
        return !StringUtils.isEmpty((String)server) && !StringUtils.isEmpty((String)port) && !StringUtils.isEmpty((String)dbname);
    }

    public void setFieldValueFromCurrentDB() {
        this.cbDatabase.setSelectedItem((Object)AppConfig.getDefaultDatabase());
        this.tfServerAddress.setText(AppConfig.getDatabaseHost());
        this.tfServerPort.setText(AppConfig.getDatabasePort());
        this.tfDatabaseName.setText(AppConfig.getDatabaseName());
        this.tfUserName.setText(AppConfig.getDatabaseUser());
        this.tfPassword.setText(AppConfig.getDatabasePassword());
    }

    public void setEditableMode(boolean visible) {
        this.cbDatabase.setEnabled(visible);
        this.tfServerAddress.setEditable(visible);
        this.tfServerPort.setEditable(visible);
        this.tfDatabaseName.setEditable(visible);
        this.tfUserName.setEditable(visible);
        this.tfPassword.setEditable(visible);
    }

    public Database getSelectedDatabase() {
        return (Database)((Object)this.cbDatabase.getSelectedItem());
    }

    public String getConnectionString() {
        return this.getSelectedDatabase().getConnectString(this.getTfServerAddress(), this.getTfServerPort(), this.getTfDatabaseName());
    }

    public String getDriverClass() {
        return this.getSelectedDatabase().getHibernateConnectionDriverClass();
    }

    public String getUserName() {
        return this.getTfUserName();
    }

    public String getPassword() {
        return this.getTfPassword();
    }

    public String getTfServerAddress() {
        return this.tfServerAddress.getText();
    }

    public String getTfServerPort() {
        return this.tfServerPort.getText();
    }

    public String getTfDatabaseName() {
        return this.tfDatabaseName.getText();
    }

    public String getTfUserName() {
        return this.tfUserName.getText();
    }

    public String getTfPassword() {
        return this.tfPassword.getText();
    }

    public JComboBox getDatabaseCombo() {
        return this.cbDatabase;
    }
}

