/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util.datamigrate;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.datamigrate.DatabaseConfigurationView;
import com.floreantpos.util.datamigrate.DbConnectionInfo;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Connection;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class MigrateDatabaseConfigurationDialog
extends POSDialog {
    private DatabaseConfigurationView source;
    private DatabaseConfigurationView destination;
    private TitlePanel titlePanel;
    private PosButton btnMigrate;
    private PosButton btnCancel;
    private PosButton btnSourceTest;
    private PosButton btnDestinationTest;
    private JCheckBox checkDestinationDB;
    DbConnectionInfo sourceConnectionInfo;
    DbConnectionInfo destinationConnectionInfo;
    Connection destCon;
    Connection srcCon;

    public MigrateDatabaseConfigurationDialog() throws HeadlessException {
        super((Frame)BackOfficeWindow.getInstance(), true);
        this.addUIListeners();
    }

    @Override
    protected void initUI() {
        this.getContentPane().setLayout(new BorderLayout());
        this.titlePanel = new TitlePanel();
        this.getContentPane().add((Component)this.titlePanel, "North");
        JPanel srcBtnTestPanel = new JPanel();
        this.btnSourceTest = new PosButton(Messages.getString("MigrateDatabaseConfigurationView.2").toUpperCase());
        srcBtnTestPanel.add(this.btnSourceTest);
        JPanel checkboxPanel = new JPanel();
        this.checkDestinationDB = new JCheckBox("Current database");
        this.checkBoxSelectionAction();
        checkboxPanel.add(this.checkDestinationDB);
        JPanel destBtnTestPanel = new JPanel();
        this.btnDestinationTest = new PosButton(Messages.getString("MigrateDatabaseConfigurationView.3").toUpperCase());
        destBtnTestPanel.add(this.btnDestinationTest);
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new GridLayout(1, 1));
        this.source = new DatabaseConfigurationView();
        this.source.setBorder(BorderFactory.createTitledBorder("Source Database"));
        this.source.add((Component)srcBtnTestPanel, "South");
        this.destination = new DatabaseConfigurationView();
        this.destination.setBorder(BorderFactory.createTitledBorder("Destination Database"));
        this.destination.add(checkboxPanel);
        this.destination.add((Component)destBtnTestPanel, "South");
        mainPanel.add(this.source);
        mainPanel.add(this.destination);
        this.getContentPane().add(mainPanel);
        this.btnMigrate = new PosButton(Messages.getString("MigrateDatabaseConfigurationView.0").toUpperCase());
        this.btnCancel = new PosButton(Messages.getString("MigrateDatabaseConfigurationView.1").toUpperCase());
        JPanel buttonPanel = new JPanel(new FlowLayout());
        buttonPanel.add(this.btnMigrate);
        buttonPanel.add(this.btnCancel);
        this.add((Component)buttonPanel, "South");
    }

    private void checkBoxSelectionAction() {
        this.checkDestinationDB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    MigrateDatabaseConfigurationDialog.this.destination.setFieldValueFromCurrentDB();
                    MigrateDatabaseConfigurationDialog.this.destination.setEditableMode(false);
                } else {
                    MigrateDatabaseConfigurationDialog.this.destination.setEditableMode(true);
                }
            }
        });
    }

    private void addUIListeners() {
        this.btnMigrate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MigrateDatabaseConfigurationDialog.this.doMigrate();
            }
        });
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MigrateDatabaseConfigurationDialog.this.doCancel();
            }
        });
        this.btnSourceTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MigrateDatabaseConfigurationDialog.this.doSrcTest();
            }
        });
        this.btnDestinationTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MigrateDatabaseConfigurationDialog.this.doDestTest();
            }
        });
    }

    @Override
    public void setTitle(String title) {
        super.setTitle("Data migration");
        this.titlePanel.setTitle(title);
    }

    public DbConnectionInfo getSourceConnectionInfo() {
        return this.sourceConnectionInfo;
    }

    public void setSourceConnectionInfo(DbConnectionInfo sourceConnectionInfo) {
        this.sourceConnectionInfo = sourceConnectionInfo;
    }

    public DbConnectionInfo getDestinationConnectionInfo() {
        return this.destinationConnectionInfo;
    }

    public void setDestinationConnectionInfo(DbConnectionInfo destinationConnectionInfo) {
        this.destinationConnectionInfo = destinationConnectionInfo;
    }

    public JCheckBox getCheckDestinationDB() {
        return this.checkDestinationDB;
    }

    public void setCheckDestinationDB(JCheckBox checkDestinationDB) {
        this.checkDestinationDB = checkDestinationDB;
    }

    public void updateFieldsValue() {
        try {
            this.sourceConnectionInfo = new DbConnectionInfo();
            this.sourceConnectionInfo.setSelectedDatabase(this.source.getSelectedDatabase());
            this.sourceConnectionInfo.setConnectionString(this.source.getConnectionString());
            this.sourceConnectionInfo.setDriverClass(this.source.getDriverClass());
            this.sourceConnectionInfo.setUserName(this.source.getUserName());
            this.sourceConnectionInfo.setPassword(this.source.getPassword());
            this.destinationConnectionInfo = new DbConnectionInfo();
            this.destinationConnectionInfo.setSelectedDatabase(this.destination.getSelectedDatabase());
            this.destinationConnectionInfo.setConnectionString(this.destination.getConnectionString());
            this.destinationConnectionInfo.setDriverClass(this.destination.getDriverClass());
            this.destinationConnectionInfo.setUserName(this.destination.getUserName());
            this.destinationConnectionInfo.setPassword(this.destination.getPassword());
        }
        catch (Exception e2) {
            PosLog.error(this.getClass(), e2);
            POSMessageDialog.showError(e2.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void doDestTest() {
        try {
            this.updateFieldsValue();
            if (this.destination.checkDestField()) {
                this.destCon = this.destinationConnectionInfo.openConnection();
                if (this.destCon != null) {
                    JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.31"));
                    return;
                }
                JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.32"));
                return;
            }
            JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.43"));
            return;
        }
        catch (Exception e2) {
            PosLog.error(this.getClass(), e2);
            POSMessageDialog.showError(e2.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void doSrcTest() {
        try {
            this.updateFieldsValue();
            if (this.source.checkSourceField()) {
                this.srcCon = this.sourceConnectionInfo.openConnection();
                if (this.srcCon != null) {
                    JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.31"));
                    return;
                }
                JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.32"));
                return;
            }
            JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.42"));
            return;
        }
        catch (Exception e2) {
            PosLog.error(this.getClass(), e2);
            POSMessageDialog.showError(e2.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void doCancel() {
        try {
            this.updateFieldsValue();
            this.setCanceled(true);
            this.dispose();
        }
        catch (Exception e2) {
            PosLog.error(this.getClass(), e2);
            POSMessageDialog.showError(e2.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doMigrate() {
        try {
            this.updateFieldsValue();
            if (!this.source.checkSourceField() && !this.destination.checkDestField()) {
                JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.39"));
                return;
            }
            if (!this.destination.checkDestField()) {
                JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.43"));
                return;
            }
            if (!this.source.checkSourceField()) {
                JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), Messages.getString("DatabaseConfigurationDialog.42"));
                return;
            }
            try {
                if (this.sourceConnectionInfo.openConnection() != null) {
                    // empty if block
                }
            }
            catch (Exception e) {
                POSMessageDialog.showError(Messages.getString("DatabaseConfigurationDialog.42") + "\n" + e.getMessage());
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            try {
                if (this.destinationConnectionInfo.openConnection() != null) {
                    // empty if block
                }
            }
            catch (Exception e) {
                POSMessageDialog.showError(Messages.getString("DatabaseConfigurationDialog.43") + "\n" + e.getMessage());
                this.setCursor(Cursor.getDefaultCursor());
                return;
            }
            this.setCanceled(false);
            this.dispose();
            return;
        }
        catch (Exception e2) {
            PosLog.error(this.getClass(), e2);
            POSMessageDialog.showError(e2.getMessage());
            return;
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }
}

