/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Database;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Address;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.BaseCurrencyDAO;
import com.floreantpos.model.dao.BaseTaxGroupDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.PosWebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.ws.rs.core.GenericEntity;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;

public class CloudSyncDialog
extends POSDialog
implements ActionListener {
    private static final String UPLOAD = "CD";
    private static final String DOWNLOAD = "UD";
    private static final String SAVE = "SAVE";
    private static final String CANCEL = "cancel";
    private static final String TEST = "test";
    private POSTextField tfServerAddress;
    private POSTextField tfStoreId;
    private POSTextField tfUserName;
    private POSPasswordField tfPassword;
    private PosButton btnTestConnection;
    private PosButton btnUpload;
    private PosButton btnDownload;
    private JButton btnCancel;
    private PosButton btnSave;
    private JComboBox databaseCombo;
    private TitlePanel titlePanel;
    private JLabel lblServerAddress;
    private JLabel lblStoreId;
    private JLabel lblUserName;
    private JLabel lblUserPassword;
    private boolean connectionSuccess;
    private JLabel lblConnectionStatus;
    private JProgressBar pbSync;
    private JLabel progressStatus;
    private JTabbedPane tabbedPane;
    private JPanel configPanel;

    public CloudSyncDialog() throws HeadlessException {
        super(POSUtil.getBackOfficeWindow());
        this.setFieldValues();
        this.addUIListeners();
    }

    @Override
    public void setVisible(boolean b) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CloudSyncDialog.this.checkConnection(false);
            }
        });
        super.setVisible(b);
    }

    @Override
    protected void initUI() {
        this.tabbedPane = new JTabbedPane();
        JPanel cloudTabPanel = new JPanel((LayoutManager)new MigLayout("inset 5 20 20 20,fill,hidemode 3"));
        JPanel cloudButtonPanel = new JPanel();
        cloudButtonPanel.setLayout((LayoutManager)new MigLayout("fill"));
        cloudTabPanel.add((Component)cloudButtonPanel, "growx,span");
        this.tabbedPane.addTab("Download/Upload", cloudTabPanel);
        this.lblConnectionStatus = new JLabel();
        this.lblConnectionStatus.setFont(new Font("Arial", 1, 20));
        this.pbSync = new JProgressBar();
        this.pbSync.setValue(0);
        this.pbSync.setMaximum(100);
        this.pbSync.setStringPainted(true);
        this.pbSync.setPreferredSize(new Dimension(0, 30));
        this.progressStatus = new JLabel("Click download/upload to sync with server.");
        this.pbSync.setVisible(false);
        this.btnCancel = new JButton(Messages.getString("DatabaseConfigurationDialog.28").toUpperCase());
        this.btnCancel.setActionCommand(CANCEL);
        cloudTabPanel.add((Component)new JSeparator(), "newline,grow");
        cloudTabPanel.add((Component)this.progressStatus, "right,newline,split 2");
        cloudTabPanel.add((Component)this.pbSync, "grow");
        cloudTabPanel.add((Component)new JLabel("Connection Status:"), "newline,split 3");
        cloudTabPanel.add(this.lblConnectionStatus);
        this.lblStoreId = new JLabel("Store Id:");
        this.lblStoreId.setFont(new Font("Arial", 1, 16));
        this.lblStoreId.setForeground(Color.GRAY);
        cloudTabPanel.add((Component)this.lblConnectionStatus, "grow");
        cloudTabPanel.add((Component)this.lblStoreId, "right,grow");
        cloudTabPanel.add((Component)new JSeparator(), "newline,grow");
        cloudTabPanel.add((Component)this.btnCancel, "newline,center,span");
        this.configPanel = new JPanel();
        this.configPanel.setLayout((LayoutManager)new MigLayout("fill", "[][fill, grow]", ""));
        this.titlePanel = new TitlePanel();
        this.tfServerAddress = new POSTextField();
        this.tfStoreId = new POSTextField();
        this.tfUserName = new POSTextField();
        this.tfPassword = new POSPasswordField();
        this.databaseCombo = new JComboBox<Database>(Database.values());
        String databaseProviderName = AppConfig.getDatabaseProviderName();
        if (StringUtils.isNotEmpty((String)databaseProviderName)) {
            this.databaseCombo.setSelectedItem((Object)Database.getByProviderName(databaseProviderName));
        }
        this.updateTitle();
        this.configPanel.add((Component)this.titlePanel, "span, grow, wrap");
        this.lblServerAddress = new JLabel("Server Address:");
        this.configPanel.add(this.lblServerAddress);
        this.configPanel.add((Component)this.tfServerAddress, "grow, wrap");
        JLabel lblStoreId = new JLabel("Store Id:");
        this.lblUserName = new JLabel("Username:");
        this.configPanel.add(new JLabel("Store Id:"));
        this.configPanel.add((Component)this.tfStoreId, "grow, wrap");
        this.configPanel.add(this.lblUserName);
        this.configPanel.add((Component)this.tfUserName, "grow, wrap");
        this.lblUserPassword = new JLabel("Password:");
        this.configPanel.add(this.lblUserPassword);
        this.configPanel.add((Component)this.tfPassword, "grow, wrap");
        this.configPanel.add((Component)new JSeparator(), "span, grow, gaptop 10");
        this.btnTestConnection = new PosButton(Messages.getString("DatabaseConfigurationDialog.26").toUpperCase());
        this.btnTestConnection.setActionCommand(TEST);
        this.btnSave = new PosButton(Messages.getString("DatabaseConfigurationDialog.27").toUpperCase());
        this.btnSave.setActionCommand(SAVE);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("inset 0, fill", "grow", ""));
        this.btnUpload = new PosButton("UPLOAD");
        this.btnUpload.setActionCommand(UPLOAD);
        this.btnDownload = new PosButton("DOWNLOAD");
        this.btnDownload.setActionCommand(DOWNLOAD);
        this.btnDownload.setIcon(IconFactory.getIcon("/ui_icons/", "page-down.png"));
        this.btnUpload.setIcon(IconFactory.getIcon("/ui_icons/", "page-up.png"));
        JButton btnSetting = new JButton(IconFactory.getIcon("/ui_icons/", "backoffice.png"));
        btnSetting.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                POSDialog dialog = new POSDialog(POSUtil.getFocusedWindow());
                dialog.add(CloudSyncDialog.this.configPanel);
                dialog.setSize(CloudSyncDialog.this.getSize());
                dialog.open();
            }
        });
        this.btnDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final Worker worker = new Worker();
                worker.setActionCommand(CloudSyncDialog.DOWNLOAD);
                worker.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent pcEvt) {
                        if ("progress".equals(pcEvt.getPropertyName())) {
                            CloudSyncDialog.this.pbSync.setValue((Integer)pcEvt.getNewValue());
                        } else if (pcEvt.getNewValue() == SwingWorker.StateValue.DONE) {
                            try {
                                worker.get();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
                worker.execute();
            }
        });
        this.btnUpload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final Worker worker = new Worker();
                worker.setActionCommand(CloudSyncDialog.UPLOAD);
                worker.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent pcEvt) {
                        if ("progress".equals(pcEvt.getPropertyName())) {
                            CloudSyncDialog.this.pbSync.setValue((Integer)pcEvt.getNewValue());
                        } else if (pcEvt.getNewValue() == SwingWorker.StateValue.DONE) {
                            try {
                                worker.get();
                            }
                            catch (InterruptedException | ExecutionException e) {
                                e.printStackTrace();
                            }
                        }
                    }
                });
                worker.execute();
            }
        });
        cloudButtonPanel.add((Component)btnSetting, "right,wrap");
        cloudButtonPanel.add((Component)this.btnDownload, "split 2,gaptop 20,center");
        cloudButtonPanel.add(this.btnUpload);
        PosButton btnExit = new PosButton("EXIT");
        btnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudSyncDialog.this.closeConfigDialog();
            }
        });
        cloudButtonPanel.add(btnExit);
        buttonPanel.add(this.btnTestConnection);
        buttonPanel.add(this.btnSave);
        buttonPanel.add(btnExit);
        this.configPanel.add((Component)buttonPanel, "span,right");
        this.add(this.tabbedPane);
    }

    private void closeConfigDialog() {
        Window windowAncestor = SwingUtilities.getWindowAncestor(this.configPanel);
        if (windowAncestor instanceof POSDialog) {
            ((POSDialog)windowAncestor).setCanceled(false);
            windowAncestor.dispose();
        }
    }

    private void addUIListeners() {
        this.btnTestConnection.addActionListener(this);
        this.btnUpload.addActionListener(this);
        this.btnSave.addActionListener(this);
        this.btnCancel.addActionListener(this);
        this.btnDownload.addActionListener(this);
    }

    private void setFieldValues() {
        Store store = Application.getInstance().getStore();
        this.tfServerAddress.setText(store.getProperty("web.service.url"));
        this.tfStoreId.setText(store.getProperty("web.service.schema"));
        this.tfUserName.setText(store.getProperty("web.service.username"));
        this.tfPassword.setText(store.getProperty("web.service.password"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            String command = e.getActionCommand();
            if (CANCEL.equalsIgnoreCase(command)) {
                this.dispose();
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (TEST.equalsIgnoreCase(command)) {
                this.connectionSuccess = this.checkConnection(false);
                if (!this.connectionSuccess) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.32"));
                } else {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.31"));
                }
            } else if (SAVE.equalsIgnoreCase(command)) {
                this.checkConnection(true);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Successfully saved.");
                this.closeConfigDialog();
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
            POSMessageDialog.showMessage(this, e2.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void updateTitle() {
        super.setTitle("Sync with cloud");
        this.titlePanel.setTitle("Please enter server information.");
    }

    private boolean checkConnection(boolean updateStore) {
        String status;
        String[] statusInfo;
        String service_url = this.tfServerAddress.getText();
        String storeId = this.tfStoreId.getText();
        String userName = this.tfUserName.getText();
        String password = new String(this.tfPassword.getPassword());
        if (updateStore) {
            Store store = Application.getInstance().getStore();
            store.addProperty("web.service.url", service_url);
            store.addProperty("web.service.schema", storeId);
            store.addProperty("web.service.username", userName);
            store.addProperty("web.service.password", password);
            StoreDAO.getInstance().saveOrUpdate(store);
        }
        if ((statusInfo = (status = PosWebService.checkConnection(service_url, storeId, userName, password)).split(",")).length > 0) {
            if (statusInfo[0].equals("success")) {
                if (updateStore && statusInfo.length > 1) {
                    System.out.println("Connected");
                }
                this.lblConnectionStatus.setText("Connected");
                this.lblConnectionStatus.setForeground(Color.GREEN);
                this.lblStoreId.setText("Store Id: " + storeId);
                return true;
            }
            this.lblConnectionStatus.setText(statusInfo[1]);
            this.lblConnectionStatus.setForeground(Color.RED);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveData() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                long version;
                String id;
                _RootDAO dao;
                this.pbSync.setVisible(true);
                this.pbSync.setValue(0);
                this.progressStatus.setForeground(Color.BLUE);
                this.progressStatus.setText("Downloading taxes..");
                List<Tax> taxes = PosWebService.getTaxes();
                for (Tax item : taxes) {
                    TaxDAO dao2 = TaxDAO.getInstance();
                    Tax existingItem = dao2.get(item.getId());
                    if (existingItem != null) {
                        String id2 = existingItem.getId();
                        long version2 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id2);
                        existingItem.setVersion(version2);
                        dao2.update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    dao2.save(item);
                }
                this.pbSync.setValue(5);
                List<TaxGroup> taxGroups = PosWebService.getTaxGroups();
                for (TaxGroup item : taxGroups) {
                    ArrayList<Tax> existingsTax = new ArrayList<Tax>();
                    if (item.getTaxes() != null) {
                        for (Tax tax : item.getTaxes()) {
                            Tax existingTax = TaxDAO.getInstance().get(tax.getId());
                            if (existingsTax == null) continue;
                            existingsTax.add(existingTax);
                        }
                    }
                    item.setTaxes(existingsTax);
                    dao = TaxGroupDAO.getInstance();
                    TaxGroup existingItem = ((BaseTaxGroupDAO)dao).get(item.getId());
                    if (existingItem != null) {
                        id = existingItem.getId();
                        version = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id);
                        existingItem.setVersion(version);
                        ((BaseTaxGroupDAO)dao).update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    ((BaseTaxGroupDAO)dao).save(item);
                }
                this.pbSync.setValue(10);
                this.progressStatus.setText("Downloading currencies..");
                List<Currency> currencyList = PosWebService.getCurrencies();
                for (Currency item : currencyList) {
                    dao = CurrencyDAO.getInstance();
                    Currency existingItem = ((BaseCurrencyDAO)dao).get(item.getId());
                    if (existingItem != null) {
                        id = existingItem.getId();
                        version = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id);
                        existingItem.setVersion(version);
                        ((BaseCurrencyDAO)dao).update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    ((BaseCurrencyDAO)dao).save(item);
                }
                this.pbSync.setValue(15);
                this.progressStatus.setText("Downloading outlets..");
                List<Outlet> outletList = PosWebService.getOutlets();
                for (Outlet item : outletList) {
                    OutletDAO dao3 = OutletDAO.getInstance();
                    Outlet existingItem = dao3.get(item.getId());
                    if (existingItem != null) {
                        String id3 = existingItem.getId();
                        long version3 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id3);
                        existingItem.setVersion(version3);
                        dao3.update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    dao3.save(item);
                }
                this.pbSync.setValue(20);
                this.progressStatus.setText("Downloading departments..");
                List<Department> departments = PosWebService.getDepartments();
                for (Department item : departments) {
                    DepartmentDAO dao4 = DepartmentDAO.getInstance();
                    Department existingItem = dao4.get(item.getId());
                    if (existingItem != null) {
                        String id4 = existingItem.getId();
                        long version4 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id4);
                        existingItem.setVersion(version4);
                        dao4.update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    dao4.save(item);
                }
                this.pbSync.setValue(25);
                this.progressStatus.setText("Downloading sales area..");
                List<SalesArea> salesAreaList = PosWebService.getSalesArea();
                for (SalesArea item : salesAreaList) {
                    SalesAreaDAO dao5 = SalesAreaDAO.getInstance();
                    SalesArea existingItem = dao5.get(item.getId());
                    if (existingItem != null) {
                        String id5 = existingItem.getId();
                        long version5 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id5);
                        existingItem.setVersion(version5);
                        dao5.update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    dao5.save(item);
                }
                this.pbSync.setValue(30);
                this.progressStatus.setText("Downloading order types..");
                List<OrderType> ordertypeList = PosWebService.getOrderTypes();
                for (OrderType item : ordertypeList) {
                    OrderTypeDAO dao6 = OrderTypeDAO.getInstance();
                    OrderType existingItem = dao6.get(item.getId());
                    if (existingItem != null) {
                        String id6 = existingItem.getId();
                        long version6 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id6);
                        existingItem.setVersion(version6);
                        dao6.update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    dao6.save(item);
                }
                this.pbSync.setValue(40);
                this.progressStatus.setText("Downloading terminal type..");
                this.pbSync.setValue(65);
                this.progressStatus.setText("Downloading menu categories..");
                List<MenuCategory> menuCategories = PosWebService.getMenuCategories();
                for (MenuCategory item : menuCategories) {
                    MenuCategoryDAO dao7 = MenuCategoryDAO.getInstance();
                    MenuCategory existingItem = dao7.get(item.getId());
                    if (existingItem != null) {
                        String id7 = existingItem.getId();
                        long version7 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id7);
                        existingItem.setVersion(version7);
                        dao7.update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    dao7.save(item);
                }
                this.pbSync.setValue(70);
                this.progressStatus.setText("Downloading menu groups..");
                List<MenuGroup> menuGroups = PosWebService.getMenuGroups();
                for (MenuGroup item : menuGroups) {
                    MenuGroupDAO dao8 = MenuGroupDAO.getInstance();
                    MenuGroup existingItem = dao8.get(item.getId());
                    if (existingItem != null) {
                        String id8 = existingItem.getId();
                        long version8 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id8);
                        existingItem.setVersion(version8);
                        dao8.update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    dao8.save(item);
                }
                this.pbSync.setValue(75);
                this.progressStatus.setText("Downloading menu items..");
                List<MenuItem> menuItems = PosWebService.getMenuItems();
                for (MenuItem item : menuItems) {
                    MenuItemDAO dao9 = MenuItemDAO.getInstance();
                    MenuItem existingItem = dao9.get(item.getId());
                    if (existingItem != null) {
                        String id9 = existingItem.getId();
                        long version9 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id9);
                        existingItem.setVersion(version9);
                        dao9.update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    dao9.save(item);
                }
                this.pbSync.setValue(80);
                this.progressStatus.setText("Downloading modifier groups..");
                List<ModifierGroup> modifierGroups = PosWebService.getModifierGroups();
                for (ModifierGroup item : modifierGroups) {
                    ModifierGroupDAO dao10 = ModifierGroupDAO.getInstance();
                    ModifierGroup existingItem = dao10.get(item.getId());
                    if (existingItem != null) {
                        String id10 = existingItem.getId();
                        long version10 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id10);
                        existingItem.setVersion(version10);
                        dao10.update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    dao10.save(item);
                }
                this.pbSync.setValue(85);
                this.progressStatus.setText("Downloading modifiers..");
                List<MenuModifier> menuModifiers = PosWebService.getMenuModifiers();
                for (MenuModifier item : menuModifiers) {
                    MenuModifierDAO dao11 = MenuModifierDAO.getInstance();
                    MenuModifier existingItem = dao11.get(item.getId());
                    if (existingItem != null) {
                        String id11 = existingItem.getId();
                        long version11 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id11);
                        existingItem.setVersion(version11);
                        dao11.update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    dao11.save(item);
                }
                this.pbSync.setValue(90);
                this.progressStatus.setText("Downloading price list..");
                List<PriceShift> priceShifts = PosWebService.getPriceShift();
                for (PriceShift item : priceShifts) {
                    PriceShiftDAO dao12 = PriceShiftDAO.getInstance();
                    Shift existingItem = ShiftDAO.getInstance().findByName(item.getName());
                    if (existingItem != null) continue;
                    dao12.save(item);
                }
                List<PriceTable> priceList = PosWebService.getPriceList();
                for (PriceTable item : priceList) {
                    List<PriceTableItem> priceTableItems;
                    PriceTableDAO dao13 = PriceTableDAO.getInstance();
                    PriceTable existingItem = PriceTableDAO.getInstance().get(item.getId());
                    if (existingItem != null) {
                        String id12 = existingItem.getId();
                        long version12 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id12);
                        existingItem.setVersion(version12);
                        dao13.update(existingItem);
                    } else {
                        item.setVersion(0L);
                        dao13.save(item);
                    }
                    if ((priceTableItems = item.getPriceTableItems()) == null) continue;
                    for (PriceTableItem priceTableItem : priceTableItems) {
                        PriceTableItem existingPriceTableItem = PriceTableItemDAO.getInstance().get(priceTableItem.getId());
                        if (existingPriceTableItem != null) {
                            String id13 = existingPriceTableItem.getId();
                            long version13 = existingItem.getVersion();
                            PropertyUtils.copyProperties((Object)existingPriceTableItem, (Object)priceTableItem);
                            existingPriceTableItem.setId(id13);
                            existingPriceTableItem.setVersion(version13);
                            PriceTableItemDAO.getInstance().update(existingPriceTableItem);
                            continue;
                        }
                        priceTableItem.setVersion(0L);
                        PriceTableItemDAO.getInstance().save(priceTableItem);
                    }
                }
                List<PriceRule> priceRules = PosWebService.getPriceRules();
                for (PriceRule item : priceRules) {
                    PriceShift priceShift = item.getPriceShift();
                    if (priceShift != null) {
                        item.setPriceShift((PriceShift)ShiftDAO.getInstance().findByName(priceShift.getName()));
                    }
                    PriceRuleDAO dao14 = PriceRuleDAO.getInstance();
                    PriceRule existingItem = PriceRuleDAO.getInstance().get(item.getId());
                    if (existingItem != null) {
                        String id14 = existingItem.getId();
                        long version14 = existingItem.getVersion();
                        PropertyUtils.copyProperties((Object)existingItem, (Object)item);
                        existingItem.setId(id14);
                        existingItem.setVersion(version14);
                        dao14.update(existingItem);
                        continue;
                    }
                    item.setVersion(0L);
                    dao14.save(item);
                }
                this.pbSync.setValue(100);
                this.progressStatus.setText("Download complete");
            }
            catch (Exception ex) {
                ex.printStackTrace();
                this.progressStatus.setText("Download failed .");
                this.progressStatus.setForeground(Color.RED);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            POSMessageDialog.showError("Download Failed");
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void uploadData() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.progressStatus.setForeground(Color.BLUE);
            this.pbSync.setVisible(true);
            this.pbSync.setValue(5);
            this.uploadOutlet();
            this.uploadTaxes();
            this.uploadMenuCategories();
            this.uploadMenuModifier();
            this.uploadModifierGroup();
            this.uploadMenuGroup();
            this.uploadMenuItems();
            this.uploadCustomer();
            this.uploadOrderType();
            this.uploadDepartment();
            this.uploadUserType();
            this.uploadUsers();
            this.progressStatus.setText("Uploading store session data..");
            List<StoreSession> storeSessions = StoreSessionDAO.getInstance().findAll();
            PosWebService.uploadStoreSessionData(storeSessions);
            this.pbSync.setValue(100);
            this.progressStatus.setText("Upload complete");
            this.progressStatus.setForeground(Color.GREEN);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.progressStatus.setForeground(Color.RED);
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Upload Failed");
            this.pbSync.setValue(0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void uploadMenuItems() {
        ArrayList<String> menuItemsIds = new ArrayList<String>();
        List<MenuItem> menuItems = MenuItemDAO.getInstance().findAllUnSyncMenuItems();
        if (menuItems != null && !menuItems.isEmpty()) {
            this.progressStatus.setText("Uploading menuitems..");
            for (MenuItem menuItem : menuItems) {
                menuItemsIds.add(menuItem.getId());
                this.makeXMLTransient(menuItem);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<MenuItem>>(menuItems){}, "menuitem");
                this.pbSync.setValue(50);
                MenuItemDAO.getInstance().updateMenuItemSync(menuItemsIds, Boolean.TRUE);
            }
            catch (Exception e) {
                String message = "Uploading menuitems failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void makeXMLTransient(MenuItem menuItem) {
        MenuItemDAO.getInstance().initialize(menuItem);
        String parentMenuItemId = menuItem.getParentMenuItemId();
        menuItem.setStockUnits(null);
        menuItem.setComboGroups(null);
        menuItem.setComboItems(null);
        menuItem.setParentMenuItem(null);
        menuItem.setParentMenuItemId(parentMenuItemId);
        menuItem.setPizzaPriceList(null);
        menuItem.setAttributes(null);
        menuItem.setMenuItemModiferSpecs(null);
        menuItem.setPrinterGroup(null);
        menuItem.setVariants(null);
        MenuGroup menuGroup = menuItem.getParent();
        if (menuGroup != null) {
            MenuCategory itemCategory = menuGroup.getParent();
            MenuCategory category = new MenuCategory();
            if (itemCategory != null) {
                try {
                    PropertyUtils.copyProperties((Object)category, (Object)itemCategory);
                    category.setDepartments(null);
                    category.setOrderTypes(null);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
            menuGroup.setParent(category);
        }
    }

    private void uploadModifierGroup() {
        ArrayList<String> modifierGroupIds = new ArrayList<String>();
        List<ModifierGroup> modifierGroups = ModifierGroupDAO.getInstance().findAllUnSyncModifierGroup();
        if (modifierGroups != null && !modifierGroups.isEmpty()) {
            for (ModifierGroup modifierGroup : modifierGroups) {
                modifierGroupIds.add(modifierGroup.getId());
                this.makeXMLTransient(modifierGroup);
            }
            this.progressStatus.setText("Uploading modifier groups..");
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<ModifierGroup>>(modifierGroups){}, "modifiergroup");
                this.pbSync.setValue(40);
                ModifierGroupDAO.getInstance().updateModifierGroupSync(modifierGroupIds, Boolean.TRUE);
            }
            catch (Exception e) {
                String message = "Uploading modifier groups failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void makeXMLTransient(ModifierGroup modifierGroup) {
        modifierGroup.setModifiers(null);
    }

    private void uploadMenuModifier() {
        ArrayList<String> menuModifierIds = new ArrayList<String>();
        List<MenuModifier> menuModifiers = MenuModifierDAO.getInstance().findAllUnSyncMenuModifier();
        if (menuModifiers != null && !menuModifiers.isEmpty()) {
            this.progressStatus.setText("Uploading menu modifiers..");
            for (MenuModifier menuModifier : menuModifiers) {
                menuModifierIds.add(menuModifier.getId());
                this.makeXMLTransient(menuModifier);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<MenuModifier>>(menuModifiers){}, "modifier");
                this.pbSync.setValue(35);
                MenuModifierDAO.getInstance().updateMenuModifierSync(menuModifierIds, Boolean.TRUE);
            }
            catch (Exception e) {
                String message = "Uploading menu modifiers failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void makeXMLTransient(MenuModifier menuModifier) {
        menuModifier.setMultiplierPriceList(null);
        menuModifier.setMenuItemModifierGroup(null);
        menuModifier.setPizzaModifierPriceList(null);
    }

    private void uploadMenuGroup() {
        ArrayList<String> menuGroupIds = new ArrayList<String>();
        List<MenuGroup> menuGroups = MenuGroupDAO.getInstance().findAllUnSyncMenuGroup();
        if (menuGroups != null && !menuGroups.isEmpty()) {
            for (MenuGroup menuGroup : menuGroups) {
                menuGroupIds.add(menuGroup.getId());
                this.makeXMLTransient(menuGroup);
            }
            this.progressStatus.setText("Uploading menu groups..");
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<MenuGroup>>(menuGroups){}, "menugroup");
                this.pbSync.setValue(45);
                MenuGroupDAO.getInstance().updateMenuGroupSync(menuGroupIds, true);
            }
            catch (Exception e) {
                String message = "Uploading menu groups failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void makeXMLTransient(MenuGroup menuGroup) {
        menuGroup.setMenuPages(null);
        MenuCategory menuCategory = menuGroup.getParent();
        menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
        if (menuCategory != null) {
            this.makeXMLTransient(menuCategory);
        }
    }

    private void uploadMenuCategories() {
        ArrayList<String> menuCategoryIds = new ArrayList<String>();
        List<MenuCategory> menuCategories = MenuCategoryDAO.getInstance().findAllUnSyncMenuCategory();
        if (menuCategories != null && !menuCategories.isEmpty()) {
            this.progressStatus.setText("Uploading menu categories..");
            for (MenuCategory menuCategory : menuCategories) {
                menuCategoryIds.add(menuCategory.getId());
                this.makeXMLTransient(menuCategory);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<MenuCategory>>(menuCategories){}, "menucategory");
                this.pbSync.setValue(30);
                MenuCategoryDAO.getInstance().updateMenuCategoriesSync(menuCategoryIds, true);
            }
            catch (Exception e) {
                String message = "Uploading menu categories failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void makeXMLTransient(MenuCategory menuCategory) {
        menuCategory.setDepartments(null);
        menuCategory.setMenuGroups(null);
        menuCategory.setMenuShifts(null);
        menuCategory.setOrderTypes(null);
        menuCategory.setTerminalTypes(null);
    }

    private void uploadOutlet() {
        String message;
        ArrayList<Outlet> outlets = new ArrayList<Outlet>();
        ArrayList<Address> addresses = new ArrayList<Address>();
        Store thisStore = StoreDAO.getRestaurant();
        Outlet outlet = OutletDAO.getInstance().get(String.valueOf(thisStore.getUniqueId()));
        if (thisStore.getAddress() == null) {
            throw new PosException("Address cannot be null");
        }
        String addressId = thisStore.getAddress().getId();
        Address address = AddressDAO.getInstance().findAddressById(addressId);
        if (outlet == null) {
            outlet = new Outlet();
            outlet.setId(String.valueOf(thisStore.getUniqueId()));
            outlet.setName(thisStore.getOutletName());
            OutletDAO.getInstance().save(outlet);
            List<Terminal> terminals = TerminalDAO.getInstance().findAll();
            if (terminals != null) {
                for (Terminal terminal : terminals) {
                    terminal.setOutlet(outlet);
                    TerminalDAO.getInstance().saveOrUpdate(terminal);
                }
            }
        } else {
            OutletDAO.getInstance().initialize(outlet);
            outlet.setId(String.valueOf(thisStore.getUniqueId()));
            outlet.setName(thisStore.getOutletName());
        }
        addresses.add(address);
        if (addresses != null && !addresses.isEmpty()) {
            this.progressStatus.setText("Uploading address..");
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Address>>(addresses){}, "address");
                this.pbSync.setValue(10);
            }
            catch (Exception e) {
                message = "Uploading address failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
        outlet.setAddressId(address.getId());
        outlet.setDepartments(null);
        outlets.add(outlet);
        if (outlets != null && !outlets.isEmpty()) {
            this.progressStatus.setText("Uploading outlet..");
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Outlet>>(outlets){}, "outlet");
                this.pbSync.setValue(15);
            }
            catch (Exception e) {
                message = "Uploading outlet failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void uploadTaxes() {
        ArrayList<String> taxIds = new ArrayList<String>();
        List<Tax> unSynctaxes = TaxDAO.getInstance().findAllUnSyncTax();
        if (unSynctaxes != null && !unSynctaxes.isEmpty()) {
            this.progressStatus.setText("Uploading taxes..");
            for (Tax tax : unSynctaxes) {
                taxIds.add(tax.getId());
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Tax>>(unSynctaxes){}, "tax");
                this.pbSync.setValue(20);
                TaxDAO.getInstance().updateTaxSync(taxIds, true);
            }
            catch (Exception e) {
                String message = "Uploading tax failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
        ArrayList<String> taxGroupIds = new ArrayList<String>();
        List<TaxGroup> unSyncTaxGroups = TaxGroupDAO.getInstance().findAllUnSyncTaxGroup();
        if (unSyncTaxGroups != null && !unSyncTaxGroups.isEmpty()) {
            this.progressStatus.setText("Uploading tax group ..");
            for (TaxGroup taxGroup : unSyncTaxGroups) {
                taxGroupIds.add(taxGroup.getId());
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<TaxGroup>>(unSyncTaxGroups){}, "taxgroup");
                this.pbSync.setValue(25);
                TaxGroupDAO.getInstance().updateTaxGroupSync(taxGroupIds, true);
            }
            catch (Exception e) {
                String message = "Uploading tax group failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void uploadCustomer() {
        ArrayList<String> customerIds = new ArrayList<String>();
        List<Customer> unSyncCustomers = CustomerDAO.getInstance().findAllUnSyncCustomer();
        if (unSyncCustomers != null && !unSyncCustomers.isEmpty()) {
            this.progressStatus.setText("Uploading Customer..");
            for (Customer customer : unSyncCustomers) {
                customerIds.add(customer.getId());
                CloudSyncDialog.makeXMLTransient(customer);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Customer>>(unSyncCustomers){}, "customer");
                this.pbSync.setValue(55);
                CustomerDAO.getInstance().updateCustomerSync(customerIds, true);
            }
            catch (Exception e) {
                String message = "Uploading customer failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void uploadOrderType() {
        ArrayList<String> orderTypeIds = new ArrayList<String>();
        List<OrderType> unSyncOrderTypes = OrderTypeDAO.getInstance().findAllUnSyncOrderType();
        if (unSyncOrderTypes != null && !unSyncOrderTypes.isEmpty()) {
            this.progressStatus.setText("Uploading OrderType..");
            for (OrderType orderType : unSyncOrderTypes) {
                orderTypeIds.add(orderType.getId());
                CloudSyncDialog.makeXMLTransient(orderType);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<OrderType>>(unSyncOrderTypes){}, "ordertype");
                OrderTypeDAO.getInstance().updateOrderTypeSync(orderTypeIds, true);
                this.pbSync.setValue(60);
            }
            catch (Exception e) {
                String message = "Uploading OrderType failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void uploadDepartment() {
        ArrayList<String> departmentIds = new ArrayList<String>();
        List<Department> unSyncDepartments = DepartmentDAO.getInstance().findAllUnSyncDepartment();
        if (unSyncDepartments != null && !unSyncDepartments.isEmpty()) {
            this.progressStatus.setText("Uploading departments..");
            for (Department department : unSyncDepartments) {
                departmentIds.add(department.getId());
                CloudSyncDialog.makeXMLTransient(department);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Department>>(unSyncDepartments){}, "departments");
                this.pbSync.setValue(65);
                DepartmentDAO.getInstance().updateDepartmentSync(departmentIds, true);
            }
            catch (Exception e) {
                String message = "Uploading departments failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void uploadUserType() {
        ArrayList<String> userTypeIds = new ArrayList<String>();
        List<UserType> unSyncUserTypes = UserTypeDAO.getInstance().findAllUnSyncUserType();
        if (unSyncUserTypes != null && !unSyncUserTypes.isEmpty()) {
            this.progressStatus.setText("Uploading User type ..");
            for (UserType userType : unSyncUserTypes) {
                userTypeIds.add(userType.getId());
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<UserType>>(unSyncUserTypes){}, "usertypes");
                this.pbSync.setValue(70);
                UserTypeDAO.getInstance().updateUserTypeSync(userTypeIds, true);
            }
            catch (Exception e) {
                String message = "Uploading User type failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void uploadUsers() {
        ArrayList<String> userIds = new ArrayList<String>();
        List<User> unSyncUser = UserDAO.getInstance().findAllUnSyncUser();
        if (unSyncUser != null && !unSyncUser.isEmpty()) {
            this.progressStatus.setText("Uploading User..");
            for (User user : unSyncUser) {
                userIds.add(user.getId());
                this.makeXMLTransient(user);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<User>>(unSyncUser){}, "users");
                this.pbSync.setValue(75);
                UserDAO.getInstance().updateUserSync(userIds, true);
            }
            catch (Exception e) {
                String message = "Uploading user failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), message, e);
            }
        }
    }

    private void makeXMLTransient(User user) {
        if (user == null) {
            return;
        }
        user.setCurrentCashDrawer(null);
        user.setLinkedUser(null);
    }

    private static void makeXMLTransient(Department department) {
        if (department == null) {
            return;
        }
        department.setOrderTypes(null);
        department.setOutlets(null);
    }

    private static void makeXMLTransient(OrderType orderType) {
        if (orderType == null) {
            return;
        }
        orderType.setTerminalTypes(null);
        orderType.setCategories(null);
        orderType.setDepartments(null);
    }

    private static void makeXMLTransient(Customer customer) {
        if (customer == null) {
            return;
        }
        customer.setDeliveryAddresses(null);
        customer.setDeliveryInstructions(null);
        customer.setCustomerGroup(null);
    }

    public static CloudSyncDialog show(Frame parent) {
        CloudSyncDialog dialog = new CloudSyncDialog();
        dialog.setSize(PosUIManager.getSize(500, 350));
        dialog.open();
        return dialog;
    }

    class Worker
    extends SwingWorker<Void, Void> {
        String command;

        public void setActionCommand(String command) {
            this.command = command;
        }

        @Override
        protected Void doInBackground() throws Exception {
            CloudSyncDialog.this.btnDownload.setEnabled(false);
            CloudSyncDialog.this.btnUpload.setEnabled(false);
            CloudSyncDialog.this.btnCancel.setEnabled(false);
            if (this.command.equals(CloudSyncDialog.DOWNLOAD)) {
                CloudSyncDialog.this.saveData();
            } else if (this.command.equals(CloudSyncDialog.UPLOAD)) {
                CloudSyncDialog.this.uploadData();
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            CloudSyncDialog.this.pbSync.setVisible(false);
            CloudSyncDialog.this.btnDownload.setEnabled(true);
            CloudSyncDialog.this.btnUpload.setEnabled(true);
            CloudSyncDialog.this.btnCancel.setEnabled(true);
        }
    }
}

