/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service;

import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.config.AppProperties;
import com.floreantpos.main.Application;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.GlassPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.datamatrix.DataMatrixWriter;
import com.google.zxing.datamatrix.encoder.SymbolShapeHint;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.AndroidDevice;
import com.orocube.rest.service.OroService;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.ServiceListener;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.mqtt.NotificationServiceUtils;
import com.orocube.rest.service.mqtt.OroMqttServer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.EnumMap;
import java.util.List;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import jiconfont.IconFont;
import jiconfont.icons.FontAwesome;
import jiconfont.swing.IconFontSwing;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXTable;

public class OroServiceWindow
extends JFrame
implements WindowListener,
ServiceListener {
    private static final String DEFAULT_ANDROID_DEVICES = "default_android_devices";
    private GlassPane glassPane;
    private JLabel lblServiceStatus;
    private OroService service;
    private JButton btnStartService;
    private JButton btnStopService;
    private JButton btnCancel;
    private TitlePanel titledPanel;
    private BeanTableModel<AndroidDevice> tableModel;
    private AndroidDeviceListTable deviceListTable;
    private JPanel centerPanel;
    private JButton btnRemove;
    private JLabel lblQRCode;
    private JComboBox<String> cbIpAddresses;
    private static OroServiceWindow instance;

    private OroServiceWindow() {
        this.initializeComponents();
        this.initTable();
        this.initData();
    }

    private void initializeComponents() {
        System.setProperty("data.provider.class", "com.orocube.rest.service.AndroidDataProvider");
        this.setApplicationLook();
        String appTitle = AppProperties.getAppName() + " " + AppProperties.getAppVersion();
        this.setTitle(appTitle + "- Service Manager");
        this.setDefaultCloseOperation(3);
        this.setTitle(appTitle);
        ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("/icons/icon.png"));
        Application.setApplicationIcon(imageIcon);
        this.setIconImage(imageIcon.getImage());
        this.glassPane = new GlassPane();
        this.glassPane.setOpacity(0.6f);
        this.setGlassPane(this.glassPane);
        JPanel statusBarContainer = new JPanel((LayoutManager)new MigLayout("fillx,ins 5"));
        statusBarContainer.add((Component)new JSeparator(0), "North");
        JPanel infoPanel = new JPanel((LayoutManager)new MigLayout("fillx, ins 5", "[]20px[]20px[]", "[]"));
        infoPanel.setOpaque(true);
        this.lblServiceStatus = new JLabel("Press start button to start service");
        statusBarContainer.add((Component)infoPanel, "growx");
        statusBarContainer.add((Component)this.lblServiceStatus, "right");
        JPanel centerTopPanel = new JPanel((LayoutManager)new MigLayout("right", "sg,fill", ""));
        this.btnStartService = new JButton("Start Service");
        this.btnStartService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (OroServiceWindow.this.service.isRunning()) {
                    POSMessageDialog.showMessage("Service already running.");
                    return;
                }
                OroServiceWindow.this.service.startService();
            }
        });
        this.btnStopService = new JButton("Stop Service");
        this.btnStopService.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OroServiceWindow.this.service.stopService();
            }
        });
        this.btnCancel = new JButton("Shutdown");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OroServiceWindow.this.close();
            }
        });
        centerTopPanel.add((Component)this.btnStartService, "split 3,right");
        centerTopPanel.add((Component)this.btnStopService, "w 120");
        centerTopPanel.add(this.btnCancel);
        centerTopPanel.add((Component)new JSeparator(), "newline,span,growx");
        this.centerPanel = new JPanel(new BorderLayout());
        this.centerPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.centerPanel.add((Component)centerTopPanel, "North");
        this.titledPanel = new TitlePanel();
        this.titledPanel.setTitle("Service not started");
        this.cbIpAddresses = new JComboBox();
        try {
            ComboBoxModel comboBoxModel = new ComboBoxModel(ServiceUtils.getLocalIPAddressList());
            this.cbIpAddresses.setModel(comboBoxModel);
        }
        catch (UnknownHostException e1) {
            PosLog.error(this.getClass(), e1);
        }
        catch (SocketException e1) {
            PosLog.error(this.getClass(), e1);
        }
        JButton btnApply = new JButton("Apply");
        btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Object selectedAddress = OroServiceWindow.this.cbIpAddresses.getSelectedItem();
                if (selectedAddress != null) {
                    OroMqttServer.getInstance().updateStoreProperty("tcp://" + selectedAddress.toString() + ":1883");
                    OroServiceWindow.this.loadBarcode();
                }
            }
        });
        JLabel lblIpAddress = new JLabel("IP Address: ");
        JLabel lblPort = new JLabel("Port: 6565");
        infoPanel.add((Component)lblIpAddress, "split 4");
        infoPanel.add(this.cbIpAddresses);
        infoPanel.add(lblPort);
        infoPanel.add(btnApply);
        this.getContentPane().add((Component)this.titledPanel, "North");
        this.getContentPane().add((Component)this.centerPanel, "Center");
        JPanel bottomActionButtonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        JButton btnApprove = new JButton("Register");
        btnApprove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OroServiceWindow.this.doApproveTerminal();
            }
        });
        this.btnRemove = new JButton("Remove");
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OroServiceWindow.this.doInactiveTerminal();
            }
        });
        JButton btnSendUpdatedData = new JButton("Refresh Mobile Data");
        btnSendUpdatedData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    NotificationServiceUtils.publishUpdatedData();
                }
                catch (Exception ex) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage(), ex);
                }
            }
        });
        bottomActionButtonPanel.add(btnApprove);
        bottomActionButtonPanel.add(this.btnRemove);
        bottomActionButtonPanel.add(btnSendUpdatedData);
        statusBarContainer.add((Component)bottomActionButtonPanel, "North");
        this.getContentPane().add((Component)statusBarContainer, "South");
        this.service = new OroService();
        this.service.setListener(this);
        this.addWindowListener(this);
        this.titledPanel.setTitle("Service Manager");
        this.lblQRCode = new JLabel();
        JPanel qrCodePanel = new JPanel((LayoutManager)new MigLayout("center", "[400]", "[400]"));
        qrCodePanel.setBackground(Color.WHITE);
        qrCodePanel.setBorder(BorderFactory.createTitledBorder(""));
        qrCodePanel.add((Component)this.lblQRCode, "center");
        this.centerPanel.add((Component)qrCodePanel, "East");
        this.setupSizeAndLocation();
    }

    private void initTable() {
        this.tableModel = new BeanTableModel(AndroidDevice.class);
        this.tableModel.addColumn("Terminal ID", "terminalId");
        this.tableModel.addColumn("Device Name", "name");
        this.tableModel.addColumn("Status", "status");
        this.tableModel.addColumn("Connection Status", "connectionStatus", 0, null);
        this.deviceListTable = new AndroidDeviceListTable(this.tableModel);
        this.deviceListTable.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.deviceListTable.setSelectionMode(0);
        this.deviceListTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        this.deviceListTable.setDefaultRenderer(Object.class, new CustomCellRenderer());
        this.deviceListTable.setRowHeight(PosUIManager.getSize(30));
        this.deviceListTable.getColumn(0).setCellRenderer(new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                label.setIcon(null);
                label.setHorizontalAlignment(0);
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        JScrollPane comp = new JScrollPane((Component)((Object)this.deviceListTable));
        this.centerPanel.add(comp);
    }

    private void initData() {
        try {
            this.glassPane.setVisible(true);
            _RootDAO.initialize();
            DataProvider.get().initialize();
            this.refreshDevices();
            this.service.startService();
            OroMqttServer.getInstance().start("service_window_" + TerminalUtil.getSystemUID());
            this.loadBarcode();
            this.updateView();
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            POSMessageDialog.showError("Please check your database connection and try again.");
            this.windowClosed(null);
        }
        finally {
            this.glassPane.setVisible(false);
        }
    }

    private void updateView() {
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.cbIpAddresses.getModel();
        if (comboBoxModel.getSize() > 0) {
            String mqttServerAddress = Application.getInstance().getStore().getProperty("mqtt_server_address");
            for (String ipAddress : comboBoxModel.getDataList()) {
                if (mqttServerAddress == null || !mqttServerAddress.contains(ipAddress)) continue;
                this.cbIpAddresses.setSelectedItem(ipAddress);
                break;
            }
        }
    }

    private void loadBarcode() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OroServiceWindow.this.lblQRCode.setText("Loading...");
                    Store store = StoreDAO.getRestaurant();
                    String text = "<mqttServerAddress>" + store.getProperty("mqtt_server_address") + "</mqttServerAddress>";
                    text = text + "<serverAddress>" + ServiceUtils.getHostAddress() + "</serverAddress>";
                    text = text + "<port>6565</port>";
                    OroServiceWindow.this.lblQRCode.setIcon(OroServiceWindow.generateBarcodeImageIcon(text, 250, 250, "saved.png"));
                }
                catch (Exception e) {
                    PosLog.error(this.getClass(), e);
                }
                finally {
                    OroServiceWindow.this.lblQRCode.setText("");
                }
            }
        }).start();
    }

    private static ImageIcon generateBarcodeImageIcon(String myCodeText, int width, int height, String filePath) throws WriterException, IOException {
        String fileType = "png";
        File myFile = new File(filePath);
        try {
            EnumMap<EncodeHintType, Object> hintMap = new EnumMap<EncodeHintType, Object>(EncodeHintType.class);
            hintMap.put(EncodeHintType.CHARACTER_SET, (Object)"UTF-8");
            hintMap.put(EncodeHintType.DATA_MATRIX_SHAPE, (Object)SymbolShapeHint.FORCE_SQUARE);
            hintMap.put(EncodeHintType.MARGIN, (Object)1);
            hintMap.put(EncodeHintType.ERROR_CORRECTION, (Object)ErrorCorrectionLevel.L);
            DataMatrixWriter codeWriter = new DataMatrixWriter();
            BitMatrix byteMatrix = codeWriter.encode(myCodeText, BarcodeFormat.DATA_MATRIX, width, height);
            int CrunchifyWidth = byteMatrix.getWidth();
            BufferedImage image = new BufferedImage(CrunchifyWidth, CrunchifyWidth, 2);
            image.createGraphics();
            Graphics2D graphics = (Graphics2D)image.getGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, CrunchifyWidth, CrunchifyWidth);
            graphics.setColor(Color.BLACK);
            for (int i = 0; i < CrunchifyWidth; ++i) {
                for (int j = 0; j < CrunchifyWidth; ++j) {
                    if (!byteMatrix.get(i, j)) continue;
                    graphics.fillRect(i, j, 1, 1);
                }
            }
            ImageIO.write((RenderedImage)image, fileType, myFile);
            return new ImageIcon(image.getScaledInstance(width, height, 4));
        }
        catch (Exception e) {
            PosLog.error(OroServiceWindow.class, e);
            return null;
        }
    }

    protected void doInactiveTerminal() {
        AndroidDevice androidDevice = this.getSelectedRow();
        if (androidDevice == null) {
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(this, "Are your sure your want to disable " + androidDevice.getName() + "?", "Confirm") != 0) {
            return;
        }
        Store store = StoreDAO.getRestaurant();
        String freeTerminal = store.getProperty(DEFAULT_ANDROID_DEVICES);
        if (StringUtils.isNotEmpty((String)freeTerminal) && freeTerminal.equals(androidDevice.getTerminalKey())) {
            store.addProperty(DEFAULT_ANDROID_DEVICES, "");
            StoreDAO.getInstance().saveOrUpdate(store);
        }
        androidDevice.doUnregister();
        this.tableModel.fireTableDataChanged();
    }

    private AndroidDevice getSelectedRow() {
        int selectedRow = this.deviceListTable.getSelectedRow();
        if (selectedRow < 0) {
            return null;
        }
        selectedRow = this.deviceListTable.convertRowIndexToModel(selectedRow);
        AndroidDevice device = this.tableModel.getRow(selectedRow);
        return device;
    }

    private Terminal getSelectedTerminal() {
        AndroidDevice device = this.getSelectedRow();
        if (device == null) {
            return null;
        }
        Terminal terminal = TerminalDAO.getInstance().getByTerminalKey(device.getTerminalKey());
        return terminal;
    }

    protected void doApproveTerminal() {
        AndroidDevice androidTerminal = this.getSelectedRow();
        if (androidTerminal == null) {
            return;
        }
        if (StringUtils.isEmpty((String)androidTerminal.getAppName()) || StringUtils.isEmpty((String)androidTerminal.getAppVersion())) {
            POSMessageDialog.showMessage(this, "Please connect your device to register.");
            return;
        }
        PosResponse response = androidTerminal.doRegister();
        if (response.getResponseCode() == 1) {
            POSMessageDialog.showMessage(this, "Successfully registered.");
            androidTerminal.setHasValidLicense(true);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void refreshDevices() {
        List<AndroidDevice> deviceList = AndroidDevice.buildList();
        this.tableModel.setRows(deviceList);
        this.tableModel.setNumRows(deviceList.size());
    }

    private void setApplicationLook() {
        try {
            PlasticXPLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            IconFontSwing.register((IconFont)FontAwesome.getIconFont());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setupSizeAndLocation() {
        this.setSize(PosUIManager.getSize(1000, 600));
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            this.setLocationRelativeTo(null);
        } else if (this.service.isRunning()) {
            this.service.stopService();
        }
        super.setVisible(b);
    }

    public static void main(String[] args) {
        OroServiceWindow window = OroServiceWindow.getInstance();
        window.setVisible(true);
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosing(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
        this.close();
    }

    private void close() {
        _RootDAO.releaseConnection();
        System.exit(0);
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void serviceStarted(int port) {
        this.lblServiceStatus.setText("Service running");
    }

    @Override
    public void serviceStopped() {
        if (this.service.isRunning()) {
            return;
        }
        this.lblServiceStatus.setText("Press start button to start service.");
    }

    @Override
    public void dataRequested(String data) {
        this.lblServiceStatus.setText(data);
    }

    @Override
    public void dataResponse(String data) {
        this.lblServiceStatus.setText("Service started");
    }

    @Override
    public void dataSetChanged(String data) {
        this.refreshDevices();
    }

    @Override
    public void terminalConnected(String request) {
        AndroidDevice connectedDevice = AndroidDevice.build(request);
        this.updateVersionInfo(connectedDevice);
    }

    public static OroServiceWindow getInstance() {
        if (instance == null) {
            instance = new OroServiceWindow();
        }
        return instance;
    }

    public static void setInstance(OroServiceWindow instance) {
        OroServiceWindow.instance = instance;
    }

    public void updateVersionInfo(AndroidDevice requestedDevice) {
        if (this.tableModel.getRowCount() == 0) {
            return;
        }
        boolean exists = false;
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            AndroidDevice androidDevice = this.tableModel.getRow(i);
            if (!androidDevice.getTerminalKey().equals(requestedDevice.getTerminalKey())) continue;
            androidDevice.setConnectionStatus("Last access time:  " + DateUtil.getReportDate());
            androidDevice.setAppName(requestedDevice.getAppName());
            androidDevice.setAppVersion(requestedDevice.getAppVersion());
            androidDevice.setHasValidLicense(requestedDevice.hasAccessPermission());
            this.tableModel.fireTableRowsUpdated(i, i);
            exists = true;
            break;
        }
        if (!exists) {
            this.tableModel.addRow(requestedDevice);
        }
    }

    private class AndroidDeviceListTable
    extends JXTable {
        public AndroidDeviceListTable(TableModel dm) {
            super(dm);
        }

        public void changeSelection(int row, int column, boolean toggle, boolean extend) {
            super.changeSelection(row, column, toggle, extend);
            OroServiceWindow.this.deviceListTable.editCellAt(row, column);
        }

        public void setValueAt(Object value, int row, int column) {
            super.setValueAt(value, row, column);
        }
    }
}

