/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.PosLog;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.util.DataProvider;
import com.orocube.common.util.TerminalUtil;
import com.orocube.rest.service.mqtt.OroMqttClient;
import io.moquette.interception.AbstractInterceptHandler;
import io.moquette.interception.messages.InterceptPublishMessage;
import io.moquette.server.Server;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;

public class OroMqttServer {
    public static final String MQTT_SERVER_ADDRESS = "mqtt_server_address";
    private Server mqttBroker;
    private String brokerServerAddress;
    private String deviceId;
    private static OroMqttServer instance;

    private OroMqttServer() {
        this.setBrokerServerAddress("tcp://oroposcloud.com:1883");
    }

    public static OroMqttServer getInstance() {
        if (instance == null) {
            instance = new OroMqttServer();
        }
        return instance;
    }

    public String getBrokerServerAddress() {
        return this.brokerServerAddress;
    }

    public void setBrokerServerAddress(String brokerServerAddress) {
        this.brokerServerAddress = brokerServerAddress;
    }

    private void updatePropertyIfRequired() {
    }

    private void startServer() throws Exception {
        if (this.isRunning()) {
            return;
        }
        this.mqttBroker = new Server();
        this.mqttBroker.startServer();
        this.updatePropertyIfRequired();
        System.out.println("moquette mqtt broker started...");
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                System.out.println("stopping moquette mqtt broker..");
                OroMqttServer.this.mqttBroker.stopServer();
                System.out.println("moquette mqtt broker stopped");
            }
        });
    }

    private boolean isRunning() {
        if (StringUtils.isEmpty((String)this.brokerServerAddress)) {
            this.updateStoreProperty(this.getLocalAddress());
        }
        return OroMqttClient.getInstance(this.deviceId).isConnectedToServer();
    }

    public boolean isRunningThisTerminal() {
        return this.mqttBroker != null;
    }

    public String getLocalAddress() {
        return this.brokerServerAddress;
    }

    public void updateStoreProperty(String address) {
        this.brokerServerAddress = address;
        Store store = StoreDAO.getRestaurant();
        store.addProperty(MQTT_SERVER_ADDRESS, address);
        StoreDAO.getInstance().saveOrUpdate(store);
        DataProvider.get().refreshStore();
    }

    public void stopServer() {
        try {
            this.mqttBroker.stopServer();
        }
        catch (Exception e) {
            PosLog.error(OroMqttClient.class, e);
        }
    }

    public void start() {
        this.start(TerminalUtil.getSystemUID());
    }

    public void start(String deviceId) {
        try {
            this.deviceId = deviceId;
            OroMqttServer.getInstance().startServer();
            OroMqttClient.getInstance(deviceId).initMqttClient();
        }
        catch (Exception e) {
            PosLog.error(OroMqttClient.class, e);
        }
    }

    public void main(String[] args) throws InterruptedException, IOException {
        OroMqttServer.getInstance().start();
    }

    static class PublisherListener
    extends AbstractInterceptHandler {
        PublisherListener() {
        }

        public void onPublish(InterceptPublishMessage message) {
        }
    }
}

