/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.StyledTicketSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.GroupSettleTicketDialog;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.List;

public class GroupSettleTicketAction
extends PosAction {
    private List<Ticket> tickets;
    private User currentUser;

    public GroupSettleTicketAction(User currentUser) {
        this.currentUser = currentUser;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public GroupSettleTicketAction(List<Ticket> tickets, User user) {
        this.tickets = tickets;
        this.currentUser = user;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public GroupSettleTicketAction(DataChangeListener listener) {
        super(POSConstants.GROUP_SETTLE_BUTTON_TEXT, listener);
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    @Override
    public void execute() {
        try {
            if (!POSUtil.checkDrawerAssignment(DataProvider.get().getCurrentTerminal(), this.getCurrentUser())) {
                return;
            }
            ArrayList<Ticket> ticketList = new ArrayList<Ticket>();
            if (this.tickets == null || this.tickets.isEmpty()) {
                StyledTicketSelectionDialog ticketSelectionDialog = new StyledTicketSelectionDialog(true);
                ticketSelectionDialog.openFullScreen();
                if (ticketSelectionDialog.isCanceled()) {
                    return;
                }
                List<Ticket> selectedTickets = ticketSelectionDialog.getSelectedTickets();
                if (selectedTickets == null) {
                    return;
                }
                for (Ticket ticket : selectedTickets) {
                    Ticket fullTicket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                    if (fullTicket.getOrderType().isBarTab().booleanValue()) continue;
                    ticketList.add(fullTicket);
                }
            } else {
                ticketList.addAll(this.tickets);
            }
            User user = this.currentUser;
            if (user == null) {
                user = Application.getCurrentUser();
            }
            GroupSettleTicketDialog posDialog = new GroupSettleTicketDialog(ticketList, user);
            posDialog.setSize(Application.getPosWindow().getSize());
            posDialog.setDefaultCloseOperation(2);
            posDialog.openUndecoratedFullScreen();
            if (this.listener != null) {
                this.listener.dataSetUpdated();
            }
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    @Override
    protected User getCurrentUser() {
        if (this.currentUser == null) {
            return Application.getCurrentUser();
        }
        return this.currentUser;
    }
}

