/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.base.BaseOrderType;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderTypeSelectionDialog2;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.SettleTicketDialog;
import com.floreantpos.util.POSUtil;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class SettleTicketAction
extends PosAction {
    private Ticket ticket;
    private User currentUser;

    public SettleTicketAction(Ticket ticket) {
        this.ticket = ticket;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public SettleTicketAction(Ticket ticket, User user) {
        this.ticket = ticket;
        this.currentUser = user;
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    public SettleTicketAction(DataChangeListener listener) {
        super(POSConstants.SETTLE_TICKET_BUTTON_TEXT, listener);
        this.setRequiredPermission(UserPermission.SETTLE_TICKET);
    }

    @Override
    public void execute() {
        try {
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            if (!this.hasPermissionToAccessTicket(this.ticket)) {
                return;
            }
            this.performSettle();
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            PosLog.error(this.getClass(), e);
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    public boolean performSettle() {
        PosTransaction bartabTransaction;
        Object orderType;
        User user = this.currentUser;
        if (user == null) {
            user = Application.getCurrentUser();
        }
        if (this.ticket.isVoided().booleanValue()) {
            POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
            return false;
        }
        if (!POSUtil.checkDrawerAssignment(Application.getInstance().getTerminal(), user)) {
            return false;
        }
        TicketDAO.getInstance().loadFullTicket(this.ticket);
        if (this.ticket.isClosed().booleanValue()) {
            this.ticket.setClosed(false);
            this.ticket.setReOpened(true);
        }
        if (this.ticket.getOrderType().isHasForHereAndToGo().booleanValue() && !(this.ticket.getPaidAmount() > 0.0)) {
            OrderTypeSelectionDialog2 dialog = new OrderTypeSelectionDialog2();
            dialog.open();
            if (dialog.isCanceled()) {
                return false;
            }
            orderType = dialog.getSelectedOrderType();
            if (orderType != null) {
                this.ticket.updateTicketItemPriceByOrderType((String)orderType);
            }
        }
        final SettleTicketDialog posDialog = new SettleTicketDialog(this.ticket, user);
        posDialog.setSize(Application.getPosWindow().getSize());
        posDialog.setDefaultCloseOperation(2);
        orderType = this.ticket.getOrderType();
        if (((BaseOrderType)orderType).isBarTab().booleanValue() && (bartabTransaction = this.ticket.getBartabTransaction()) != null && !bartabTransaction.isCaptured().booleanValue() && !bartabTransaction.isVoided().booleanValue()) {
            posDialog.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent e) {
                    try {
                        posDialog.settleBartab();
                    }
                    catch (Exception e2) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                        posDialog.setCanceled(true);
                        posDialog.dispose();
                    }
                }
            });
        }
        posDialog.openUndecoratedFullScreen();
        if (posDialog.isCanceled()) {
            return false;
        }
        if (this.listener != null) {
            this.listener.dataChanged(this.ticket);
        }
        return true;
    }

    @Override
    protected User getCurrentUser() {
        if (this.currentUser == null) {
            return Application.getCurrentUser();
        }
        return this.currentUser;
    }
}

