/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;

public class TicketKitchenSentAction
extends PosAction {
    private Ticket ticket;

    public TicketKitchenSentAction() {
        super(POSConstants.SEND_TO_KITCHEN);
    }

    public TicketKitchenSentAction(Ticket ticket) {
        super(POSConstants.SEND_TO_KITCHEN);
        this.ticket = ticket;
    }

    public TicketKitchenSentAction(DataChangeListener listener) {
        super(POSConstants.SEND_TO_KITCHEN, listener);
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public void execute() {
        try {
            Object selectedObject = this.getSelectedObject();
            if (selectedObject == null) {
                return;
            }
            Ticket ticket = null;
            ticket = selectedObject instanceof Ticket ? (Ticket)selectedObject : TicketService.getTicket((String)selectedObject);
            if (ticket == null) {
                return;
            }
            Ticket ticketToEdit = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            OrderView.getInstance().setCurrentTicket(ticketToEdit);
            OrderView.getInstance().getTicketView().sendTicketToKitchen();
            POSMessageDialog.showMessage(Messages.getString("DefaultTableSelectionView.6"));
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }
}

