/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import java.util.Arrays;

public class TicketReopenAction
extends PosAction {
    private Ticket ticket;

    public TicketReopenAction() {
        super(POSConstants.REOPEN_TICKET_BUTTON_TEXT);
    }

    public TicketReopenAction(Ticket ticket) {
        super(POSConstants.REOPEN_TICKET_BUTTON_TEXT);
        this.ticket = ticket;
    }

    public TicketReopenAction(DataChangeListener listener) {
        super(POSConstants.REOPEN_TICKET_BUTTON_TEXT, listener);
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public void execute() {
        try {
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            if (this.ticket == null) {
                return;
            }
            if (!this.ticket.isClosed().booleanValue()) {
                throw new PosException(POSConstants.TICKET_IS_NOT_CLOSED);
            }
            if (this.ticket.isVoided().booleanValue()) {
                throw new PosException(Messages.getString("SwitchboardView.11"));
            }
            this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
            this.ticket.setClosed(false);
            this.ticket.setClosingDate(null);
            this.ticket.setReOpened(true);
            TicketDAO.getInstance().saveOrUpdate(this.ticket);
            OrderInfoView view = new OrderInfoView(Arrays.asList(this.ticket));
            OrderInfoDialog dialog = new OrderInfoDialog(view);
            dialog.setSize(PosUIManager.getSize(400), PosUIManager.getSize(600));
            dialog.setDefaultCloseOperation(2);
            dialog.setLocationRelativeTo(Application.getPosWindow());
            dialog.setVisible(true);
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }
}

