/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.tableselection.TableSelectorDialog;
import com.floreantpos.ui.tableselection.TableSelectorFactory;
import com.floreantpos.ui.views.order.OrderTypeSelectionDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;
import java.util.List;

public class TicketReorderAction
extends PosAction {
    private Ticket ticket;
    private boolean isReorder;

    public TicketReorderAction() {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public TicketReorderAction(Ticket ticket, UserPermission requiredPermission) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, requiredPermission);
        this.ticket = ticket;
    }

    public TicketReorderAction(DataChangeListener listener) {
        super(POSConstants.REORDER_TICKET_BUTTON_TEXT, listener);
        this.setRequiredPermission(UserPermission.CREATE_TICKET);
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public void execute() {
        try {
            if (!this.getCurrentUser().hasPermission(this.requiredPermission)) {
                POSMessageDialog.showError(Messages.getString("OrderTypeButton.1"));
                return;
            }
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            if (this.ticket == null) {
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Are you sure to reorder this ticket?", "Reorder");
            if (option != 0) {
                return;
            }
            OrderTypeSelectionDialog dialog = new OrderTypeSelectionDialog();
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            OrderType orderType = dialog.getSelectedOrderType();
            this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
            this.createReOrder(this.ticket, orderType);
            this.isReorder = true;
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    private void createReOrder(Ticket oldticket, OrderType orderType) {
        if (oldticket == null) {
            throw new PosException("Ticket not found!");
        }
        Ticket ticket = new Ticket(true);
        ticket.setOrderType(orderType);
        ticket.setProperties(oldticket.getProperties());
        ticket.setNumberOfGuests(oldticket.getNumberOfGuests());
        ArrayList<TicketItem> newTicketItems = new ArrayList<TicketItem>();
        for (TicketItem oldTicketItem : oldticket.getTicketItems()) {
            if (oldTicketItem.isVoided().booleanValue()) continue;
            TicketItem newTicketItem = oldTicketItem.cloneAsNew();
            newTicketItem.setTicket(ticket);
            newTicketItems.add(newTicketItem);
        }
        ticket.getTicketItems().addAll(newTicketItems);
        if (orderType.isShowTableSelection().booleanValue()) {
            TableSelectorDialog dialog = TableSelectorFactory.createTableSelectorDialog(orderType);
            dialog.setCreateNewTicket(false);
            dialog.updateView(true);
            dialog.openUndecoratedFullScreen();
            if (dialog.isCanceled()) {
                return;
            }
            List<ShopTable> tables = dialog.getSelectedTables();
            ArrayList<Integer> tableNumbers = new ArrayList<Integer>();
            for (ShopTable shopTable : tables) {
                SalesArea salesArea = shopTable.getSalesArea();
                if (salesArea != null) {
                    ticket.setSalesArea(salesArea);
                    ticket.setSalesAreaId(salesArea.getId());
                }
                tableNumbers.add(shopTable.getId());
            }
            ticket.setTableNumbers(tableNumbers);
        }
        OrderView.getInstance().setCurrentTicket(ticket);
        RootView.getInstance().showView("ORDER_VIEW");
    }

    public boolean isReorder() {
        return this.isReorder;
    }
}

