/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;

public class TicketTransferAction
extends PosAction {
    private Ticket ticket;
    private boolean isTransfered = false;
    private User currentUser;

    public TicketTransferAction() {
        super("TRANSFER");
    }

    public TicketTransferAction(Ticket ticket, User currentUser) {
        super("TRANSFER");
        this.ticket = ticket;
        this.currentUser = currentUser;
    }

    public TicketTransferAction(DataChangeListener listener) {
        super("TRANSFER", listener);
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    @Override
    public void execute() {
        try {
            User owner;
            if (this.listener != null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                if (selectedObject instanceof Ticket) {
                    this.ticket = (Ticket)selectedObject;
                }
            }
            if (this.ticket == null) {
                return;
            }
            if (this.ticket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            int option = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Are you sure to transfer this ticket?", "Transfer");
            if (option != 0) {
                return;
            }
            this.ticket = TicketDAO.getInstance().loadFullTicket(this.ticket.getId());
            User user = this.currentUser;
            if (user == null) {
                user = Application.getCurrentUser();
            }
            if (!user.equals(owner = this.ticket.getOwner()) && !user.hasPermission(UserPermission.TRANSFER_TICKET)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("OrderInfoDialog.4") + this.ticket.getId());
                return;
            }
            UserListDialog dialog = new UserListDialog();
            dialog.hideUser(owner);
            dialog.setTitle(Messages.getString("UserTransferDialog.0"));
            dialog.setCaption(Messages.getString("UserTransferDialog.1"));
            dialog.setSize(PosUIManager.getSize(400, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            User selectedUser = dialog.getSelectedUser();
            this.doTransferTickets(selectedUser);
            POSMessageDialog.showMessage("Successfully transferred.");
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, e);
        }
    }

    protected void doTransferTickets(User selectedUser) {
        if (selectedUser == null) {
            return;
        }
        this.ticket.setOwner(selectedUser);
        TicketDAO.getInstance().saveOrUpdate(this.ticket);
        this.isTransfered = true;
    }

    public boolean isTransfered() {
        return this.isTransfered;
    }
}

