/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.VoidTicketDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.ArrayList;

public class VoidTicketAction
extends PosAction {
    Ticket ticket;

    public VoidTicketAction(DataChangeListener listener) {
        super(POSConstants.VOID_TICKET_BUTTON_TEXT + "/" + POSConstants.REFUND_BUTTON_TEXT, listener);
        super.setRequiredPermission(UserPermission.VOID_TICKET);
        this.setMandatoryPermission(true);
    }

    public VoidTicketAction(Ticket ticket) {
        super(POSConstants.VOID_TICKET_BUTTON_TEXT + "/" + POSConstants.REFUND_BUTTON_TEXT);
        super.setRequiredPermission(UserPermission.VOID_TICKET);
        this.setMandatoryPermission(true);
        this.ticket = ticket;
    }

    @Override
    public void execute() {
        try {
            Ticket selectedTicket = null;
            if (this.ticket == null) {
                Object selectedObject = this.getSelectedObject();
                if (selectedObject == null) {
                    return;
                }
                selectedTicket = selectedObject instanceof Ticket ? (Ticket)selectedObject : TicketService.getTicket((String)selectedObject);
            } else {
                selectedTicket = this.ticket;
            }
            if (selectedTicket.isVoided().booleanValue()) {
                POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
                return;
            }
            if (selectedTicket.getPaidAmount() > 0.0) {
                POSMessageDialog.showMessage(Application.getPosWindow(), "Cannot void paid ticket");
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Are you sure you want to void?", "Confirm") != 0) {
                return;
            }
            TicketDAO.getInstance().loadFullTicket(selectedTicket);
            if (selectedTicket.getPaidAmount() == 0.0 && !selectedTicket.isPrintedToKitchenOrInventoryAdjusted()) {
                ArrayList<Ticket> ticketsToBeDeleted = new ArrayList<Ticket>();
                ticketsToBeDeleted.add(selectedTicket);
                TicketDAO.getInstance().deleteTickets(ticketsToBeDeleted, true, true);
                selectedTicket.setVoided(true);
                if (this.listener != null) {
                    this.listener.dataRemoved(selectedTicket);
                }
            } else {
                VoidTicketDialog dialog = new VoidTicketDialog(POSUtil.getFocusedWindow(), selectedTicket);
                dialog.setSize(PosUIManager.getSize(550, 520));
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                if (this.listener != null) {
                    this.listener.dataChanged(selectedTicket);
                }
            }
            POSMessageDialog.showMessage("Ticket is voided.");
        }
        catch (PosException e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage());
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }
}

