/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.actions.DataExportAction;
import com.floreantpos.bo.actions.DataImportDialog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.datamigrate.Elements;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class DataImportAction
extends AbstractAction {
    public DataImportAction() {
        super(Messages.getString("DataImportAction.0"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        JFileChooser fileChooser = DataExportAction.getFileChooser();
        int option = fileChooser.showOpenDialog(POSUtil.getBackOfficeWindow());
        if (option != 0) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        try {
            DataImportDialog dialog = new DataImportDialog(file);
            dialog.setSize(PosUIManager.getSize(800, 550));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
        }
        catch (Exception e1) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e1.getMessage(), e1);
        }
    }

    public static Elements importMenuItemsFromFile(File file) throws Exception {
        if (file == null) {
            new FileNotFoundException("File Not Found");
        }
        FileInputStream inputStream = new FileInputStream(file);
        return DataImportAction.loadMenuItems(inputStream);
    }

    public static boolean saveImportedMenuItems(Elements elements, ProgressObserver progress) throws Exception {
        try {
            DataImportAction.importMenuItems(elements, progress);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        DataImportAction.generateSampleMenuPages();
        return true;
    }

    public static Elements loadMenuItems(InputStream inputStream) throws Exception {
        try {
            Elements elements;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Elements.class});
            Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
            Elements elements2 = elements = (Elements)unmarshaller.unmarshal(inputStream);
            return elements2;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void importMenuItems(Elements elements, ProgressObserver progress) throws Exception {
        List<UserType> list;
        List<User> list2;
        List<MenuItem> list3;
        List<ModifierGroup> list4;
        List<MenuModifier> list5;
        List<MenuGroup> list6;
        List<MenuCategory> list7;
        List<InventoryUnit> list8;
        List<InventoryUnitGroup> unitGroups;
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        TaxGroup defaultTaxGroup = DataImportAction.ensureTaxGroup();
        List<TaxGroup> taxGroups = elements.getTaxGroups();
        if (taxGroups != null) {
            for (TaxGroup taxGroup : taxGroups) {
                void var6_7;
                TaxGroup taxGroup2 = TaxGroupDAO.getInstance().get(taxGroup.getId());
                ArrayList<Tax> arrayList = new ArrayList<Tax>();
                if (taxGroup.getTaxes() != null) {
                    for (Tax tax : taxGroup.getTaxes()) {
                        Tax tax2 = (Tax)objectMap.get(tax.getUniqueId());
                        arrayList.add(tax2);
                    }
                }
                taxGroup.setTaxes(arrayList);
                if (taxGroup2 == null) {
                    TaxGroupDAO.getInstance().save(taxGroup);
                } else {
                    taxGroup.setId(taxGroup2.getId());
                    taxGroup.setVersion(taxGroup2.getVersion());
                    PropertyUtils.copyProperties((Object)taxGroup2, (Object)taxGroup);
                    TaxGroupDAO.getInstance().update(taxGroup2);
                    TaxGroup taxGroup3 = taxGroup2;
                }
                objectMap.put(var6_7.getUniqueId(), var6_7);
                progress.progress("Tax Group " + var6_7.toString());
            }
        } else {
            List<Tax> taxes = elements.getTaxes();
            if (taxes != null) {
                for (Tax tax : taxes) {
                    void var7_16;
                    Tax tax3 = TaxDAO.getInstance().get(tax.getId());
                    if (tax3 == null) {
                        TaxDAO.getInstance().save(tax);
                        defaultTaxGroup.addTotaxes(tax3);
                        TaxGroupDAO.getInstance().update(defaultTaxGroup);
                    } else {
                        tax.setId(tax3.getId());
                        tax.setVersion(tax3.getVersion());
                        PropertyUtils.copyProperties((Object)tax3, (Object)tax);
                        TaxDAO.getInstance().update(tax3);
                        defaultTaxGroup.addTotaxes(tax3);
                        TaxGroupDAO.getInstance().update(defaultTaxGroup);
                        Tax tax4 = tax3;
                    }
                    progress.progress("Tax " + var7_16.toString());
                    objectMap.put(var7_16.getUniqueId(), var7_16);
                }
            }
        }
        if ((unitGroups = elements.getUnitGroups()) != null) {
            for (InventoryUnitGroup inventoryUnitGroup : unitGroups) {
                void var7_23;
                InventoryUnitGroup inventoryUnitGroup2 = InventoryUnitGroupDAO.getInstance().findByName(inventoryUnitGroup.getName());
                inventoryUnitGroup.setUnits(null);
                if (inventoryUnitGroup2 == null) {
                    InventoryUnitGroupDAO.getInstance().save(inventoryUnitGroup);
                } else {
                    inventoryUnitGroup.setId(inventoryUnitGroup2.getId());
                    inventoryUnitGroup.setVersion(inventoryUnitGroup2.getVersion());
                    PropertyUtils.copyProperties((Object)inventoryUnitGroup2, (Object)inventoryUnitGroup);
                    InventoryUnitGroupDAO.getInstance().update(inventoryUnitGroup2);
                    InventoryUnitGroup inventoryUnitGroup3 = inventoryUnitGroup2;
                }
                if (inventoryUnitGroup2 == null) {
                    objectMap.put(var7_23.getId(), var7_23);
                } else {
                    objectMap.put(inventoryUnitGroup2.getId(), var7_23);
                }
                progress.progress("Unit Group " + var7_23.toString());
            }
        }
        if ((list8 = elements.getUnits()) != null) {
            for (InventoryUnit inventoryUnit : list8) {
                void var8_35;
                InventoryUnit inventoryUnit2 = InventoryUnitDAO.getInstance().get(inventoryUnit.getId());
                String string = inventoryUnit.getUnitGroupId();
                InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)objectMap.get(string);
                if (inventoryUnitGroup != null) {
                    inventoryUnit.setUnitGroupId(inventoryUnitGroup.getId());
                } else {
                    inventoryUnit.setUnitGroupId(null);
                }
                if (inventoryUnit2 == null) {
                    InventoryUnitDAO.getInstance().save(inventoryUnit);
                } else {
                    inventoryUnit.setId(inventoryUnit2.getId());
                    inventoryUnit.setVersion(inventoryUnit2.getVersion());
                    PropertyUtils.copyProperties((Object)inventoryUnit2, (Object)inventoryUnit);
                    InventoryUnitDAO.getInstance().update(inventoryUnit2);
                    InventoryUnit inventoryUnit3 = inventoryUnit2;
                }
                objectMap.put(var8_35.getUniqueId(), var8_35);
                progress.progress("Unit " + var8_35.toString());
            }
        }
        if ((list7 = elements.getMenuCategories()) != null) {
            for (MenuCategory menuCategory : list7) {
                void var9_45;
                MenuCategory menuCategory2 = MenuCategoryDAO.getInstance().get(menuCategory.getId());
                if (menuCategory2 == null) {
                    MenuCategoryDAO.getInstance().save(menuCategory);
                } else {
                    menuCategory.setId(menuCategory2.getId());
                    menuCategory.setVersion(menuCategory2.getVersion());
                    PropertyUtils.copyProperties((Object)menuCategory2, (Object)menuCategory);
                    MenuCategoryDAO.getInstance().update(menuCategory);
                    MenuCategory menuCategory3 = menuCategory2;
                }
                objectMap.put(var9_45.getUniqueId(), var9_45);
                progress.progress("Menu Category " + var9_45.toString());
            }
        }
        if ((list6 = elements.getMenuGroups()) != null) {
            for (MenuGroup menuGroup : list6) {
                void var10_57;
                MenuGroup menuGroup2 = MenuGroupDAO.getInstance().get(menuGroup.getId());
                if (menuGroup2 == null) {
                    MenuGroupDAO.getInstance().save(menuGroup);
                } else {
                    menuGroup.setId(menuGroup2.getId());
                    menuGroup.setVersion(menuGroup2.getVersion());
                    PropertyUtils.copyProperties((Object)menuGroup2, (Object)menuGroup);
                    MenuGroupDAO.getInstance().update(menuGroup2);
                    MenuGroup menuGroup3 = menuGroup2;
                }
                objectMap.put(var10_57.getUniqueId(), var10_57);
                progress.progress("Menu Group " + var10_57.toString());
            }
        }
        if ((list5 = elements.getMenuModifiers()) != null) {
            for (MenuModifier menuModifier : list5) {
                void var11_69;
                MenuModifier menuModifier2 = MenuModifierDAO.getInstance().get(menuModifier.getId());
                TaxGroup taxGroup = menuModifier.getTaxGroup();
                if (taxGroup != null) {
                    TaxGroup taxGroup4 = (TaxGroup)objectMap.get(taxGroup.getUniqueId());
                    menuModifier.setTaxGroup(taxGroup4);
                }
                menuModifier.setTaxGroup(null);
                if (menuModifier2 == null) {
                    MenuModifierDAO.getInstance().save(menuModifier);
                } else {
                    menuModifier.setId(menuModifier2.getId());
                    menuModifier.setVersion(menuModifier2.getVersion());
                    PropertyUtils.copyProperties((Object)menuModifier2, (Object)menuModifier);
                    MenuModifierDAO.getInstance().update(menuModifier2);
                    MenuModifier menuModifier3 = menuModifier2;
                }
                objectMap.put(var11_69.getUniqueId(), var11_69);
                progress.progress("Menu Modifier " + var11_69.toString());
            }
        }
        if ((list4 = elements.getModifierGroups()) != null) {
            for (ModifierGroup modifierGroup : list4) {
                void var12_77;
                ModifierGroup modifierGroup2 = ModifierGroupDAO.getInstance().get(modifierGroup.getId());
                ArrayList<MenuModifier> newModifiersForGroup = new ArrayList<MenuModifier>();
                if (modifierGroup.getModifiers() != null) {
                    for (MenuModifier modifier : modifierGroup.getModifiers()) {
                        MenuModifier newModifier = (MenuModifier)objectMap.get(modifier.getUniqueId());
                        newModifiersForGroup.add(newModifier);
                    }
                }
                modifierGroup.setModifiers(newModifiersForGroup);
                if (modifierGroup2 == null) {
                    ModifierGroupDAO.getInstance().save(modifierGroup);
                } else {
                    modifierGroup.setId(modifierGroup2.getId());
                    modifierGroup.setVersion(modifierGroup2.getVersion());
                    PropertyUtils.copyProperties((Object)modifierGroup2, (Object)modifierGroup);
                    ModifierGroupDAO.getInstance().update(modifierGroup2);
                    ModifierGroup modifierGroup3 = modifierGroup2;
                }
                objectMap.put(var12_77.getUniqueId(), var12_77);
                progress.progress("Modifier Group " + var12_77.toString());
            }
        }
        if ((list3 = elements.getMenuItems()) != null) {
            for (MenuItem menuItem : list3) {
                List<MenuItemModifierSpec> menuItemModiferGroups;
                InventoryUnit inventoryUnit;
                TaxGroup taxGroup;
                PrinterGroup printerGroup;
                MenuItem existingMenuItem = null;
                if (menuItem.getId() != null) {
                    existingMenuItem = MenuItemDAO.getInstance().get(menuItem.getId());
                }
                if ((printerGroup = menuItem.getPrinterGroup()) != null) {
                    PrinterGroup pg = PrinterGroupDAO.getInstance().findByName(printerGroup.getName());
                    if (pg == null) {
                        pg = new PrinterGroup();
                        PropertyUtils.copyProperties((Object)pg, (Object)printerGroup);
                        PrinterGroupDAO.getInstance().save(pg);
                    }
                    printerGroup.setId(pg.getId());
                }
                if ((taxGroup = menuItem.getTaxGroup()) != null) {
                    taxGroup = (TaxGroup)objectMap.get(taxGroup.getUniqueId());
                    menuItem.setTaxGroup(taxGroup);
                }
                if ((inventoryUnit = menuItem.getUnit()) != null) {
                    inventoryUnit = (InventoryUnit)objectMap.get(inventoryUnit.getUniqueId());
                    menuItem.setUnit(inventoryUnit);
                }
                if ((menuItemModiferGroups = menuItem.getMenuItemModiferSpecs()) != null) {
                    MenuItem.copyModifierSpecsToMenuItem(menuItem, menuItemModiferGroups);
                    for (MenuItemModifierSpec menuItemModifierSpec : menuItem.getMenuItemModiferSpecs()) {
                        Set<MenuItemModifierPage> specPages;
                        ModifierGroup modifierGroup = menuItemModifierSpec.getModifierGroup();
                        if (modifierGroup != null) {
                            menuItemModifierSpec.setModifierGroup((ModifierGroup)objectMap.get(modifierGroup.getUniqueId()));
                        }
                        if ((specPages = menuItemModifierSpec.getModifierPages()) != null) {
                            for (MenuItemModifierPage menuItemModifierPage : specPages) {
                                List<MenuItemModifierPageItem> pageItems = menuItemModifierPage.getPageItems();
                                if (pageItems == null) continue;
                                for (MenuItemModifierPageItem menuItemModifierPageItem : pageItems) {
                                    MenuModifier modifier = menuItemModifierPageItem.getMenuModifier();
                                    if (modifier == null) continue;
                                    menuItemModifierPageItem.setMenuModifier((MenuModifier)objectMap.get(modifier.getUniqueId()));
                                }
                            }
                        }
                        MenuItemModifierSpecDAO.getInstance().save(menuItemModifierSpec);
                    }
                }
                menuItem.setAttributes(null);
                menuItem.setComboItems(null);
                menuItem.setComboGroups(null);
                menuItem.setParentMenuItem(null);
                menuItem.setVariants(null);
                menuItem.setStockUnits(null);
                try {
                    void var13_89;
                    if (existingMenuItem == null) {
                        menuItem.setVersion(0L);
                        Session session = MenuItemDAO.getInstance().createNewSession();
                        Transaction transaction = session.beginTransaction();
                        MenuItemDAO.getInstance().save(menuItem, session);
                        transaction.commit();
                        session.close();
                    } else {
                        menuItem.setId(existingMenuItem.getId());
                        menuItem.setVersion(existingMenuItem.getVersion());
                        PropertyUtils.copyProperties((Object)existingMenuItem, (Object)menuItem);
                        MenuItemDAO.getInstance().update(existingMenuItem);
                        MenuItem menuItem2 = existingMenuItem;
                    }
                    objectMap.put(var13_89.getUniqueId(), var13_89);
                    progress.progress("Menu Item " + var13_89.toString());
                }
                catch (Exception e) {}
            }
        }
        if ((list2 = elements.getUsers()) != null) {
            for (User user : list2) {
                User existingUser = UserDAO.getInstance().get(user.getId());
                if (existingUser == null) {
                    UserDAO.getInstance().save(user);
                } else {
                    user.setId(existingUser.getId());
                    user.setVersion(existingUser.getVersion());
                    PropertyUtils.copyProperties((Object)existingUser, (Object)user);
                    UserDAO.getInstance().update(user);
                    user = existingUser;
                }
                objectMap.put(user.getId(), user);
                progress.progress("User " + user.toString());
            }
        }
        if ((list = elements.getUserTypes()) != null) {
            for (UserType userType : list) {
                UserType existingUserType = UserTypeDAO.getInstance().get(userType.getId());
                if (existingUserType == null) {
                    UserTypeDAO.getInstance().save(userType);
                } else {
                    userType.setId(existingUserType.getId());
                    userType.setVersion(existingUserType.getVersion());
                    PropertyUtils.copyProperties((Object)existingUserType, (Object)userType);
                    UserTypeDAO.getInstance().update(userType);
                    userType = existingUserType;
                }
                objectMap.put(userType.getId(), userType);
                progress.progress("User type " + userType.toString());
            }
        }
    }

    private static TaxGroup ensureTaxGroup() {
        TaxGroup taxGroup;
        List<TaxGroup> taxGroups = TaxGroupDAO.getInstance().findAll();
        if (taxGroups.size() > 0) {
            taxGroup = taxGroups.get(0);
        } else {
            taxGroup = new TaxGroup();
            taxGroup.setName("default");
            TaxGroupDAO.getInstance().save(taxGroup);
        }
        return taxGroup;
    }

    private static void generateSampleMenuPages() {
        List<MenuGroup> groups = MenuGroupDAO.getInstance().findAll();
        if (groups == null) {
            return;
        }
        for (MenuGroup menuGroup : groups) {
            List<MenuItem> items = MenuItemDAO.getInstance().findByParent(null, menuGroup, true);
            if (items == null || items.isEmpty()) continue;
            int count = 0;
            DataImportAction.genenatePage(menuGroup, items, count, 1);
        }
    }

    private static void genenatePage(MenuGroup menuGroup, List<MenuItem> items, int count, int pageNumber) {
        try {
            MenuPage menuPage = new MenuPage();
            menuPage.setMenuGroupId(menuGroup.getId());
            menuPage.setName("Page " + pageNumber);
            menuPage.setRows(4);
            menuPage.setCols(4);
            for (int row = 0; row < 4 && count < items.size(); ++row) {
                for (int col = 0; col < 4 && count < items.size(); ++count, ++col) {
                    MenuPageItem pageItem = new MenuPageItem(col, row);
                    pageItem.setMenuPage(menuPage);
                    pageItem.setMenuItem(items.get(count));
                    MenuPageItemDAO.getInstance().saveOrUpdate(pageItem);
                }
            }
            MenuPageDAO.getInstance().saveOrUpdate(menuPage);
            if (count >= items.size()) {
                return;
            }
            DataImportAction.genenatePage(menuGroup, items, count, pageNumber++);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BOMessageDialog.showError(ex.getMessage());
        }
    }
}

