/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.actions.DataImportAction;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosTable;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.datamigrate.Elements;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class DataImportDialog
extends OkCancelOptionDialog
implements ProgressObserver {
    private Elements elements;
    private JTabbedPane tabPane;
    private File file;
    private JLabel lblProgress;
    private JPanel progressPanel;

    public DataImportDialog(File file) {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.file = file;
        this.setTitle("Import");
        this.setOkButtonText("Import");
        this.setCaption("Review Import");
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setLayout(new BorderLayout());
        this.tabPane = new JTabbedPane();
        contentPanel.add(this.tabPane);
        this.progressPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        this.lblProgress = new JLabel("Importing..");
        this.progressPanel.add((Component)this.lblProgress, "grow,span,wrap");
        this.progressPanel.setVisible(false);
        contentPanel.add((Component)this.progressPanel, "South");
    }

    protected void showImportedItems() {
        try {
            this.progressPanel.setVisible(true);
            this.progress(0, "Loading items.. Please wait..");
            this.elements = DataImportAction.importMenuItemsFromFile(this.file);
            this.progress(100, "Loading complete..");
            this.progressPanel.setVisible(false);
            String[] menuItemsColumn = new String[]{"name", "translatedName", "price", "availableUnit", "unitOnHand", "visible", "taxGroup", "sortOrder", "buttonColor", "textColor", "image"};
            Integer[] menuItemColumnsWidth = new Integer[]{200, 180, 90, 70};
            Integer[] editableColumns = new Integer[]{0, 1, 2, 3, 4, 7};
            this.tabPane.addTab(POSConstants.MENU_ITEMS, new ElementTab(MenuItem.class, this.elements.getMenuItems(), menuItemsColumn, menuItemColumnsWidth, editableColumns));
            editableColumns = new Integer[]{0, 1, 4};
            String[] menuGroupColumns = new String[]{"name", "translatedName", "visible", "parent", "sortOrder", "buttonColor", "textColor"};
            this.tabPane.addTab(POSConstants.MENU_GROUPS, new ElementTab(MenuGroup.class, this.elements.getMenuGroups(), menuGroupColumns, null, editableColumns));
            editableColumns = new Integer[]{0, 1, 4};
            String[] categoryColumns = new String[]{"name", "translatedName", "beverage", "visible", "sortOrder", "buttonColor", "textColor"};
            this.tabPane.addTab(POSConstants.MENU_CATEGORIES, new ElementTab(MenuCategory.class, this.elements.getMenuCategories(), categoryColumns, null, editableColumns));
            editableColumns = new Integer[]{0, 1};
            String[] menuModifierGroupsColumns = new String[]{"name", "translatedName", "modifiers"};
            this.tabPane.addTab(POSConstants.MODIFIER_GROUPS, new ElementTab(ModifierGroup.class, this.elements.getModifierGroups(), menuModifierGroupsColumns, null, editableColumns));
            editableColumns = new Integer[]{0, 1, 2};
            String[] menuModifiers = new String[]{"name", "translatedName", "price", "sortOrder", "buttonColor", "textColor"};
            this.tabPane.addTab(POSConstants.MENU_MODIFIERS, new ElementTab(MenuModifier.class, this.elements.getMenuModifiers(), menuModifiers, null, editableColumns));
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e.getMessage(), e);
        }
    }

    @Override
    public void doOk() {
        this.progressPanel.setVisible(true);
        this.progress(0, "Importing..");
        new Thread(){

            @Override
            public void run() {
                DataImportDialog.this.doImport();
            }
        }.start();
    }

    protected void doImport() {
        try {
            this.getButtonPanel().getComponent(0).setEnabled(false);
            DataImportAction.saveImportedMenuItems(this.elements, this);
            this.progress(100, "Import complete");
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), Messages.getString("DataImportAction.1"));
            this.setCanceled(false);
            this.dispose();
        }
        catch (Exception e) {
            BOMessageDialog.showError(e);
            this.progress(0, "Import failed");
        }
        finally {
            this.getButtonPanel().getComponent(0).setEnabled(true);
        }
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            new Thread(){

                @Override
                public void run() {
                    DataImportDialog.this.showImportedItems();
                }
            }.start();
        }
        super.setVisible(b);
    }

    @Override
    public void progress(int percent, String text) {
        this.lblProgress.setText(text);
    }

    @Override
    public void progress(int percent) {
    }

    @Override
    public Component getParentComponent() {
        return POSUtil.getFocusedWindow();
    }

    @Override
    public void progress(String text) {
        this.lblProgress.setText("Importing... " + text);
    }

    private class ElementTab<E>
    extends JPanel {
        private PosTable jtable;
        private BeanTableModel<E> tableModel;

        public ElementTab(Class className, List dataList, String[] columns) {
            this(className, dataList, columns, null);
        }

        public ElementTab(Class className, List dataList, String[] columns, Integer[] colWidths) {
            this(className, dataList, columns, colWidths, null);
        }

        public ElementTab(Class className, List dataList, String[] columns, Integer[] colWidths, Integer[] editableColumns) {
            this.tableModel = new BeanTableModel(className, 20);
            if (columns != null && columns.length > 0) {
                for (int i = 0; i < columns.length; ++i) {
                    BeanTableModel.EditMode editable = BeanTableModel.EditMode.NON_EDITABLE;
                    if (editableColumns != null && editableColumns.length > i && editableColumns[i] == i) {
                        editable = BeanTableModel.EditMode.EDITABLE;
                    }
                    this.tableModel.addColumn(this.convertToCaption(columns[i]), columns[i], editable);
                }
            }
            this.tableModel.addRows(dataList);
            this.jtable = new PosTable();
            this.jtable.setRowHeight(PosUIManager.getSize(30));
            this.jtable.setSelectionMode(0);
            this.jtable.setDefaultRenderer(Object.class, new CustomCellRenderer());
            this.jtable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
            this.jtable.setModel(this.tableModel);
            this.setLayout(new BorderLayout(5, 5));
            this.add(new JScrollPane((Component)((Object)this.jtable)));
            if (colWidths != null) {
                this.resizeColumnWidth((JTable)((Object)this.jtable), colWidths);
            }
        }

        public void resizeColumnWidth(JTable table, Integer[] colWidths) {
            TableColumnModel columnModel = table.getColumnModel();
            for (int column = 0; column < table.getColumnCount() && colWidths.length != column; ++column) {
                columnModel.getColumn(column).setPreferredWidth(colWidths[column]);
            }
        }

        private String convertToCaption(String s) {
            StringBuilder out = new StringBuilder(s);
            Pattern p = Pattern.compile("[A-Z]");
            Matcher m = p.matcher(s);
            int extraFeed = 0;
            while (m.find()) {
                if (m.start() == 0) continue;
                out = out.insert(m.start() + extraFeed, " ");
                ++extraFeed;
            }
            return out.toString().toUpperCase();
        }
    }
}

