/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.export_import.ExcelImportViewDialog;
import com.floreantpos.util.POSUtil;
import java.io.File;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileSystemView;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class ImportFromExcelAction
extends PosAction {
    private String filePath = null;

    public ImportFromExcelAction() {
        super(Messages.getString("ImportMenusFromExcel"), UserPermission.PERFORM_ADMINISTRATIVE_TASK);
        this.setMandatoryPermission(true);
    }

    @Override
    public void execute() {
        this.doSelectExcel();
    }

    private void doSelectExcel() {
        block9: {
            try {
                JFileChooser fileChooser = new JFileChooser(FileSystemView.getFileSystemView().getHomeDirectory());
                fileChooser.setDialogTitle(POSConstants.TITLE_OROPOS.toUpperCase());
                int option = fileChooser.showOpenDialog(POSUtil.getFocusedWindow());
                if (option == 0) {
                    File selectedFile = fileChooser.getSelectedFile();
                    this.filePath = selectedFile.getAbsolutePath();
                    ExcelImportViewDialog dialog = new ExcelImportViewDialog(this.filePath);
                    dialog.setDefaultCloseOperation(2);
                    if (dialog.getItemsList() == null) {
                        return;
                    }
                    dialog.openFullScreen();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    List<Object> items = dialog.getItemsList();
                    if (items != null) {
                        Session session = MenuItemDAO.getInstance().createNewSession();
                        Transaction tx = session.beginTransaction();
                        for (Object object : items) {
                            if (object instanceof MenuItem) {
                                MenuItemDAO.getInstance().saveOrUpdate((MenuItem)object, session);
                                continue;
                            }
                            if (!(object instanceof MenuModifier)) continue;
                            MenuModifierDAO.getInstance().saveOrUpdate((MenuModifier)object, session);
                        }
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("ImportedSuccessFully"));
                        tx.commit();
                        if (session != null) {
                            session.close();
                        }
                        break block9;
                    }
                    POSMessageDialog.showError(Messages.getString("DataImortedFailed"));
                    return;
                }
                return;
            }
            catch (Exception exp) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exp.getMessage(), exp);
            }
        }
    }
}

