/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.main.Main;
import com.floreantpos.model.UserPermission;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressDialog;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.datamigrate.DbConnectionInfo;
import com.floreantpos.util.datamigrate.DbTable;
import com.floreantpos.util.datamigrate.DbTableColumn;
import com.floreantpos.util.datamigrate.MigrateDatabaseConfigurationDialog;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.hibernate.dialect.Dialect;

public class MigrateDatabaseAction
extends PosAction {
    private static final String FK_NAME = "FK_NAME";
    private static final String FKTABLE_NAME = "FKTABLE_NAME";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String TABLE = "TABLE";
    private DbConnectionInfo sourceDbConnectionInfo;
    private DbConnectionInfo destinationDbConnectionInfo;
    private MigrateDatabaseConfigurationDialog migrationConfigDialog;

    public MigrateDatabaseAction() {
        super(Messages.getString("MigrateDatabase.0"), UserPermission.PERFORM_ADMINISTRATIVE_TASK);
        this.setMandatoryPermission(true);
    }

    @Override
    public void execute() {
        this.startDatabaseMigration();
    }

    private boolean initDbConnectionInfo() {
        this.migrationConfigDialog = new MigrateDatabaseConfigurationDialog();
        this.migrationConfigDialog.setTitle("Please configure source database connection.");
        this.migrationConfigDialog.setSize(PosUIManager.getSize(830, 430));
        this.migrationConfigDialog.open();
        if (this.migrationConfigDialog.isCanceled()) {
            return false;
        }
        this.sourceDbConnectionInfo = this.migrationConfigDialog.getSourceConnectionInfo();
        this.destinationDbConnectionInfo = this.migrationConfigDialog.getDestinationConnectionInfo();
        return true;
    }

    private void startDatabaseMigration() {
        if (!this.initDbConnectionInfo()) {
            return;
        }
        if (this.sourceDbConnectionInfo.equals(this.destinationDbConnectionInfo)) {
            POSMessageDialog.showError(BackOfficeWindow.getInstance(), "Destination and source database cannot be same.");
            return;
        }
        String warningMessage = "This will wipe all data from your destination (current) database. Do you wish to continue?";
        int reply1 = JOptionPane.showConfirmDialog(POSUtil.getBackOfficeWindow(), warningMessage, "Migrate Database", 0);
        if (reply1 != 0) {
            return;
        }
        ProgressDialog progressDialog = new ProgressDialog(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(ProgressObserver progressObserver) {
                try {
                    MigrateDatabaseAction.this.sourceDbConnectionInfo.openConnection();
                    MigrateDatabaseAction.this.destinationDbConnectionInfo.openConnection();
                    MigrateDatabaseAction.this.removeConstrainsFromDestDB(MigrateDatabaseAction.this.destinationDbConnectionInfo);
                    MigrateDatabaseAction.this.loadSourceDBToDestinationDB(MigrateDatabaseAction.this.sourceDbConnectionInfo, MigrateDatabaseAction.this.destinationDbConnectionInfo);
                    Database selectedDatabase = MigrateDatabaseAction.this.destinationDbConnectionInfo.getSelectedDatabase();
                    DatabaseUtil.updateDatabase(MigrateDatabaseAction.this.destinationDbConnectionInfo.getConnectionString(), selectedDatabase.getHibernateDialect(), selectedDatabase.getHibernateConnectionDriverClass(), MigrateDatabaseAction.this.destinationDbConnectionInfo.getUserName(), MigrateDatabaseAction.this.destinationDbConnectionInfo.getPassword());
                    JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), "Data successfylly migrated. The system will now restart.");
                    Main.restart();
                }
                catch (Exception e) {
                    String string = "Data migration failed due to the following error. Please check the system carefully, current database may be corrupted.";
                    string = string + "\nError: " + e.getMessage();
                    POSMessageDialog.showError(BackOfficeWindow.getInstance(), string, e);
                }
                finally {
                    try {
                        MigrateDatabaseAction.this.sourceDbConnectionInfo.getConnection().close();
                        MigrateDatabaseAction.this.destinationDbConnectionInfo.getConnection().close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        progressDialog.setTitle("Db migration..");
        progressDialog.setProgressLabelText("Migration is in progress..");
        progressDialog.setSize(PosUIManager.getSize(500, 150));
        progressDialog.setIndeterminate(true);
        progressDialog.setCancelable(false);
        progressDialog.open();
    }

    private void loadSourceDBToDestinationDB(DbConnectionInfo sourceDbConnectionInfo, DbConnectionInfo destinationDbConnectionInfo) throws Exception {
        Connection conSource = sourceDbConnectionInfo.getConnection();
        DatabaseMetaData sourceMetaData = conSource.getMetaData();
        Connection conDestination = destinationDbConnectionInfo.getConnection();
        DatabaseMetaData destinationDBMetadata = conDestination.getMetaData();
        ResultSet srcDbTableList = sourceMetaData.getTables(null, null, null, new String[]{TABLE});
        ResultSet destinationTableNames = destinationDBMetadata.getTables(null, null, null, new String[]{TABLE});
        ArrayList<DbTable> tableList = this.generateCommonTable(srcDbTableList, destinationTableNames);
        srcDbTableList = sourceMetaData.getTables(null, null, null, new String[]{TABLE});
        destinationTableNames = destinationDBMetadata.getTables(null, null, null, new String[]{TABLE});
        for (DbTable dbTable : tableList) {
            ArrayList<DbTableColumn> tableColumns = this.populateColumns(dbTable, sourceMetaData, destinationDBMetadata);
            this.copyData(conDestination, conSource, dbTable, tableColumns);
        }
    }

    private ArrayList<DbTableColumn> populateColumns(DbTable dbTable, DatabaseMetaData sourceMetaData, DatabaseMetaData destinationDBMetadata) throws Exception {
        ArrayList<String> sourceTableColumns = new ArrayList<String>();
        ArrayList<String> destTableColumns = new ArrayList<String>();
        ResultSet sourcecolumns = sourceMetaData.getColumns(null, null, dbTable.getSourceTableName(), null);
        while (sourcecolumns.next()) {
            String columnName = sourcecolumns.getString(COLUMN_NAME);
            sourceTableColumns.add(columnName);
        }
        ResultSet destinationColumns = destinationDBMetadata.getColumns(null, null, dbTable.getDestTableName(), null);
        while (destinationColumns.next()) {
            String columnName = destinationColumns.getString(COLUMN_NAME);
            destTableColumns.add(columnName);
        }
        ArrayList<DbTableColumn> tableColumns = new ArrayList<DbTableColumn>();
        block2: for (String destColumn : destTableColumns) {
            Object t;
            if (destColumn.equalsIgnoreCase("VERSION_NO") && !this.getSourceColumn(sourceTableColumns)) {
                t = new DbTableColumn(null, destColumn);
                tableColumns.add((DbTableColumn)t);
            } else if (destColumn.equalsIgnoreCase("ID") && !sourceTableColumns.contains("ID") && sourceTableColumns.contains("AUTO_ID")) {
                t = new DbTableColumn("AUTO_ID", destColumn);
                tableColumns.add((DbTableColumn)t);
            }
            for (String sourceColumn : sourceTableColumns) {
                DbTableColumn t2;
                if (destColumn.equalsIgnoreCase(sourceColumn)) {
                    t2 = new DbTableColumn(sourceColumn, destColumn);
                    tableColumns.add(t2);
                    continue block2;
                }
                if (!dbTable.getDestTableName().equalsIgnoreCase("TICKET_ITEM")) continue;
                if (destColumn.equalsIgnoreCase("MENU_ITEM_ID") && sourceColumn.equalsIgnoreCase("ITEM_ID")) {
                    t2 = new DbTableColumn(sourceColumn, destColumn);
                    tableColumns.add(t2);
                    continue block2;
                }
                if (destColumn.equalsIgnoreCase("NAME") && sourceColumn.equalsIgnoreCase("ITEM_NAME")) {
                    t2 = new DbTableColumn(sourceColumn, destColumn);
                    tableColumns.add(t2);
                    continue block2;
                }
                if (destColumn.equalsIgnoreCase("UNIT_PRICE") && sourceColumn.equalsIgnoreCase("ITEM_PRICE")) {
                    t2 = new DbTableColumn(sourceColumn, destColumn);
                    tableColumns.add(t2);
                    continue block2;
                }
                if (destColumn.equalsIgnoreCase("QUANTITY") && sourceColumn.equalsIgnoreCase("ITEM_QUANTITY")) {
                    t2 = new DbTableColumn(sourceColumn, destColumn);
                    tableColumns.add(t2);
                    continue block2;
                }
                if (destColumn.equalsIgnoreCase("UNIT_NAME") && sourceColumn.equalsIgnoreCase("ITEM_UNIT_NAME")) {
                    t2 = new DbTableColumn(sourceColumn, destColumn);
                    tableColumns.add(t2);
                    continue block2;
                }
                if (!destColumn.equalsIgnoreCase("TTYPE")) continue;
                t2 = new DbTableColumn(null, destColumn);
                tableColumns.add(t2);
                continue block2;
            }
        }
        for (DbTableColumn dbTableColumn : tableColumns) {
            ResultSet columns = destinationDBMetadata.getColumns(null, null, dbTable.getDestTableName(), dbTableColumn.getDestColumnName());
            if (!columns.next()) continue;
            dbTableColumn.setColumnType(columns.getString(TYPE_NAME));
        }
        return tableColumns;
    }

    private boolean getSourceColumn(ArrayList<String> sourceTableColumns) {
        for (String name : sourceTableColumns) {
            if (!name.equalsIgnoreCase("VERSION_NO")) continue;
            return true;
        }
        return false;
    }

    private void copyData(Connection conDestination, Connection conSource, DbTable dbTable, ArrayList<DbTableColumn> tableColumns) throws Exception {
        String sql = "select * from " + dbTable.getSourceTableName();
        Statement statement = conSource.createStatement();
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            for (DbTableColumn tableColumn : tableColumns) {
                Object colValue;
                String name = tableColumn.getColumnType();
                if (this.isImageColumn(name)) {
                    Blob blob = resultSet.getBlob(tableColumn.getSourceColumnName());
                    tableColumn.setColumnValue(blob);
                    continue;
                }
                if (tableColumn.getSourceColumnName().equalsIgnoreCase("USER_PASS")) {
                    this.encryptPassIfNotEncrypted(resultSet, tableColumn);
                    continue;
                }
                if (tableColumn.getSourceColumnName() == null) {
                    colValue = 1;
                    tableColumn.setColumnValue(colValue);
                    continue;
                }
                colValue = resultSet.getObject(tableColumn.getSourceColumnName());
                tableColumn.setColumnValue(colValue);
            }
            String insertINTOTable = dbTable.getDestTableName();
            if (insertINTOTable == null || !StringUtils.isNotEmpty((String)insertINTOTable)) continue;
            if (insertINTOTable.equalsIgnoreCase("MULTIPLIER") && tableColumns.size() != 10) {
                System.out.println(insertINTOTable);
                this.populateMultiplierTable(conDestination, conSource, dbTable, insertINTOTable);
                break;
            }
            if (insertINTOTable.equalsIgnoreCase("TICKET_PROPERTIES") && !dbTable.getSourceTableName().equals("ticket_properties")) {
                System.out.println(insertINTOTable);
                this.populateTicketPropertiesTable(conDestination, conSource, dbTable, insertINTOTable);
                break;
            }
            sql = "insert into " + insertINTOTable + " (";
            Iterator<DbTableColumn> iterator = tableColumns.iterator();
            while (iterator.hasNext()) {
                DbTableColumn tableColumn = iterator.next();
                String key = tableColumn.getDestColumnName();
                sql = sql + key;
                if (!iterator.hasNext()) continue;
                sql = sql + ",";
            }
            sql = sql + ") values (";
            iterator = tableColumns.iterator();
            while (iterator.hasNext()) {
                sql = sql + "?";
                iterator.next();
                if (!iterator.hasNext()) continue;
                sql = sql + ",";
            }
            sql = sql + ")";
            System.out.println(sql);
            PreparedStatement prepareStatement = conDestination.prepareStatement(sql);
            Iterator<DbTableColumn> iterator2 = tableColumns.iterator();
            while (iterator2.hasNext()) {
                iterator2.next();
                for (int i = 0; i < tableColumns.size(); ++i) {
                    DbTableColumn tableColumn = tableColumns.get(i);
                    String name = tableColumn.getColumnType();
                    if (this.isImageColumn(name)) {
                        if (tableColumn.getColumnValue() != null) {
                            prepareStatement.setBlob(i + 1, (Blob)tableColumn.getColumnValue());
                            continue;
                        }
                        prepareStatement.setObject(i + 1, tableColumn.getColumnValue());
                        continue;
                    }
                    prepareStatement.setObject(i + 1, tableColumn.getColumnValue());
                }
            }
            prepareStatement.executeUpdate();
            conDestination.commit();
        }
    }

    private void encryptPassIfNotEncrypted(ResultSet resultSet, DbTableColumn tableColumn) throws SQLException {
        Object colValue = resultSet.getObject(tableColumn.getSourceColumnName());
        String pass = colValue.toString();
        try {
            AESencrp.decrypt(pass);
        }
        catch (Exception e) {
            try {
                String encryptedPass;
                String value = encryptedPass = AESencrp.encrypt(pass);
                tableColumn.setColumnValue(value);
            }
            catch (Exception e1) {
                tableColumn.setColumnValue(colValue);
            }
        }
    }

    private void populateTicketPropertiesTable(Connection conDestination, Connection conSource, DbTable dbTable, String insertINTOTable) throws SQLException {
        int i;
        DatabaseMetaData destMultiplierTable = conDestination.getMetaData();
        ResultSet destMultiplierColumnList = destMultiplierTable.getColumns(null, null, dbTable.getSourceTableName(), null);
        ArrayList<String> ticketPropertiesColumnList = new ArrayList<String>();
        while (destMultiplierColumnList.next()) {
            String ticketPropColumnName = destMultiplierColumnList.getString(COLUMN_NAME);
            ticketPropertiesColumnList.add(ticketPropColumnName);
        }
        String sql = "insert into " + insertINTOTable + " (";
        for (i = 0; i < ticketPropertiesColumnList.size(); ++i) {
            sql = sql + (String)ticketPropertiesColumnList.get(i);
            if (i == ticketPropertiesColumnList.size() - 1) continue;
            sql = sql + ", ";
        }
        sql = sql + ") values (";
        for (i = 0; i < ticketPropertiesColumnList.size(); ++i) {
            sql = sql + "?";
            if (i == ticketPropertiesColumnList.size() - 1) continue;
            sql = sql + ",";
        }
        sql = sql + ")";
        PreparedStatement prepareStatement = conDestination.prepareStatement(sql);
        String sourceSql = "select * from " + dbTable.getSourceTableName();
        Statement sourceStatement = conSource.createStatement();
        ResultSet sourceResultSet = sourceStatement.executeQuery(sourceSql);
        while (sourceResultSet.next()) {
            String id = sourceResultSet.getString(1);
            String value = sourceResultSet.getString(2);
            String name = sourceResultSet.getString(3);
            prepareStatement.setString(1, id);
            prepareStatement.setString(2, name);
            prepareStatement.setString(3, value);
            prepareStatement.executeUpdate();
        }
        conDestination.commit();
    }

    private void populateMultiplierTable(Connection conDestination, Connection conSource, DbTable dbTable, String insertINTOTable) throws SQLException {
        int i;
        DatabaseMetaData destMultiplierTable = conDestination.getMetaData();
        ResultSet destMultiplierColumnList = destMultiplierTable.getColumns(null, null, dbTable.getSourceTableName(), null);
        ArrayList<String> multiplierColumnList = new ArrayList<String>();
        while (destMultiplierColumnList.next()) {
            String multiplierColumnName = destMultiplierColumnList.getString(COLUMN_NAME);
            multiplierColumnList.add(multiplierColumnName);
        }
        String sql = "insert into " + insertINTOTable + " (";
        for (i = 0; i < multiplierColumnList.size(); ++i) {
            sql = sql + (String)multiplierColumnList.get(i);
            if (i == multiplierColumnList.size() - 1) continue;
            sql = sql + ", ";
        }
        sql = sql + ") values (";
        for (i = 0; i < multiplierColumnList.size(); ++i) {
            sql = sql + "?";
            if (i == multiplierColumnList.size() - 1) continue;
            sql = sql + ",";
        }
        sql = sql + ")";
        PreparedStatement prepareStatement = conDestination.prepareStatement(sql);
        String sourceSql = "select * from " + dbTable.getSourceTableName();
        Statement sourceStatement = conSource.createStatement();
        ResultSet sourceResultSet = sourceStatement.executeQuery(sourceSql);
        while (sourceResultSet.next()) {
            String name = sourceResultSet.getString(1);
            String ticket_prefix = sourceResultSet.getString(2);
            String rate = sourceResultSet.getString(3);
            String sort_order = sourceResultSet.getString(4);
            String default_multp = sourceResultSet.getString(5);
            String main = sourceResultSet.getString(6);
            String btn_color = sourceResultSet.getString(7);
            String txt_color = sourceResultSet.getString(8);
            prepareStatement.setString(1, name);
            prepareStatement.setInt(2, 1);
            prepareStatement.setNull(3, 12);
            prepareStatement.setString(4, ticket_prefix);
            prepareStatement.setDouble(5, Double.parseDouble(rate));
            prepareStatement.setInt(6, Integer.parseInt(sort_order));
            prepareStatement.setBoolean(7, Boolean.parseBoolean(default_multp));
            prepareStatement.setBoolean(8, Boolean.parseBoolean(main));
            if (btn_color != null && StringUtils.isNotEmpty((String)btn_color)) {
                prepareStatement.setInt(9, Integer.parseInt(btn_color));
            } else {
                prepareStatement.setNull(9, 4);
            }
            if (txt_color != null && StringUtils.isNotEmpty((String)txt_color)) {
                prepareStatement.setInt(10, Integer.parseInt(txt_color));
            } else {
                prepareStatement.setNull(10, 4);
            }
            prepareStatement.executeUpdate();
        }
        conDestination.commit();
    }

    private boolean isImageColumn(String colDataTypeName) {
        List<String> dataTypeList = Arrays.asList("blob", "longblob", "oid");
        return dataTypeList.contains(colDataTypeName.toLowerCase());
    }

    private ArrayList<DbTable> generateCommonTable(ResultSet srcDbTableList, ResultSet destinationTableNames) throws SQLException {
        String tableName;
        ArrayList<String> sourceTableNameList = new ArrayList<String>();
        ArrayList<String> destinationTableNameList = new ArrayList<String>();
        ArrayList<DbTable> tableList = new ArrayList<DbTable>();
        while (srcDbTableList.next()) {
            tableName = srcDbTableList.getString(TABLE_NAME);
            sourceTableNameList.add(tableName);
        }
        while (destinationTableNames.next()) {
            tableName = destinationTableNames.getString(TABLE_NAME);
            destinationTableNameList.add(tableName);
        }
        block2: for (String desTable : destinationTableNameList) {
            for (String sourceTable : sourceTableNameList) {
                DbTable t;
                if (desTable.equalsIgnoreCase(sourceTable)) {
                    t = new DbTable(sourceTable, desTable);
                    tableList.add(t);
                    continue block2;
                }
                if (!desTable.equalsIgnoreCase("STORE") || !sourceTable.equalsIgnoreCase("RESTAURANT")) continue;
                t = new DbTable(sourceTable, desTable);
                tableList.add(t);
                continue block2;
            }
        }
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConstrainsFromDestDB(DbConnectionInfo destinationDbConnectionInfo) throws Exception {
        Connection con = null;
        try (Statement stmt = null;){
            String tableName;
            con = destinationDbConnectionInfo.getConnection();
            DatabaseMetaData databaseMetaData = con.getMetaData();
            String hibernateDialect = destinationDbConnectionInfo.getSelectedDatabase().getHibernateDialect();
            Dialect dialect = (Dialect)Class.forName(hibernateDialect).newInstance();
            String dropForeignKeyString = dialect.getDropForeignKeyString();
            stmt = con.createStatement();
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, new String[]{TABLE});
            while (resultSet.next()) {
                String sql;
                tableName = resultSet.getString(TABLE_NAME);
                ResultSet constraints = databaseMetaData.getImportedKeys(null, null, tableName);
                while (constraints.next()) {
                    sql = "alter table " + tableName + dropForeignKeyString + constraints.getString(FK_NAME);
                    stmt.execute(sql);
                }
                constraints = databaseMetaData.getExportedKeys(null, null, tableName);
                while (constraints.next()) {
                    sql = "alter table " + constraints.getString(FKTABLE_NAME) + dropForeignKeyString + constraints.getString(FK_NAME);
                    stmt.execute(sql);
                }
                ArrayList<String> pkColumnName = new ArrayList<String>();
                ResultSet rsCoulmn = databaseMetaData.getColumns(null, null, tableName, null);
                ResultSet priCol = databaseMetaData.getPrimaryKeys(null, null, tableName);
                while (priCol.next()) {
                    String name = priCol.getString(COLUMN_NAME);
                    pkColumnName.add(name);
                }
                ResultSetMetaData rsmd = rsCoulmn.getMetaData();
                int i = 1;
                while (rsCoulmn.next()) {
                    int is_nullable;
                    String columnName = rsCoulmn.getString(COLUMN_NAME);
                    if (i < rsmd.getColumnCount() && (is_nullable = rsmd.isNullable(i)) == 0 && !pkColumnName.contains(columnName)) {
                        String sql2 = "ALTER TABLE " + tableName + " ALTER COLUMN " + columnName + " null";
                        stmt.execute(sql2);
                    }
                    ++i;
                }
            }
            resultSet = databaseMetaData.getTables(null, null, null, new String[]{TABLE});
            while (resultSet.next()) {
                tableName = resultSet.getString(TABLE_NAME);
                String sql = "DELETE from " + tableName;
                stmt.execute(sql);
            }
            con.commit();
        }
    }
}

