/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Database;
import com.floreantpos.Messages;
import com.floreantpos.actions.PosAction;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.main.Main;
import com.floreantpos.model.UserPermission;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressDialog;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.datamigrate.DbConnectionInfo;
import com.floreantpos.util.datamigrate.DbTable;
import com.floreantpos.util.datamigrate.DbTableColumn;
import com.floreantpos.util.datamigrate.MigrateDatabaseConfigurationDialog;
import com.orocube.common.util.GlobalIdGenerator;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JOptionPane;
import org.hibernate.dialect.Dialect;

public class MigrateFloreantposAction
extends PosAction {
    private static final String FK_NAME = "FK_NAME";
    private static final String FKTABLE_NAME = "FKTABLE_NAME";
    private static final String TABLE_NAME = "TABLE_NAME";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String TABLE = "TABLE";
    private DbConnectionInfo sourceDbConnectionInfo;
    private DbConnectionInfo destinationDbConnectionInfo;
    private MigrateDatabaseConfigurationDialog migrationConfigDialog;

    public MigrateFloreantposAction() {
        super(Messages.getString("MigrateDatabase.1"), UserPermission.PERFORM_ADMINISTRATIVE_TASK);
        this.setMandatoryPermission(true);
    }

    @Override
    public void execute() {
        this.startDatabaseMigration();
    }

    private boolean initDbConnectionInfo() {
        this.migrationConfigDialog = new MigrateDatabaseConfigurationDialog();
        this.migrationConfigDialog.setTitle("Please configure source database connection.");
        this.migrationConfigDialog.setSize(PosUIManager.getSize(830, 430));
        this.migrationConfigDialog.open();
        if (this.migrationConfigDialog.isCanceled()) {
            return false;
        }
        this.sourceDbConnectionInfo = this.migrationConfigDialog.getSourceConnectionInfo();
        this.destinationDbConnectionInfo = this.migrationConfigDialog.getDestinationConnectionInfo();
        return true;
    }

    private void startDatabaseMigration() {
        if (!this.initDbConnectionInfo()) {
            return;
        }
        if (this.sourceDbConnectionInfo.equals(this.destinationDbConnectionInfo)) {
            POSMessageDialog.showError(BackOfficeWindow.getInstance(), "Destination and source database cannot be same.");
            return;
        }
        String warningMessage = "This will wipe all data from your destination (current) database. Do you wish to continue?";
        int reply1 = JOptionPane.showConfirmDialog(POSUtil.getBackOfficeWindow(), warningMessage, "Migrate Database", 0);
        if (reply1 != 0) {
            return;
        }
        ProgressDialog progressDialog = new ProgressDialog(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void execute(ProgressObserver progressObserver) {
                try {
                    MigrateFloreantposAction.this.sourceDbConnectionInfo.openConnection();
                    MigrateFloreantposAction.this.destinationDbConnectionInfo.openConnection();
                    MigrateFloreantposAction.this.differenceSourceDestination(MigrateFloreantposAction.this.sourceDbConnectionInfo, MigrateFloreantposAction.this.destinationDbConnectionInfo);
                    MigrateFloreantposAction.this.removeConstrainsFromDestDB(MigrateFloreantposAction.this.destinationDbConnectionInfo);
                    MigrateFloreantposAction.this.loadSourceDBToDestinationDB(MigrateFloreantposAction.this.sourceDbConnectionInfo, MigrateFloreantposAction.this.destinationDbConnectionInfo);
                    Database selectedDatabase = MigrateFloreantposAction.this.destinationDbConnectionInfo.getSelectedDatabase();
                    DatabaseUtil.updateDatabase(MigrateFloreantposAction.this.destinationDbConnectionInfo.getConnectionString(), selectedDatabase.getHibernateDialect(), selectedDatabase.getHibernateConnectionDriverClass(), MigrateFloreantposAction.this.destinationDbConnectionInfo.getUserName(), MigrateFloreantposAction.this.destinationDbConnectionInfo.getPassword());
                    JOptionPane.showMessageDialog(POSUtil.getBackOfficeWindow(), "Data successfylly migrated. The system will now restart.");
                    Main.restart();
                }
                catch (Exception e) {
                    String string = "Data migration failed due to the following error. Please check the system carefully, current database may be corrupted.";
                    string = string + "\nError: " + e.getMessage();
                    POSMessageDialog.showError(BackOfficeWindow.getInstance(), string, e);
                }
                finally {
                    try {
                        MigrateFloreantposAction.this.sourceDbConnectionInfo.getConnection().close();
                        MigrateFloreantposAction.this.destinationDbConnectionInfo.getConnection().close();
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
            }
        };
        progressDialog.setTitle("Db migration..");
        progressDialog.setProgressLabelText("Migration is in progress..");
        progressDialog.setSize(PosUIManager.getSize(500, 150));
        progressDialog.setIndeterminate(true);
        progressDialog.setCancelable(false);
        progressDialog.open();
    }

    protected void loadSourceDBToDestinationDB(DbConnectionInfo sourceDbConnectionInfo2, DbConnectionInfo destinationDbConnectionInfo2) throws SQLException {
        Connection conSource = this.sourceDbConnectionInfo.getConnection();
        DatabaseMetaData sourceMetaData = conSource.getMetaData();
        Connection conDestination = this.destinationDbConnectionInfo.getConnection();
        DatabaseMetaData destinationDBMetadata = conDestination.getMetaData();
        ResultSet srcDbTableList = sourceMetaData.getTables(null, null, null, new String[]{TABLE});
        ResultSet destinationTableNames = destinationDBMetadata.getTables(null, null, null, new String[]{TABLE});
        ArrayList<DbTable> tableList = this.generateSourceDestinationTables(srcDbTableList, destinationTableNames);
        srcDbTableList = sourceMetaData.getTables(null, null, null, new String[]{TABLE});
        destinationTableNames = destinationDBMetadata.getTables(null, null, null, new String[]{TABLE});
        for (DbTable dbTable : tableList) {
            ArrayList<DbTableColumn> tableColumns = this.populateColumns(dbTable, sourceMetaData, destinationDBMetadata);
            this.copyData(conDestination, conSource, dbTable, tableColumns);
        }
    }

    private void copyData(Connection conDestination, Connection conSource, DbTable dbTable, ArrayList<DbTableColumn> tableColumns) throws SQLException {
        String sql = "select * from " + dbTable.getSourceTableName();
        Statement statement = conSource.createStatement();
        ResultSet resultSet = statement.executeQuery(sql);
        while (resultSet.next()) {
            for (DbTableColumn tableColumn : tableColumns) {
                Object value;
                if (tableColumn.getSourceColumnName() == null && tableColumn.getDestColumnName().equalsIgnoreCase("VERSION_NO")) {
                    Integer colValue = 1;
                    tableColumn.setColumnValue(colValue);
                    continue;
                }
                if (tableColumn.getSourceColumnName() != null && tableColumn.getSourceColumnName().equalsIgnoreCase("USER_PASS")) {
                    this.encryptPassIfNotEncrypted(resultSet, tableColumn);
                    continue;
                }
                if (tableColumn.getSourceColumnName() == null && tableColumn.getDestColumnName().equalsIgnoreCase("GLOBAL_ID")) {
                    String global_id = GlobalIdGenerator.generate();
                    value = global_id;
                    tableColumn.setColumnValue(value);
                    continue;
                }
                if (tableColumn.getSourceColumnName() == null && tableColumn.getDestColumnName().equalsIgnoreCase("ROOT")) {
                    boolean root = true;
                    value = root;
                    tableColumn.setColumnValue(value);
                    continue;
                }
                if (tableColumn.getDestColumnName().equalsIgnoreCase("CLOCKED_IN")) {
                    boolean clocked_id = false;
                    value = clocked_id;
                    tableColumn.setColumnValue(value);
                    continue;
                }
                Object colValue = resultSet.getObject(tableColumn.getSourceColumnName());
                tableColumn.setColumnValue(colValue);
            }
            String insertINTOTable = dbTable.getDestTableName();
            sql = "insert into " + insertINTOTable + " (";
            Iterator<DbTableColumn> iterator = tableColumns.iterator();
            while (iterator.hasNext()) {
                DbTableColumn tableColumn = iterator.next();
                String key = tableColumn.getDestColumnName();
                sql = sql + key;
                if (!iterator.hasNext()) continue;
                sql = sql + ",";
            }
            sql = sql + ") values (";
            iterator = tableColumns.iterator();
            while (iterator.hasNext()) {
                sql = sql + "?";
                iterator.next();
                if (!iterator.hasNext()) continue;
                sql = sql + ",";
            }
            sql = sql + ")";
            System.out.println(sql);
            PreparedStatement prepareStatement = conDestination.prepareStatement(sql);
            Iterator<DbTableColumn> iterator2 = tableColumns.iterator();
            while (iterator2.hasNext()) {
                iterator2.next();
                for (int i = 0; i < tableColumns.size(); ++i) {
                    DbTableColumn tableColumn = tableColumns.get(i);
                    prepareStatement.setObject(i + 1, tableColumn.getColumnValue());
                }
            }
            prepareStatement.executeUpdate();
            conDestination.commit();
        }
    }

    private void encryptPassIfNotEncrypted(ResultSet resultSet, DbTableColumn tableColumn) throws SQLException {
        Object colValue = resultSet.getObject(tableColumn.getSourceColumnName());
        String pass = colValue.toString();
        try {
            AESencrp.decrypt(pass);
        }
        catch (Exception e) {
            try {
                String encryptedPass;
                String value = encryptedPass = AESencrp.encrypt(pass);
                tableColumn.setColumnValue(value);
            }
            catch (Exception e1) {
                tableColumn.setColumnValue(colValue);
            }
        }
    }

    private ArrayList<DbTable> generateSourceDestinationTables(ResultSet srcDbTableList, ResultSet destinationTableNames) throws SQLException {
        String tableName;
        ArrayList<String> sourceTableNameList = new ArrayList<String>();
        ArrayList<String> destinationTableNameList = new ArrayList<String>();
        ArrayList<DbTable> tableList = new ArrayList<DbTable>();
        while (destinationTableNames.next()) {
            tableName = destinationTableNames.getString(TABLE_NAME);
            destinationTableNameList.add(tableName);
        }
        while (srcDbTableList.next()) {
            tableName = srcDbTableList.getString(TABLE_NAME);
            if (tableName.equalsIgnoreCase("RESTAURANT")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("USERS")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("USER_PERMISSION")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("MENU_ITEM")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("MENU_GROUP")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("MENU_CATEGORY")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("CURRENCY")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("CUSTOMER")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("CUSTOM_PAYMENT")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("DELIVERY_ADDRESS")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("DELIVERY_CONFIGURATION")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("SHIFT")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("SHOP_FLOOR")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("SHOP_TABLE")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("TAX")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("TAX_GROUP")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("ZIP_CODE_VS_DELIVERY_CHARGE")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("USER_TYPE")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("USER_USER_PERMISSION")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("ORDER_TYPE")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("MULTIPLIER")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("PACKAGING_UNIT")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("COOKING_INSTRUCTION")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("COUPON_AND_DISCOUNT")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("INVENTORY_LOCATION")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("INVENTORY_UNIT")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (tableName.equalsIgnoreCase("MENU_MODIFIER")) {
                sourceTableNameList.add(tableName);
                continue;
            }
            if (!tableName.equalsIgnoreCase("MENU_MODIFIER_GROUP")) continue;
            sourceTableNameList.add(tableName);
        }
        block2: for (String destTable : destinationTableNameList) {
            for (String sourceTable : sourceTableNameList) {
                DbTable t;
                if (destTable.equalsIgnoreCase(sourceTable)) {
                    t = new DbTable(sourceTable, destTable);
                    tableList.add(t);
                    continue block2;
                }
                if (destTable.equalsIgnoreCase("STORE") && sourceTable.equalsIgnoreCase("RESTAURANT")) {
                    t = new DbTable(sourceTable, destTable);
                    tableList.add(t);
                    continue block2;
                }
                if (!destTable.equalsIgnoreCase("MODIFIER_GROUP") || !sourceTable.equalsIgnoreCase("MENU_MODIFIER_GROUP")) continue;
                t = new DbTable(sourceTable, destTable);
                tableList.add(t);
                continue block2;
            }
        }
        return tableList;
    }

    private ArrayList<DbTableColumn> populateColumns(DbTable dbTable, DatabaseMetaData sourceMetaData, DatabaseMetaData destinationDBMetadata) throws SQLException {
        ArrayList<String> sourceTableColumns = new ArrayList<String>();
        ArrayList<String> destTableColumns = new ArrayList<String>();
        ResultSet sourcecolumns = sourceMetaData.getColumns(null, null, dbTable.getSourceTableName(), null);
        while (sourcecolumns.next()) {
            String columnName = sourcecolumns.getString(COLUMN_NAME);
            sourceTableColumns.add(columnName);
        }
        ResultSet destinationColumns = destinationDBMetadata.getColumns(null, null, dbTable.getDestTableName(), null);
        while (destinationColumns.next()) {
            String columnName = destinationColumns.getString(COLUMN_NAME);
            destTableColumns.add(columnName);
        }
        ArrayList<DbTableColumn> tableColumns = new ArrayList<DbTableColumn>();
        block2: for (String desTable : destTableColumns) {
            Object t;
            if (desTable.equalsIgnoreCase("VERSION_NO") && !sourceTableColumns.contains("VERSION_NO") && !sourceTableColumns.contains("VERSION_NO".toLowerCase())) {
                t = new DbTableColumn(null, desTable);
                tableColumns.add((DbTableColumn)t);
            } else if (desTable.equalsIgnoreCase("GLOBAL_ID") && !sourceTableColumns.contains("GLOBAL_ID") && !sourceTableColumns.contains("GLOBAL_ID".toLowerCase())) {
                t = new DbTableColumn(null, desTable);
                tableColumns.add((DbTableColumn)t);
            } else if (desTable.equalsIgnoreCase("ROOT") && !sourceTableColumns.contains("ROOT") && !sourceTableColumns.contains("ROOT".toLowerCase())) {
                t = new DbTableColumn(null, desTable);
                tableColumns.add((DbTableColumn)t);
            }
            for (String sourceTable : sourceTableColumns) {
                DbTableColumn t2;
                if (!dbTable.getDestTableName().equalsIgnoreCase("USERS") && (desTable.equalsIgnoreCase(sourceTable) || desTable.equalsIgnoreCase("ID") && sourceTable.equalsIgnoreCase("auto_id"))) {
                    t2 = new DbTableColumn(sourceTable, desTable);
                    tableColumns.add(t2);
                    continue block2;
                }
                if (dbTable.getDestTableName().equalsIgnoreCase("MULTIPLIER") && desTable.equalsIgnoreCase("ID") && sourceTable.equalsIgnoreCase("NAME")) {
                    t2 = new DbTableColumn(sourceTable, desTable);
                    tableColumns.add(t2);
                    continue block2;
                }
                if (!dbTable.getDestTableName().equalsIgnoreCase("USERS")) continue;
                if (desTable.equalsIgnoreCase("ID") && sourceTable.equalsIgnoreCase("user_id")) {
                    t2 = new DbTableColumn(sourceTable, desTable);
                    tableColumns.add(t2);
                    continue block2;
                }
                if (!desTable.equalsIgnoreCase(sourceTable)) continue;
                t2 = new DbTableColumn(sourceTable, desTable);
                tableColumns.add(t2);
                continue block2;
            }
        }
        for (DbTableColumn dbTableColumn : tableColumns) {
            ResultSet columns = destinationDBMetadata.getColumns(null, null, dbTable.getDestTableName(), dbTableColumn.getDestColumnName());
            if (!columns.next()) continue;
            dbTableColumn.setColumnType(columns.getString(TYPE_NAME));
        }
        return tableColumns;
    }

    private void differenceSourceDestination(DbConnectionInfo sourceDbConnectionInfo, DbConnectionInfo destinationDbConnectionInfo) throws Exception {
        String tableName;
        sourceDbConnectionInfo.openConnection();
        destinationDbConnectionInfo.openConnection();
        Connection conSource = sourceDbConnectionInfo.getConnection();
        DatabaseMetaData sourceMetaData = conSource.getMetaData();
        Connection conDestination = destinationDbConnectionInfo.getConnection();
        DatabaseMetaData destinationDBMetadata = conDestination.getMetaData();
        ResultSet srcDbTableList = sourceMetaData.getTables(null, null, null, new String[]{TABLE});
        ResultSet destinationTableNames = destinationDBMetadata.getTables(null, null, null, new String[]{TABLE});
        ArrayList<String> sourceTableNameList = new ArrayList<String>();
        ArrayList<String> destinationTableNameList = new ArrayList<String>();
        while (srcDbTableList.next()) {
            tableName = srcDbTableList.getString(TABLE_NAME);
            sourceTableNameList.add(tableName);
        }
        while (destinationTableNames.next()) {
            tableName = destinationTableNames.getString(TABLE_NAME);
            destinationTableNameList.add(tableName);
        }
        ArrayList<String> source_vs_destination = this.generateUnCommonTable(sourceTableNameList, destinationTableNameList, true);
        ArrayList<String> destination_vs_source = this.generateUnCommonTable(sourceTableNameList, destinationTableNameList, false);
        System.out.println("Tables Not in OroPos: ");
        for (String table : source_vs_destination) {
            System.out.println(table);
        }
        System.out.println("\n\n\n\nTables Not in FloreantPos: ");
        for (String table : destination_vs_source) {
            System.out.println(table);
        }
        this.findCommonTablesWithColumns(sourceTableNameList, destinationTableNameList, sourceDbConnectionInfo, destinationDbConnectionInfo);
    }

    private void findCommonTablesWithColumns(ArrayList<String> sourceTableNameList, ArrayList<String> destinationTableNameList, DbConnectionInfo sourceDbConnectionInfo, DbConnectionInfo destinationDbConnectionInfo) {
        ArrayList<String> commonTables = new ArrayList<String>();
        commonTables.addAll(destinationTableNameList);
        commonTables.retainAll(destinationTableNameList);
        Connection conSource = sourceDbConnectionInfo.getConnection();
        Connection conDestination = destinationDbConnectionInfo.getConnection();
        try {
            DatabaseMetaData sourceDbMetaData = conSource.getMetaData();
            DatabaseMetaData destinationDbMetaData = conDestination.getMetaData();
            for (String table : commonTables) {
                ArrayList<String> sourceColumnsName = new ArrayList<String>();
                ArrayList<String> destinationColumnsName = new ArrayList<String>();
                ArrayList<String> temp = new ArrayList<String>();
                ResultSet sourcecolumns = sourceDbMetaData.getColumns(null, null, table, null);
                while (sourcecolumns.next()) {
                    String columnName = sourcecolumns.getString(COLUMN_NAME);
                    sourceColumnsName.add(columnName);
                }
                ResultSet destinationcecolumns = destinationDbMetaData.getColumns(null, null, table, null);
                while (destinationcecolumns.next()) {
                    String columnName = destinationcecolumns.getString(COLUMN_NAME);
                    destinationColumnsName.add(columnName);
                }
                temp.addAll(destinationColumnsName);
                destinationColumnsName.removeAll(sourceColumnsName);
                System.out.println("Column Mis Match Found On: " + table);
                System.out.print("Destination: ");
                for (String column : destinationColumnsName) {
                    System.out.print(column + ",");
                }
                sourceColumnsName.removeAll(temp);
                System.out.print("\tSource: ");
                for (String column : sourceColumnsName) {
                    System.out.print(column + ",");
                }
                System.out.println();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private ArrayList<String> generateUnCommonTable(ArrayList<String> sourceTableNameList, ArrayList<String> destinationTableNameList, boolean b) {
        ArrayList<String> unCommonTableNameList = new ArrayList<String>();
        if (b) {
            unCommonTableNameList.addAll(sourceTableNameList);
            unCommonTableNameList.removeAll(destinationTableNameList);
        } else {
            unCommonTableNameList.addAll(destinationTableNameList);
            unCommonTableNameList.removeAll(sourceTableNameList);
        }
        return unCommonTableNameList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeConstrainsFromDestDB(DbConnectionInfo destinationDbConnectionInfo) throws Exception {
        Connection con = null;
        try (Statement stmt = null;){
            String tableName;
            con = destinationDbConnectionInfo.getConnection();
            DatabaseMetaData databaseMetaData = con.getMetaData();
            String hibernateDialect = destinationDbConnectionInfo.getSelectedDatabase().getHibernateDialect();
            Dialect dialect = (Dialect)Class.forName(hibernateDialect).newInstance();
            String dropForeignKeyString = dialect.getDropForeignKeyString();
            stmt = con.createStatement();
            ResultSet resultSet = databaseMetaData.getTables(null, null, null, new String[]{TABLE});
            while (resultSet.next()) {
                String sql;
                tableName = resultSet.getString(TABLE_NAME);
                ResultSet constraints = databaseMetaData.getImportedKeys(null, null, tableName);
                while (constraints.next()) {
                    sql = "alter table " + tableName + dropForeignKeyString + constraints.getString(FK_NAME);
                    stmt.execute(sql);
                }
                constraints = databaseMetaData.getExportedKeys(null, null, tableName);
                while (constraints.next()) {
                    sql = "alter table " + constraints.getString(FKTABLE_NAME) + dropForeignKeyString + constraints.getString(FK_NAME);
                    stmt.execute(sql);
                }
                ArrayList<String> pkColumnName = new ArrayList<String>();
                ResultSet rsCoulmn = databaseMetaData.getColumns(null, null, tableName, null);
                ResultSet priCol = databaseMetaData.getPrimaryKeys(null, null, tableName);
                while (priCol.next()) {
                    String name = priCol.getString(COLUMN_NAME);
                    pkColumnName.add(name);
                }
                ResultSetMetaData rsmd = rsCoulmn.getMetaData();
                int i = 1;
                while (rsCoulmn.next()) {
                    int is_nullable;
                    String columnName = rsCoulmn.getString(COLUMN_NAME);
                    if (i < rsmd.getColumnCount() && (is_nullable = rsmd.isNullable(i)) == 0 && !pkColumnName.contains(columnName)) {
                        String sql2 = "ALTER TABLE " + tableName + " ALTER COLUMN " + columnName + " null";
                        stmt.execute(sql2);
                    }
                    ++i;
                }
            }
            resultSet = databaseMetaData.getTables(null, null, null, new String[]{TABLE});
            while (resultSet.next()) {
                tableName = resultSet.getString(TABLE_NAME);
                String sql = "DELETE from " + tableName;
                stmt.execute(sql);
            }
            con.commit();
        }
    }
}

