/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.POSConstants;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.Timer;
import net.miginfocom.swing.MigLayout;

public abstract class PosProgressDialog
extends POSDialog
implements ProgressObserver {
    private JLabel lblProgress;
    private JLabel lblDotString = new JLabel("");
    private JPanel progressPanel;
    private Timer timer;
    private JProgressBar jpb = new JProgressBar();
    private PosButton btnOk;

    public PosProgressDialog() {
        super(POSUtil.getBackOfficeWindow(), "", true);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BorderLayout());
        this.progressPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 20 20 5 20,center", "[250]", "[]"));
        this.lblProgress = new JLabel();
        this.progressPanel.add((Component)this.lblProgress, "split 2");
        this.progressPanel.add((Component)this.lblDotString, "wrap");
        this.progressPanel.add((Component)this.jpb, "grow,span,wrap");
        this.jpb.setPreferredSize(PosUIManager.getSize(0, 30));
        this.btnOk = new PosButton(POSConstants.OK);
        this.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PosProgressDialog.this.close();
            }
        });
        this.progressPanel.add((Component)this.btnOk, "center,gaptop 5,gapbottom 5");
        contentPanel.setMinimumSize(PosUIManager.getSize(300, 200));
        contentPanel.add(this.progressPanel);
        this.timer = new Timer(200, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PosProgressDialog.this.progress(PosProgressDialog.this.jpb.getValue() + 1);
                if (PosProgressDialog.this.lblDotString.equals(".")) {
                    PosProgressDialog.this.lblDotString.setText("..");
                } else if (PosProgressDialog.this.lblDotString.equals("..")) {
                    PosProgressDialog.this.lblDotString.setText("...");
                } else if (PosProgressDialog.this.lblDotString.equals("...")) {
                    PosProgressDialog.this.lblDotString.setText(".");
                }
            }
        });
        this.add(contentPanel);
    }

    public void close() {
        this.timer.stop();
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void setVisible(boolean b) {
        if (b) {
            new Thread(){

                @Override
                public void run() {
                    PosProgressDialog.this.btnOk.setEnabled(false);
                    PosProgressDialog.this.progress(0);
                    PosProgressDialog.this.lblDotString.setText(".");
                    PosProgressDialog.this.timer.start();
                    try {
                        PosProgressDialog.this.doBackgroundTask();
                        PosProgressDialog.this.close();
                        PosProgressDialog.this.done();
                    }
                    catch (Exception e) {
                        PosProgressDialog.this.close();
                        PosProgressDialog.this.error(e);
                    }
                    finally {
                        PosProgressDialog.this.btnOk.setEnabled(true);
                        PosProgressDialog.this.timer.stop();
                    }
                }
            }.start();
        } else {
            this.timer.stop();
        }
        super.setVisible(b);
    }

    public abstract void doBackgroundTask() throws Exception;

    public abstract void done();

    public abstract void error(Exception var1);

    @Override
    public void progress(int percent, String text) {
        this.lblProgress.setText(text);
        this.jpb.setValue(percent);
    }

    @Override
    public void progress(int percent) {
        this.jpb.setValue(percent);
    }

    @Override
    public Component getParentComponent() {
        return POSUtil.getFocusedWindow();
    }

    @Override
    public void progress(String text) {
        this.lblProgress.setText(text);
    }

    public void setProgressLabelText(String text) {
        this.lblProgress.setText(text);
    }
}

