/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.model.ComboGroupItemSelectionDialog;
import com.floreantpos.ui.model.ComboItemEntryDialog;
import com.floreantpos.util.NumberUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class ComboItemExplorer
extends TransparentPanel
implements ActionListener {
    private JTable comboItemTable;
    private JTable comboGroupTable;
    private final ComboItemExplorerTableModel comboItemModel;
    private final ComboGroupExplorerTableModel comboGroupModel;
    private MenuItem menuItem;

    public ComboItemExplorer() {
        this.initComponents();
        this.comboItemModel = new ComboItemExplorerTableModel();
        this.comboItemTable.setModel(this.comboItemModel);
        this.comboGroupModel = new ComboGroupExplorerTableModel();
        this.comboGroupTable.setModel(this.comboGroupModel);
        this.resizeTableColumns();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.comboItemTable = new JTable();
        this.comboItemTable.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.comboItemTable.setRowHeight(30);
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.setActionCommand(POSConstants.ADD);
        addButton.addActionListener(this);
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.setActionCommand(POSConstants.EDIT);
        editButton.addActionListener(this);
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.setActionCommand(POSConstants.DELETE);
        deleteButton.addActionListener(this);
        TransparentPanel comboItemActionPanel = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 10 0"));
        comboItemActionPanel.add(addButton);
        comboItemActionPanel.add(editButton);
        comboItemActionPanel.add(deleteButton);
        this.add((Component)new JScrollPane(this.comboItemTable), "grow");
        this.add((Component)comboItemActionPanel, "grow,newline");
        this.comboGroupTable = new JTable();
        this.comboGroupTable.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.comboGroupTable.setRowHeight(30);
        JButton addGroupButton = new JButton(POSConstants.ADD);
        addGroupButton.setActionCommand(POSConstants.ADD);
        JButton editGroupButton = new JButton(POSConstants.EDIT);
        editGroupButton.setActionCommand(POSConstants.EDIT);
        JButton deleteGroupButton = new JButton(POSConstants.DELETE);
        deleteGroupButton.setActionCommand(POSConstants.DELETE);
        ActionListener groupAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String actionCommand = e.getActionCommand();
                if (POSConstants.ADD.equals(actionCommand)) {
                    ComboItemExplorer.this.addNewComboGroup();
                } else if (POSConstants.EDIT.equals(actionCommand)) {
                    int index = ComboItemExplorer.this.comboGroupTable.getSelectedRow();
                    if (index < 0) {
                        BOMessageDialog.showError("Please select one item.");
                        return;
                    }
                    ComboGroup menuItem = ComboItemExplorer.this.comboGroupModel.getComboGroup(index);
                    ComboItemExplorer.this.editComboGroup(menuItem);
                } else if (POSConstants.DELETE.equals(actionCommand)) {
                    int index = ComboItemExplorer.this.comboGroupTable.getSelectedRow();
                    if (index < 0) {
                        BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                        return;
                    }
                    ComboGroup menuItem = ComboItemExplorer.this.comboGroupModel.getComboGroup(index);
                    ComboItemExplorer.this.deleteComboGroup(index, menuItem);
                }
            }
        };
        addGroupButton.addActionListener(groupAction);
        editGroupButton.addActionListener(groupAction);
        deleteGroupButton.addActionListener(groupAction);
        TransparentPanel comboGroupButtonActionPanel = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 10 0"));
        comboGroupButtonActionPanel.add(addGroupButton);
        comboGroupButtonActionPanel.add(editGroupButton);
        comboGroupButtonActionPanel.add(deleteGroupButton);
        this.add((Component)new JScrollPane(this.comboGroupTable), "grow,newline");
        this.add((Component)comboGroupButtonActionPanel, "grow,newline");
    }

    private void resizeTableColumns() {
        this.comboGroupTable.setAutoResizeMode(4);
        this.setColumnWidth(0, PosUIManager.getSize(300));
        this.setColumnWidth(1, PosUIManager.getSize(100));
        this.setColumnWidth(2, PosUIManager.getSize(100));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.comboGroupTable.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
        column.setMinWidth(width);
    }

    public void setMenuItem(MenuItem menuItem) {
        this.menuItem = menuItem;
        this.comboItemModel.setItems(menuItem.getComboItems());
        this.comboGroupModel.setItems(menuItem.getComboGroups());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.ADD.equals(actionCommand)) {
            this.addNewComboItem();
        } else if (POSConstants.EDIT.equals(actionCommand)) {
            int index = this.comboItemTable.getSelectedRow();
            if (index < 0) {
                BOMessageDialog.showError("Please select one item.");
                return;
            }
            ComboItem menuItem = this.comboItemModel.getComboItem(index);
            this.editComboItem(menuItem);
        } else if (POSConstants.DELETE.equals(actionCommand)) {
            int index = this.comboItemTable.getSelectedRow();
            if (index < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            ComboItem menuItem = this.comboItemModel.getComboItem(index);
            this.deleteComboItem(index, menuItem);
        }
    }

    private void addNewComboItem() {
        try {
            MenuItemSelectionDialog dialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
            dialog.setSize(PosUIManager.getSize(600, 515));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            ArrayList<MenuItem> existingItemList = new ArrayList<MenuItem>();
            for (ComboItem comboItem : this.comboItemModel.getItems()) {
                existingItemList.add(comboItem.getMenuItem());
            }
            List<MenuItem> selectedMenuItems = dialog.getSelectedItems();
            for (MenuItem menuItem : selectedMenuItems) {
                if (existingItemList == null || existingItemList.contains(menuItem)) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setMenuItem(menuItem);
                comboItem.setQuantity(1.0);
                this.comboItemModel.addComboItem(comboItem);
            }
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void editComboItem(ComboItem comboMenuItem) {
        try {
            ComboItemEntryDialog dialog = new ComboItemEntryDialog(this.menuItem);
            dialog.setSelectedItem(comboMenuItem.getMenuItem());
            dialog.setQuantity(comboMenuItem.getQuantity());
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            MenuItem selectedMenuItem = dialog.getItem();
            comboMenuItem.setMenuItem(selectedMenuItem);
            comboMenuItem.setQuantity(dialog.getQuantity());
            this.comboItemModel.fireTableDataChanged();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void deleteComboItem(int index, ComboItem comboItem) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.comboItemModel.deleteItem(comboItem, index);
            }
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void addNewComboGroup() {
        try {
            ComboGroup comboGroup = new ComboGroup();
            ComboGroupItemSelectionDialog dialog = new ComboGroupItemSelectionDialog(this.menuItem, comboGroup);
            dialog.setSize(PosUIManager.getSize(600, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.comboGroupModel.addComboGroup(comboGroup);
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void editComboGroup(ComboGroup comboGroup) {
        try {
            ComboGroupItemSelectionDialog dialog = new ComboGroupItemSelectionDialog(this.menuItem, comboGroup, true);
            dialog.setSize(PosUIManager.getSize(600, 600));
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.comboGroupModel.fireTableDataChanged();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void deleteComboGroup(int index, ComboGroup comboGroup) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.comboGroupModel.deleteItem(comboGroup, index);
            }
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<ComboItem> getSelectedComboItems() {
        return this.comboItemModel.getItems();
    }

    public List<ComboGroup> getSelectedComboGroups() {
        return this.comboGroupModel.getGroups();
    }

    private class ComboGroupExplorerTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Group Name", "Min Quantity", "Max Quantity", "Items"};
        List<ComboGroup> comboGroups = new ArrayList<ComboGroup>();

        public void setItems(List<ComboGroup> comboGroup) {
            if (comboGroup == null) {
                return;
            }
            this.comboGroups.addAll(comboGroup);
        }

        @Override
        public int getRowCount() {
            if (this.comboGroups == null) {
                return 0;
            }
            return this.comboGroups.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.comboGroups == null) {
                return "";
            }
            ComboGroup comboGroup = this.comboGroups.get(row);
            if (comboGroup == null) {
                return "";
            }
            switch (column) {
                case 0: {
                    return comboGroup.getName();
                }
                case 1: {
                    return comboGroup.getMinQuantity();
                }
                case 2: {
                    return comboGroup.getMaxQuantity();
                }
                case 3: {
                    return comboGroup.getItems();
                }
            }
            return null;
        }

        public void addComboGroup(ComboGroup comboGroup) {
            int size = this.comboGroups.size();
            this.comboGroups.add(comboGroup);
            this.fireTableRowsInserted(size, size);
        }

        public void deleteItem(ComboGroup group, int index) {
            Iterator<ComboGroup> iterator = this.comboGroups.iterator();
            while (iterator.hasNext()) {
                ComboGroup item = iterator.next();
                if (!group.getName().equals(item.getName())) continue;
                iterator.remove();
                break;
            }
            this.fireTableRowsDeleted(index, index);
        }

        public ComboGroup getComboGroup(int index) {
            return this.comboGroups.get(index);
        }

        public List<ComboGroup> getGroups() {
            return this.comboGroups;
        }
    }

    private class ComboItemExplorerTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Item Name", "Quantity", "Price"};
        List<ComboItem> comboItemList = new ArrayList<ComboItem>();

        public void setItems(List<ComboItem> comboItems) {
            if (comboItems == null) {
                return;
            }
            this.comboItemList.addAll(comboItems);
        }

        public List<ComboItem> getItems() {
            return this.comboItemList;
        }

        @Override
        public int getRowCount() {
            if (this.comboItemList == null) {
                return 0;
            }
            return this.comboItemList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.comboItemList == null) {
                return "";
            }
            ComboItem comboItem = this.comboItemList.get(row);
            if (comboItem == null) {
                return "";
            }
            switch (column) {
                case 0: {
                    return comboItem.getName();
                }
                case 1: {
                    return NumberUtil.trimDecilamIfNotNeeded(comboItem.getQuantity());
                }
                case 2: {
                    return comboItem.getPrice() * comboItem.getQuantity();
                }
            }
            return null;
        }

        public void addComboItem(ComboItem item) {
            int size = this.comboItemList.size();
            this.comboItemList.add(item);
            this.fireTableRowsInserted(size, size);
        }

        public void deleteItem(ComboItem comboItem, int index) {
            Iterator<ComboItem> iterator = this.comboItemList.iterator();
            while (iterator.hasNext()) {
                ComboItem item = iterator.next();
                if (comboItem.getMenuItem() != item.getMenuItem()) continue;
                iterator.remove();
            }
            this.fireTableRowsDeleted(index, index);
        }

        public ComboItem getComboItem(int index) {
            return this.comboItemList.get(index);
        }
    }
}

