/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.DepartmentEntryForm;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.Department;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class DepartmentExplorer
extends TransparentPanel {
    private static final long serialVersionUID = 1L;
    private JXTable table;
    private BeanTableModel<Department> tableModel = new BeanTableModel(Department.class);
    private JTextField tfName;
    private JComboBox cbLocation;

    public DepartmentExplorer() {
        this.tableModel.addColumn("ID", "id");
        this.tableModel.addColumn("NAME", "name");
        this.tableModel.addColumn("DESCRIPTION", "description");
        this.tableModel.addColumn("ADDRESS", "address");
        this.tableModel.addRows(DepartmentDAO.getInstance().findAll());
        this.table = new JXTable(this.tableModel);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    DepartmentExplorer.this.editSelectedRow();
                }
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
    }

    private TransparentPanel createButtonPanel() {
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    DepartmentEntryForm editor = new DepartmentEntryForm(new Department());
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.setPreferredSize(PosUIManager.getSize(500, 600));
                    dialog.setTitle(AppProperties.getAppName());
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    Department dept = (Department)editor.getBean();
                    DepartmentExplorer.this.tableModel.addRow(dept);
                }
                catch (Throwable x) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DepartmentExplorer.this.editSelectedRow();
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = DepartmentExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    index = DepartmentExplorer.this.table.convertRowIndexToModel(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    Department itemDept = (Department)DepartmentExplorer.this.tableModel.getRow(index);
                    DepartmentDAO deptDAO = new DepartmentDAO();
                    deptDAO.delete(itemDept);
                    DepartmentExplorer.this.tableModel.removeRow(index);
                }
                catch (Throwable x) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        return panel;
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        return panel;
    }

    private void searchItem() {
        String txName = this.tfName.getText();
        Object selectedGroup = this.cbLocation.getSelectedItem();
        Object similarItem = null;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(this, Messages.getString("SelectToEdit"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            Department dept = this.tableModel.getRow(index);
            dept = DepartmentDAO.getInstance().initialize(dept);
            this.tableModel.setRow(index, dept);
            DepartmentEntryForm editor = new DepartmentEntryForm(dept);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.setPreferredSize(PosUIManager.getSize(500, 600));
            dialog.setTitle(AppProperties.getAppName());
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            POSMessageDialog.showError(this, POSConstants.ERROR_MESSAGE, x);
        }
    }
}

