/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class InventoryUnitGroupEntryForm
extends BeanEditor<InventoryUnitGroup> {
    private POSTextField tfGroupName;
    private InventoryUnitGroup inventoryUnitGroup;

    public InventoryUnitGroupEntryForm(InventoryUnitGroup inventoryUnitGroup) {
        this.inventoryUnitGroup = inventoryUnitGroup;
        this.setLayout(new BorderLayout());
        this.createUI();
        this.setBean(inventoryUnitGroup);
    }

    public InventoryUnitGroupEntryForm() {
        this.setLayout(new BorderLayout());
        this.createUI();
    }

    private void createUI() {
        JPanel itemInfoPanel = new JPanel();
        this.add((Component)itemInfoPanel, "Center");
        itemInfoPanel.setLayout((LayoutManager)new MigLayout("fill,center", "[][]", ""));
        JLabel lblGroupName = new JLabel("Name");
        itemInfoPanel.add((Component)lblGroupName, "cell 0 0,alignx right");
        this.tfGroupName = new POSTextField();
        itemInfoPanel.add((Component)this.tfGroupName, "cell 1 0");
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)this.getBean();
            InventoryUnitGroupDAO inventoryUnitGroupDAO = new InventoryUnitGroupDAO();
            inventoryUnitGroupDAO.saveOrUpdate(inventoryUnitGroup);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    @Override
    public void updateView() {
        InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)this.getBean();
        if (inventoryUnitGroup == null) {
            return;
        }
        this.tfGroupName.setText(inventoryUnitGroup.getName());
    }

    @Override
    public boolean updateModel() {
        InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)this.getBean();
        String groupName = this.tfGroupName.getText();
        if (groupName != null) {
            inventoryUnitGroup.setName(groupName);
        } else {
            POSMessageDialog.showMessage("Please enter Inventory Unit Group name");
        }
        return true;
    }

    @Override
    public String getDisplayText() {
        InventoryUnitGroup inventoryUnitGroup = (InventoryUnitGroup)this.getBean();
        if (inventoryUnitGroup.getId() == null) {
            return "Inventory Unit Group Entry Form";
        }
        return "Inventory Unit Group Edit Form";
    }
}

