/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Attribute;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.VariantAttributesSelectionDialog;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class MenuItemVariantExplorer
extends TransparentPanel
implements ActionListener {
    private JTable varientTable;
    private final MenuItemExplorerTableModel varientModel;
    private MenuItem parentMenuItem;

    public MenuItemVariantExplorer() {
        this.initComponents();
        this.varientModel = new MenuItemExplorerTableModel();
        this.varientTable.setModel(this.varientModel);
        this.varientTable.setDefaultRenderer(Object.class, new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (column == 4) {
                    this.setHorizontalAlignment(0);
                } else if (column == 3) {
                    this.setHorizontalAlignment(4);
                } else {
                    this.setHorizontalAlignment(2);
                }
                return c;
            }
        });
        this.resizeTableColumns();
        this.varientTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), "startEditing");
        FixedLengthTextField tfBarcode = new FixedLengthTextField();
        DefaultCellEditor editorBarcode = new DefaultCellEditor(tfBarcode);
        editorBarcode.setClickCountToStart(1);
        FixedLengthTextField tfDisplayText = new FixedLengthTextField();
        DefaultCellEditor editorDisplayText = new DefaultCellEditor(tfDisplayText);
        editorDisplayText.setClickCountToStart(1);
        DoubleTextField tfPrice = new DoubleTextField();
        tfPrice.setAllowNegativeValue(true);
        tfPrice.setHorizontalAlignment(4);
        DefaultCellEditor editorPrice = new DefaultCellEditor(tfPrice);
        editorPrice.setClickCountToStart(1);
        JCheckBox chkVisible = new JCheckBox();
        chkVisible.setHorizontalAlignment(0);
        DefaultCellEditor editorEnable = new DefaultCellEditor(chkVisible);
        editorEnable.setClickCountToStart(1);
        this.varientTable.setDefaultEditor(this.varientTable.getColumnClass(1), editorDisplayText);
        this.varientTable.setDefaultEditor(this.varientTable.getColumnClass(2), editorBarcode);
        this.varientTable.setDefaultEditor(this.varientTable.getColumnClass(3), editorPrice);
        this.varientTable.setDefaultEditor(this.varientTable.getColumnClass(4), editorEnable);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.varientTable = new JTable(){

            @Override
            public void changeSelection(int row, int column, boolean toggle, boolean extend) {
                super.changeSelection(row, column, toggle, extend);
                MenuItemVariantExplorer.this.varientTable.editCellAt(row, column);
                MenuItemVariantExplorer.this.varientTable.transferFocus();
                DefaultCellEditor editor = (DefaultCellEditor)MenuItemVariantExplorer.this.varientTable.getCellEditor(row, column);
                if (column == 4) {
                    JCheckBox checkBox = (JCheckBox)editor.getComponent();
                    checkBox.requestFocus();
                } else if (column == 3) {
                    DoubleTextField textField = (DoubleTextField)editor.getComponent();
                    textField.requestFocus();
                    textField.selectAll();
                } else if (column == 2) {
                    FixedLengthTextField textField = (FixedLengthTextField)editor.getComponent();
                    textField.requestFocus();
                    textField.selectAll();
                } else if (column == 1) {
                    FixedLengthTextField textField = (FixedLengthTextField)editor.getComponent();
                    textField.setLength(255);
                    textField.requestFocus();
                    textField.selectAll();
                }
            }
        };
        this.varientTable.setRowHeight(PosUIManager.getSize(40));
        JButton addButton = new JButton("Select Attributes");
        addButton.setActionCommand(POSConstants.ADD);
        addButton.addActionListener(this);
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.setActionCommand(POSConstants.DELETE);
        deleteButton.addActionListener(this);
        TransparentPanel varientActionPanel = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 10 0"));
        varientActionPanel.add(addButton);
        varientActionPanel.add(deleteButton);
        this.add((Component)new JScrollPane(this.varientTable), "grow");
        this.add((Component)varientActionPanel, "grow,newline");
    }

    private void resizeTableColumns() {
        this.varientTable.setAutoResizeMode(3);
        this.setColumnWidth(0, PosUIManager.getSize(200));
        this.setColumnWidth(1, PosUIManager.getSize(300));
        this.setColumnWidth(2, PosUIManager.getSize(180));
        this.setColumnWidth(3, PosUIManager.getSize(120));
        this.setColumnWidth(4, PosUIManager.getSize(100));
    }

    private void setColumnWidth(int columnNumber, int width) {
        TableColumn column = this.varientTable.getColumnModel().getColumn(columnNumber);
        column.setPreferredWidth(width);
    }

    public void setParentMenuItem(MenuItem menuItem) {
        this.parentMenuItem = menuItem;
        this.varientModel.setItems(menuItem.getVariants());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.ADD.equals(actionCommand)) {
            this.addNewVariant();
        } else if (POSConstants.DELETE.equals(actionCommand)) {
            int index = this.varientTable.getSelectedRow();
            if (index < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            MenuItem menuItem = this.varientModel.getMenuItem(index);
            this.deleteMenuItem(index, menuItem);
        }
    }

    private void addNewVariant() {
        try {
            VariantAttributesSelectionDialog dialog = new VariantAttributesSelectionDialog(this.varientModel.getItems());
            dialog.setSize(PosUIManager.getSize(550, 450));
            dialog.setParentMenuItem(this.parentMenuItem);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            List<MenuItem> varients = dialog.getVariants();
            this.varientModel.getItems().clear();
            this.varientModel.setItems(varients);
            this.varientModel.fireTableDataChanged();
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void deleteMenuItem(int index, MenuItem varient) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.varientModel.deleteItem(varient, index);
            }
        }
        catch (Exception x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    public List<MenuItem> getVariants() {
        List<MenuItem> variants = this.varientModel.getItems();
        if (variants != null) {
            for (MenuItem variant : variants) {
                variant.setUnit(this.parentMenuItem.getUnit());
            }
        }
        return variants;
    }

    private class MenuItemExplorerTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{"Attributes", "Display Text", "Barcode", "Attribute Price Extra", "Enable"};
        List<MenuItem> varientList = new ArrayList<MenuItem>();

        public void setItems(List<MenuItem> variants) {
            if (variants == null) {
                return;
            }
            this.varientList.addAll(variants);
        }

        public List<MenuItem> getItems() {
            return this.varientList;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 1 || columnIndex == 2 || columnIndex == 3 || columnIndex == 4;
        }

        @Override
        public int getRowCount() {
            if (this.varientList == null) {
                return 0;
            }
            return this.varientList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int index) {
            return this.columnNames[index];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 4) {
                return Boolean.class;
            }
            if (columnIndex == 3) {
                return Double.class;
            }
            return String.class;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.varientList == null) {
                return "";
            }
            MenuItem varient = this.varientList.get(row);
            if (varient == null) {
                return "";
            }
            switch (column) {
                case 0: {
                    String attString = "<html>";
                    List<Attribute> attributes = varient.getAttributes();
                    if (attributes == null) {
                        return attString;
                    }
                    Iterator<Attribute> iterator = attributes.iterator();
                    while (iterator.hasNext()) {
                        Attribute attribute = iterator.next();
                        attString = attString + attribute.getGroup().getName() + ": <font style='color:red'>" + attribute.getName() + "</font>";
                        if (!iterator.hasNext()) continue;
                        attString = attString + ",&nbsp;";
                    }
                    attString = attString + "</html>";
                    return attString;
                }
                case 1: {
                    return varient.getTranslatedName();
                }
                case 2: {
                    return varient.getBarcode();
                }
                case 3: {
                    return varient.getPrice();
                }
                case 4: {
                    return varient.isVisible();
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            MenuItem varient = this.varientList.get(rowIndex);
            if (varient == null) {
                return;
            }
            if (columnIndex == 1) {
                varient.setTranslatedName(String.valueOf(aValue));
            } else if (columnIndex == 2) {
                varient.setBarcode(String.valueOf(aValue));
            } else if (columnIndex == 3) {
                String priceString = (String)aValue;
                if (priceString.isEmpty()) {
                    return;
                }
                double price = Double.parseDouble(priceString);
                varient.setPrice(price);
            } else if (columnIndex == 4) {
                Boolean enable = (Boolean)aValue;
                if (enable == null) {
                    return;
                }
                varient.setVisible(enable);
            }
            super.setValueAt(aValue, rowIndex, columnIndex);
        }

        public void deleteItem(MenuItem varient, int index) {
            Iterator<MenuItem> iterator = this.varientList.iterator();
            while (iterator.hasNext()) {
                MenuItem item = iterator.next();
                if (varient != item) continue;
                iterator.remove();
            }
            this.fireTableRowsDeleted(index, index);
        }

        public MenuItem getMenuItem(int index) {
            return this.varientList.get(index);
        }
    }
}

