/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuModifierForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;

public class ModifierExplorer
extends TransparentPanel
implements ExplorerView {
    private String currencySymbol;
    private JXTable table;
    private ModifierExplorerModel tableModel;
    private JTextField nameField;

    public ModifierExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.currencySymbol = CurrencyUtil.getCurrencySymbol();
        this.tableModel = new ModifierExplorerModel();
        this.table = new JXTable((TableModel)this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.add(new JScrollPane((Component)this.table));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    ModifierExplorer.this.editSelectedRow();
                }
            }
        });
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(8).setCellRenderer(new DefaultTableCellRenderer(){
            private Border unselectedBorder = null;
            private Border selectedBorder = null;

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                ModifierExplorerModel model = (ModifierExplorerModel)table.getModel();
                Object object = model.getRowData(row);
                if (this.selectedBorder == null) {
                    this.selectedBorder = BorderFactory.createMatteBorder(5, 5, 5, 5, table.getSelectionBackground());
                }
                if (this.unselectedBorder == null) {
                    this.unselectedBorder = BorderFactory.createMatteBorder(5, 5, 5, 5, table.getBackground());
                }
                if (object instanceof MenuModifier && value instanceof ImageIcon) {
                    JLabel lblColor = new JLabel(((MenuModifier)object).getImage());
                    if (isSelected) {
                        lblColor.setBorder(this.selectedBorder);
                    } else {
                        lblColor.setBorder(this.unselectedBorder);
                    }
                    return lblColor;
                }
                return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
        });
        this.table.setRowHeight(PosUIManager.getSize(60));
        this.createActionButtons();
        this.add((Component)this.buildSearchForm(), "North");
    }

    private void createActionButtons() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        explorerButtonPanel.getAddButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    MenuModifierForm editor = new MenuModifierForm();
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuModifier modifier = (MenuModifier)editor.getBean();
                    ModifierExplorer.this.tableModel.addModifier(modifier);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        explorerButtonPanel.getEditButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierExplorer.this.editSelectedRow();
            }
        });
        explorerButtonPanel.getDeleteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = ModifierExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    index = ModifierExplorer.this.table.convertRowIndexToModel(index);
                    if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 1) {
                        MenuModifier category = (MenuModifier)ModifierExplorer.this.tableModel.getRowData(index);
                        ModifierDAO modifierDAO = new ModifierDAO();
                        modifierDAO.delete(category);
                        ModifierExplorer.this.tableModel.deleteModifier(category, index);
                    }
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton btnDuplicate = new JButton("Dup");
        btnDuplicate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = ModifierExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Please select a row to make duplicate");
                        return;
                    }
                    index = ModifierExplorer.this.table.convertRowIndexToModel(index);
                    MenuModifier existingModifier = (MenuModifier)ModifierExplorer.this.tableModel.getRowData(index);
                    MenuModifier newMenuModifier = new MenuModifier();
                    PropertyUtils.copyProperties((Object)newMenuModifier, (Object)existingModifier);
                    newMenuModifier.setId(null);
                    String newName = ModifierExplorer.this.doDuplicateName(existingModifier);
                    newMenuModifier.setName(newName);
                    MenuModifierForm editor = new MenuModifierForm(newMenuModifier);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuModifier menuModifier = (MenuModifier)editor.getBean();
                    ModifierExplorer.this.tableModel.addModifier(menuModifier);
                    ModifierExplorer.this.table.getSelectionModel().addSelectionInterval(ModifierExplorer.this.tableModel.getRowCount() - 1, ModifierExplorer.this.tableModel.getRowCount() - 1);
                    ModifierExplorer.this.table.scrollRowToVisible(ModifierExplorer.this.tableModel.getRowCount() - 1);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        explorerButtonPanel.add(btnDuplicate);
        this.add((Component)explorerButtonPanel, "South");
    }

    private String doDuplicateName(MenuModifier existingModifier) {
        String existingName = existingModifier.getName();
        String newName = new String();
        int lastIndexOf = existingName.lastIndexOf(" ");
        if (lastIndexOf == -1) {
            newName = existingName + " 1";
        } else {
            String processName = existingName.substring(lastIndexOf + 1, existingName.length());
            if (StringUtils.isNumeric((CharSequence)processName)) {
                Integer count = Integer.valueOf(processName);
                count = count + 1;
                newName = existingName.replace(processName, String.valueOf(count));
            } else {
                newName = existingName + " 1";
            }
        }
        return newName;
    }

    private int getRandomNumber(MenuModifier selectedModifier) {
        String in = selectedModifier.getName();
        Pattern p = Pattern.compile(" .* ([0-9]+)");
        Matcher m = p.matcher(in);
        int nextNumber = 1;
        if (m.find()) {
            try {
                int previousNumber = Integer.parseInt(m.group(1));
                if (previousNumber + 1 > nextNumber) {
                    nextNumber = previousNumber + 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nextNumber;
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][]30[][]30[]", "[]20[]"));
        JLabel nameLabel = new JLabel(Messages.getString("ModifierExplorer.3"));
        JLabel groupLabel = new JLabel(Messages.getString("ModifierExplorer.4"));
        this.nameField = new JTextField(15);
        JComboBox<String> cbGroup = new JComboBox<String>();
        cbGroup.addItem(Messages.getString("ModifierExplorer.5"));
        JButton searchBttn = new JButton(Messages.getString("ModifierExplorer.6"));
        panel.add((Component)nameLabel, "align label");
        panel.add(this.nameField);
        panel.add(searchBttn);
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder title = BorderFactory.createTitledBorder(loweredetched, Messages.getString("ModifierExplorer.8"));
        title.setTitleJustification(1);
        panel.setBorder(title);
        searchBttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierExplorer.this.searchItem();
            }
        });
        return panel;
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuModifier modifier = (MenuModifier)this.tableModel.getRowData(index);
            MenuModifierDAO.getInstance().initialize(modifier);
            MenuModifierForm editor = new MenuModifierForm(modifier);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void searchItem() {
        List<MenuModifier> modifierList;
        String txName = this.nameField.getText();
        if (this.tableModel.getRowCount() > 0) {
            this.tableModel.removeAll();
        }
        if ((modifierList = MenuModifierDAO.getInstance().getMenuModifiers(txName)) == null) {
            modifierList = new ArrayList<MenuModifier>();
        }
        this.tableModel.setRows(modifierList);
    }

    @Override
    public void initData() {
        this.searchItem();
    }

    private class ModifierExplorerModel
    extends ListTableModel {
        public ModifierExplorerModel() {
            super(new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, POSConstants.PRICE + " (" + ModifierExplorer.this.currencySymbol + ")", POSConstants.EXTRA_PRICE, "TAX GROUP" + Messages.getString("ModifierExplorer.0"), POSConstants.BUTTON_COLOR, "Text Color", POSConstants.SORT_ORDER, Messages.getString("ModifierExplorer.2")});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            List modifierList = this.getRows();
            MenuModifier modifier = (MenuModifier)modifierList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return modifier.getName();
                }
                case 1: {
                    return modifier.getTranslatedName();
                }
                case 2: {
                    return (double)modifier.getPrice();
                }
                case 3: {
                    return (double)modifier.getExtraPrice();
                }
                case 4: {
                    if (modifier.getTaxGroup() == null) {
                        return "";
                    }
                    return modifier.getTaxGroup();
                }
                case 5: {
                    if (modifier.getButtonColor() != null) {
                        return new Color(modifier.getButtonColor());
                    }
                }
                case 6: {
                    if (modifier.getTextColor() != null) {
                        return new Color(modifier.getTextColor());
                    }
                    return null;
                }
                case 7: {
                    return modifier.getSortOrder();
                }
                case 8: {
                    return modifier.getImage();
                }
            }
            return null;
        }

        public void addModifier(MenuModifier category) {
            int size = this.getRows().size();
            this.getRows().add(category);
            this.fireTableRowsInserted(size, size);
        }

        public void deleteModifier(MenuModifier category, int index) {
            this.getRows().remove(category);
            this.fireTableRowsDeleted(index, index);
        }

        public void removeAll() {
            this.rows.clear();
            this.fireTableDataChanged();
        }

        public void addRows(List<MenuModifier> rows) {
            if (rows == null) {
                return;
            }
            for (MenuModifier row : rows) {
                this.addModifier(row);
            }
            this.fireTableDataChanged();
        }
    }
}

