/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ModifierGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class ModifierGroupExplorer
extends TransparentPanel
implements ExplorerView {
    private List<ModifierGroup> mGroupList;
    private JXTable table;
    private ModifierGroupExplorerTableModel tableModel;

    public ModifierGroupExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.tableModel = new ModifierGroupExplorerTableModel();
        this.table = new JXTable((TableModel)this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.add((Component)this.northRefreshPanel(), "North");
        this.add(new JScrollPane((Component)this.table));
        this.createButtonPanel();
    }

    private void createButtonPanel() {
        TransparentPanel panel = new TransparentPanel();
        ExplorerButtonPanel explorerButton = new ExplorerButtonPanel();
        JButton editButton = explorerButton.getEditButton();
        JButton addButton = explorerButton.getAddButton();
        JButton deleteButton = explorerButton.getDeleteButton();
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = ModifierGroupExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                        return;
                    }
                    index = ModifierGroupExplorer.this.table.convertRowIndexToModel(index);
                    ModifierGroup category = (ModifierGroup)ModifierGroupExplorer.this.mGroupList.get(index);
                    ModifierGroupForm editor = new ModifierGroupForm(category);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    ModifierGroupExplorer.this.table.repaint();
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ModifierGroupForm editor = new ModifierGroupForm();
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    ModifierGroup modifierGroup = (ModifierGroup)editor.getBean();
                    ModifierGroupExplorer.this.tableModel.addModifierGroup(modifierGroup);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = ModifierGroupExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    index = ModifierGroupExplorer.this.table.convertRowIndexToModel(index);
                    if (ConfirmDeleteDialog.showMessage(ModifierGroupExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 1) {
                        ModifierGroup category = (ModifierGroup)ModifierGroupExplorer.this.mGroupList.get(index);
                        ModifierGroupDAO modifierCategoryDAO = new ModifierGroupDAO();
                        modifierCategoryDAO.delete(category);
                        ModifierGroupExplorer.this.tableModel.deleteModifierGroup(category, index);
                    }
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    try {
                        int index = ModifierGroupExplorer.this.table.getSelectedRow();
                        if (index < 0) {
                            return;
                        }
                        index = ModifierGroupExplorer.this.table.convertRowIndexToModel(index);
                        ModifierGroup category = (ModifierGroup)ModifierGroupExplorer.this.mGroupList.get(index);
                        ModifierGroupForm editor = new ModifierGroupForm(category);
                        BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                        dialog.open();
                        if (dialog.isCanceled()) {
                            return;
                        }
                        ModifierGroupExplorer.this.table.repaint();
                    }
                    catch (Throwable x) {
                        BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                    }
                }
            }
        });
    }

    private JPanel northRefreshPanel() {
        JPanel northPanel = new JPanel((LayoutManager)new MigLayout(""));
        northPanel.setBorder(BorderFactory.createTitledBorder("Refresh"));
        JButton btnRefresh = new JButton(POSConstants.REFRESH);
        btnRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    ModifierGroupExplorer.this.initData();
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e2.getMessage(), e2);
                }
            }
        });
        northPanel.add(btnRefresh);
        return northPanel;
    }

    @Override
    public void initData() {
        ModifierGroupDAO dao = new ModifierGroupDAO();
        dao.updateModifierGroupBooleanPropertyValue(true);
        this.mGroupList = dao.findNormalModifierGroups();
        this.tableModel.fireTableDataChanged();
    }

    class ModifierGroupExplorerTableModel
    extends AbstractTableModel {
        String[] columnNames = new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, POSConstants.MODIFIERS};

        ModifierGroupExplorerTableModel() {
        }

        @Override
        public int getRowCount() {
            if (ModifierGroupExplorer.this.mGroupList == null) {
                return 0;
            }
            return ModifierGroupExplorer.this.mGroupList.size();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (ModifierGroupExplorer.this.mGroupList == null) {
                return "";
            }
            ModifierGroup mgroup = (ModifierGroup)ModifierGroupExplorer.this.mGroupList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return mgroup.getName();
                }
                case 1: {
                    return mgroup.getTranslatedName();
                }
                case 2: {
                    return mgroup.getModifiers().toString();
                }
            }
            return null;
        }

        public void addModifierGroup(ModifierGroup category) {
            int size = ModifierGroupExplorer.this.mGroupList.size();
            ModifierGroupExplorer.this.mGroupList.add(category);
            this.fireTableRowsInserted(size, size);
        }

        public void deleteModifierGroup(ModifierGroup category, int index) {
            ModifierGroupExplorer.this.mGroupList.remove(category);
            this.fireTableRowsDeleted(index, index);
        }
    }
}

