/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.PizzaModifierPrice;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.ModifierDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PizzaModifierForm;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;

public class PizzaModifierExplorer
extends TransparentPanel {
    private String currencySymbol;
    private JXTable table;
    private PizzaModifierExplorerModel tableModel;
    private JTextField tfName;

    public PizzaModifierExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.currencySymbol = CurrencyUtil.getCurrencySymbol();
        this.tableModel = new PizzaModifierExplorerModel();
        this.table = new JXTable((TableModel)this.tableModel);
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setSelectionMode(0);
        this.add(new JScrollPane((Component)this.table));
        this.createActionButtons();
        this.add((Component)this.buildSearchForm(), "North");
        this.updateModifierList();
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    PizzaModifierExplorer.this.editSelectedRow();
                }
            }
        });
    }

    private void editSelectedRow() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            MenuModifier modifier = (MenuModifier)this.tableModel.getRowData(index);
            PizzaModifierForm editor = new PizzaModifierForm(modifier);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.open();
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }

    private void createActionButtons() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        explorerButtonPanel.getAddButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PizzaModifierForm editor = new PizzaModifierForm();
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuModifier modifier = (MenuModifier)editor.getBean();
                    PizzaModifierExplorer.this.tableModel.addModifier(modifier);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        explorerButtonPanel.getEditButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PizzaModifierExplorer.this.editSelectedRow();
            }
        });
        explorerButtonPanel.getDeleteButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = PizzaModifierExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    index = PizzaModifierExplorer.this.table.convertRowIndexToModel(index);
                    if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 1) {
                        MenuModifier category = (MenuModifier)PizzaModifierExplorer.this.tableModel.getRowData(index);
                        ModifierDAO modifierDAO = new ModifierDAO();
                        modifierDAO.delete(category);
                        PizzaModifierExplorer.this.tableModel.deleteModifier(category, index);
                    }
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton duplicateButton = new JButton("Duplicate");
        duplicateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = PizzaModifierExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("Duplicate"));
                        return;
                    }
                    index = PizzaModifierExplorer.this.table.convertRowIndexToModel(index);
                    MenuModifier existingModifier = (MenuModifier)PizzaModifierExplorer.this.tableModel.getRowData(index);
                    MenuModifier newMenuModifier = new MenuModifier();
                    PropertyUtils.copyProperties((Object)newMenuModifier, (Object)existingModifier);
                    newMenuModifier.setId(null);
                    String newName = PizzaModifierExplorer.this.doDuplicateName(existingModifier);
                    newMenuModifier.setName(newName);
                    newMenuModifier.setPizzaModifier(true);
                    newMenuModifier.setMultiplierPriceList(null);
                    List<PizzaModifierPrice> pizzaModifierPriceList = existingModifier.getPizzaModifierPriceList();
                    if (pizzaModifierPriceList != null) {
                        ArrayList<PizzaModifierPrice> newPriceList = new ArrayList<PizzaModifierPrice>();
                        for (PizzaModifierPrice price : pizzaModifierPriceList) {
                            PizzaModifierPrice newPrice = new PizzaModifierPrice();
                            PropertyUtils.copyProperties((Object)newPrice, (Object)price);
                            newPrice.setId(null);
                            newPriceList.add(newPrice);
                            List<ModifierMultiplierPrice> multiplierPriceList = newPrice.getMultiplierPriceList();
                            if (multiplierPriceList == null) continue;
                            ArrayList<ModifierMultiplierPrice> newMultiplierPriceList = new ArrayList<ModifierMultiplierPrice>();
                            for (ModifierMultiplierPrice multiplierPrice : multiplierPriceList) {
                                ModifierMultiplierPrice newMultiplierPrice = new ModifierMultiplierPrice();
                                PropertyUtils.copyProperties((Object)newMultiplierPrice, (Object)multiplierPrice);
                                newMultiplierPrice.setId(null);
                                newMultiplierPrice.setModifierId(newMenuModifier.getId());
                                newMultiplierPriceList.add(newMultiplierPrice);
                            }
                            newPrice.setMultiplierPriceList(newMultiplierPriceList);
                        }
                        newMenuModifier.setPizzaModifierPriceList(newPriceList);
                    }
                    PizzaModifierForm editor = new PizzaModifierForm(newMenuModifier);
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    MenuModifier menuModifier = (MenuModifier)editor.getBean();
                    PizzaModifierExplorer.this.tableModel.addModifier(menuModifier);
                    PizzaModifierExplorer.this.table.getSelectionModel().addSelectionInterval(PizzaModifierExplorer.this.tableModel.getRowCount() - 1, PizzaModifierExplorer.this.tableModel.getRowCount() - 1);
                    PizzaModifierExplorer.this.table.scrollRowToVisible(PizzaModifierExplorer.this.tableModel.getRowCount() - 1);
                }
                catch (Throwable x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        explorerButtonPanel.add(duplicateButton);
        this.add((Component)explorerButtonPanel, "South");
    }

    private String doDuplicateName(MenuModifier existingModifier) {
        String existingName = existingModifier.getName();
        String newName = new String();
        int lastIndexOf = existingName.lastIndexOf(" ");
        if (lastIndexOf == -1) {
            newName = existingName + " 1";
        } else {
            String processName = existingName.substring(lastIndexOf + 1, existingName.length());
            if (StringUtils.isNumeric((CharSequence)processName)) {
                Integer count = Integer.valueOf(processName);
                count = count + 1;
                newName = existingName.replace(processName, String.valueOf(count));
                System.out.println(newName);
            } else {
                newName = existingName + " 1";
            }
        }
        return newName;
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][]30[][]30[]", "[]20[]"));
        JLabel nameLabel = new JLabel(Messages.getString("ModifierExplorer.3"));
        JLabel groupLabel = new JLabel(Messages.getString("ModifierExplorer.4"));
        this.tfName = new JTextField(15);
        this.tfName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PizzaModifierExplorer.this.updateModifierList();
            }
        });
        List<MenuItemModifierSpec> grpName = MenuItemModifierSpecDAO.getInstance().findAll();
        JComboBox<Object> cbGroup = new JComboBox<Object>();
        cbGroup.addItem(Messages.getString("ModifierExplorer.5"));
        for (MenuItemModifierSpec s : grpName) {
            cbGroup.addItem(s);
        }
        JButton searchBttn = new JButton(Messages.getString("ModifierExplorer.6"));
        panel.add((Component)nameLabel, "align label,split 2");
        panel.add(this.tfName);
        panel.add(searchBttn);
        Border loweredetched = BorderFactory.createEtchedBorder(1);
        TitledBorder title = BorderFactory.createTitledBorder(loweredetched, Messages.getString("ModifierExplorer.8"));
        title.setTitleJustification(1);
        panel.setBorder(title);
        searchBttn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PizzaModifierExplorer.this.updateModifierList();
            }
        });
        return panel;
    }

    public synchronized void updateModifierList() {
        this.setModifierList(ModifierDAO.getInstance().getPizzaModifiers(this.tfName.getText()));
    }

    public void setModifierList(List<MenuModifier> modifierList) {
        this.tableModel.setRows(modifierList);
    }

    private class PizzaModifierExplorerModel
    extends ListTableModel {
        public PizzaModifierExplorerModel() {
            super(new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, "TAX GROUP", POSConstants.MODIFIER_GROUP, POSConstants.BUTTON_COLOR, POSConstants.SORT_ORDER});
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            List modifierList = this.getRows();
            MenuModifier modifier = (MenuModifier)modifierList.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return modifier.getName();
                }
                case 1: {
                    return modifier.getTranslatedName();
                }
                case 2: {
                    if (modifier.getTaxGroup() == null) {
                        return "";
                    }
                    return modifier.getTaxGroup();
                }
                case 3: {
                    return "";
                }
                case 4: {
                    if (modifier.getButtonColor() != null) {
                        return new Color(modifier.getButtonColor());
                    }
                    return null;
                }
                case 5: {
                    return modifier.getSortOrder();
                }
            }
            return null;
        }

        public void addModifier(MenuModifier category) {
            int size = this.getRows().size();
            this.getRows().add(category);
            this.fireTableRowsInserted(size, size);
        }

        public void deleteModifier(MenuModifier category, int index) {
            this.getRows().remove(category);
            this.fireTableRowsDeleted(index, index);
        }
    }
}

