/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PriceRuleForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class PriceRuleExplorer
extends TransparentPanel {
    private JXTable table;
    private BeanTableModel<PriceRule> tableModel = new BeanTableModel(PriceRule.class);

    public PriceRuleExplorer() {
        this.tableModel.addColumn(POSConstants.NAME.toUpperCase(), PriceRule.PROP_NAME);
        this.tableModel.addColumn(POSConstants.DESCRIPTION.toUpperCase(), PriceRule.PROP_DESCRIPTION);
        this.tableModel.addColumn("CODE", PriceRule.PROP_CODE);
        this.tableModel.addColumn("DEPARTMENT", "department");
        this.tableModel.addColumn("SALES AREA", "salesArea");
        this.tableModel.addColumn("ORDER TYPE", "orderType");
        this.tableModel.addColumn("CUSTOMER GROUP", "customerGroup");
        this.tableModel.addColumn("PRICE SHIFT", "priceShift");
        this.tableModel.addColumn("PRICE LIST", "priceTable");
        this.tableModel.addColumn("ENABLE", PriceRule.PROP_ACTIVE);
        this.tableModel.addRows(PriceRuleDAO.getInstance().findAll());
        this.table = new JXTable(this.tableModel);
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    PriceRuleExplorer.this.editSelectedRow(false);
                }
            }
        });
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.addButtonPanel();
    }

    private void addButtonPanel() {
        JButton addButton = new JButton(POSConstants.ADD);
        addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    PriceRuleForm editor = new PriceRuleForm(new PriceRule());
                    BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                    dialog.openWithScale(400, 500);
                    if (dialog.isCanceled()) {
                        return;
                    }
                    PriceRule priceTable = (PriceRule)editor.getBean();
                    PriceRuleExplorer.this.tableModel.addRow(priceTable);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        JButton editButton = new JButton(POSConstants.EDIT);
        editButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PriceRuleExplorer.this.editSelectedRow(false);
            }
        });
        JButton deleteButton = new JButton(POSConstants.DELETE);
        deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    int index = PriceRuleExplorer.this.table.getSelectedRow();
                    if (index < 0) {
                        return;
                    }
                    index = PriceRuleExplorer.this.table.convertRowIndexToModel(index);
                    PriceRule priceTable = (PriceRule)PriceRuleExplorer.this.tableModel.getRow(index);
                    if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                        return;
                    }
                    PriceRuleDAO dao = new PriceRuleDAO();
                    dao.delete(priceTable);
                    PriceRuleExplorer.this.tableModel.removeRow(index);
                }
                catch (Exception x) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
                }
            }
        });
        TransparentPanel panel = new TransparentPanel();
        panel.add(addButton);
        panel.add(editButton);
        panel.add(deleteButton);
        this.add((Component)panel, "South");
    }

    public void editSelectedRow(boolean viewMode) {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            PriceRule priceTable = this.tableModel.getRow(index);
            PriceRuleForm editor = new PriceRuleForm(priceTable);
            BeanEditorDialog dialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
            dialog.openWithScale(400, 500);
            if (dialog.isCanceled()) {
                return;
            }
            this.table.repaint();
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
    }
}

