/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.config.ui.ReceiptConfigurationView;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.basic.BasicTabbedPaneUI;

public class ReceiptConfigurationExplorer
extends JPanel {
    private JTabbedPane mainTab;

    public ReceiptConfigurationExplorer() {
        this.initComponents();
    }

    private void initComponents() {
        this.mainTab = new JTabbedPane();
        this.mainTab.setUI(new BasicTabbedPaneUI());
        this.setLayout(new BorderLayout());
        ReceiptConfigurationView mainReceiptView = new ReceiptConfigurationView();
        this.mainTab.addTab("Main Receipt", mainReceiptView);
        this.mainTab.addTab("Kitchen Receipt", new ReceiptConfigurationView(true));
        this.add(this.mainTab);
        this.mainTab.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                try {
                    JTabbedPane mainTab = (JTabbedPane)evt.getSource();
                    int selectedTabIndex = mainTab.getSelectedIndex();
                    ReceiptConfigurationView view = (ReceiptConfigurationView)mainTab.getComponentAt(selectedTabIndex);
                    ReceiptConfigurationExplorer.this.initializeTab(view);
                }
                catch (Exception e) {
                    POSMessageDialog.showError(ReceiptConfigurationExplorer.this, e.getMessage(), e);
                }
            }
        });
        this.initializeTab(mainReceiptView);
    }

    private void initializeTab(final ReceiptConfigurationView view) {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    view.initialize();
                }
                catch (Exception e) {
                    POSMessageDialog.showError(ReceiptConfigurationExplorer.this, e.getMessage(), e);
                }
            }
        });
        thread.start();
    }
}

