/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.actions.StoreSessionReportAction;
import com.floreantpos.bo.actions.PosProgressDialog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.DrawerAndStaffBankReportHistoryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.PosWebService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class StoreSessionExplorer
extends TransparentPanel {
    private JXTable table;
    private BeanTableModel<StoreSession> tableModel;
    private JButton btnBack;
    private JButton btnForward;
    private JButton btnSync;
    private JLabel lblNumberOfItem;
    private JXDatePicker dpStartDate;
    private JXDatePicker dpEndDate;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");

    public StoreSessionExplorer() {
        this.init();
        this.tableModel.setNumRows(StoreSessionDAO.getInstance().rowCount());
        this.showStoreSession();
    }

    private void init() {
        this.tableModel = new BeanTableModel<StoreSession>(StoreSession.class, 10){

            @Override
            public Object getValueAt(int rowIndex, int columnIndex) {
                if (columnIndex == 0) {
                    return StoreSessionExplorer.this.dateFormat.format(((StoreSession)StoreSessionExplorer.this.tableModel.getRow(rowIndex)).getOpenTime());
                }
                if (columnIndex == 1 && ((StoreSession)StoreSessionExplorer.this.tableModel.getRow(rowIndex)).getCloseTime() != null) {
                    return StoreSessionExplorer.this.dateFormat.format(((StoreSession)StoreSessionExplorer.this.tableModel.getRow(rowIndex)).getCloseTime());
                }
                return super.getValueAt(rowIndex, columnIndex);
            }
        };
        this.tableModel.addColumn("OPEN TIME", "openTime");
        this.tableModel.addColumn("CLOSE TIME", "closeTime");
        this.tableModel.addColumn("OPENED BY", "openedBy");
        this.tableModel.addColumn("CLOSED BY", "closedBy");
        this.btnBack = new JButton("<<< Previous");
        this.btnForward = new JButton("Next >>>");
        this.lblNumberOfItem = new JLabel();
        this.table = new JXTable(this.tableModel);
        this.table.setSortable(false);
        this.table.setDefaultRenderer(Object.class, (TableCellRenderer)new TableRenderer());
        this.table.setRowHeight(PosUIManager.getSize(30));
        this.table.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent me) {
                if (me.getClickCount() == 2) {
                    StoreSessionExplorer.this.showReport();
                }
            }
        });
        this.btnBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreSessionExplorer.this.tableModel.setCurrentRowIndex(StoreSessionExplorer.this.tableModel.getPreviousRowIndex());
                StoreSessionExplorer.this.showStoreSession();
            }
        });
        this.btnForward.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreSessionExplorer.this.tableModel.setCurrentRowIndex(StoreSessionExplorer.this.tableModel.getNextRowIndex());
                StoreSessionExplorer.this.showStoreSession();
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.table));
        this.add((Component)this.createButtonPanel(), "South");
        this.add((Component)this.buildSearchForm(), "North");
        this.resizeColumnWidth((JTable)this.table);
    }

    private JPanel buildSearchForm() {
        JPanel panel = new JPanel();
        panel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
        try {
            JLabel lblFromDate = new JLabel(POSConstants.START_DATE + ":");
            this.dpStartDate = UiUtil.getCurrentMonthStart();
            JLabel lblToDate = new JLabel(POSConstants.END_DATE + ":");
            this.dpEndDate = UiUtil.getCurrentMonthEnd();
            JButton btnRefresh = new JButton();
            btnRefresh.setText(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
            btnRefresh.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    StoreSessionExplorer.this.searchItem();
                }
            });
            panel.add(lblFromDate);
            panel.add((Component)this.dpStartDate);
            panel.add(lblToDate);
            panel.add((Component)this.dpEndDate);
            panel.add(btnRefresh);
        }
        catch (Throwable x) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, x);
        }
        return panel;
    }

    private void showStoreSession() {
        StoreSessionDAO.getInstance().loadStoreSession(this.tableModel);
        int startNumber = this.tableModel.getCurrentRowIndex() + 1;
        int endNumber = this.tableModel.getNextRowIndex();
        int totalNumber = this.tableModel.getNumRows();
        if (endNumber > totalNumber) {
            endNumber = totalNumber;
        }
        this.lblNumberOfItem.setText(String.format("Showing %s to %s of %s", startNumber, endNumber, totalNumber));
        this.btnBack.setEnabled(this.tableModel.hasPrevious());
        this.btnForward.setEnabled(this.tableModel.hasNext());
    }

    private void searchItem() {
        Date toDate;
        if (this.dpStartDate.getDate() == null || this.dpEndDate.getDate() == null) {
            POSMessageDialog.showError(this, "Please enter start and end date!");
            return;
        }
        Date fromDate = DateUtil.startOfDay(this.dpStartDate.getDate());
        if (fromDate.after(toDate = DateUtil.endOfDay(this.dpEndDate.getDate()))) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        List<StoreSession> findSessions = StoreSessionDAO.getInstance().findSessions(fromDate, toDate);
        this.tableModel.removeAll();
        this.tableModel.addRows(findSessions);
    }

    private JPanel createButtonPanel() {
        JPanel bottomPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[33%][33%][33%]"));
        TransparentPanel actionButtonPanel = new TransparentPanel();
        JButton btnHistory = new JButton("History");
        btnHistory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int index = StoreSessionExplorer.this.table.getSelectedRow();
                if (index < 0) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a row first");
                    return;
                }
                index = StoreSessionExplorer.this.table.convertRowIndexToModel(index);
                StoreSession storeSessioin = (StoreSession)StoreSessionExplorer.this.tableModel.getRow(index);
                DrawerAndStaffBankReportHistoryDialog dialog = new DrawerAndStaffBankReportHistoryDialog(POSUtil.getBackOfficeWindow(), Application.getCurrentUser(), storeSessioin);
                dialog.setInfo("Store session history");
                dialog.setSize(PosUIManager.getSize(880, 580));
                dialog.open();
            }
        });
        actionButtonPanel.add((Component)btnHistory, "split 4");
        JButton btnDetails = new JButton("Summary");
        btnDetails.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreSessionExplorer.this.showReport();
            }
        });
        actionButtonPanel.add(btnDetails);
        bottomPanel.add((Component)actionButtonPanel, "skip 1,center");
        this.btnSync = new JButton("Upload");
        this.btnSync.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                StoreSessionExplorer.this.uploadSessionData();
            }
        });
        JPanel navigationPanel = new JPanel(new FlowLayout(4));
        navigationPanel.add(this.lblNumberOfItem);
        navigationPanel.add(this.btnBack);
        navigationPanel.add(this.btnForward);
        bottomPanel.add((Component)navigationPanel, "grow");
        return bottomPanel;
    }

    private void uploadSessionData() {
        int index = this.table.getSelectedRow();
        if (index < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a row first.");
            return;
        }
        PosProgressDialog dialog = new PosProgressDialog(){

            @Override
            public void doBackgroundTask() throws Exception {
                int index = StoreSessionExplorer.this.table.getSelectedRow();
                index = StoreSessionExplorer.this.table.convertRowIndexToModel(index);
                StoreSession storeSessioin = (StoreSession)StoreSessionExplorer.this.tableModel.getRow(index);
                PosWebService.uploadStoreSessionData(storeSessioin);
            }

            @Override
            public void done() {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Upload Complete.");
            }

            @Override
            public void error(Exception e) {
                if (e.getCause().getMessage().contains("Connection refused")) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Connection failed.", e);
                } else {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
                }
            }
        };
        dialog.setProgressLabelText("Uploading");
        dialog.pack();
        dialog.open();
    }

    protected void showReport() {
        try {
            int index = this.table.getSelectedRow();
            if (index < 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a row first");
                return;
            }
            index = this.table.convertRowIndexToModel(index);
            StoreSession storeSessioin = this.tableModel.getRow(index);
            StoreSessionReportAction report = new StoreSessionReportAction(storeSessioin);
            report.execute();
        }
        catch (Exception e) {
            BOMessageDialog.showError(e);
        }
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(200);
        columnWidth.add(200);
        columnWidth.add(70);
        columnWidth.add(70);
        return columnWidth;
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat dateFormat = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");

        TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value instanceof Date) {
                String string = this.dateFormat.format(value);
                label.setText(string);
                label.setHorizontalAlignment(4);
            }
            return label;
        }
    }
}

