/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.modifierdesigner.DefaultModifierTable;
import com.floreantpos.bo.ui.modifierdesigner.ModifierSelectionDialog;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;

public class DefaultModifierSelectionDialog
extends OkCancelOptionDialog
implements ActionListener {
    private List<MenuModifier> modifiers;
    private DefaultModifierTable table;
    private Map<String, DefaultMenuModifier> addedDefaultMenuModifierMap = new HashMap<String, DefaultMenuModifier>();
    private Multiplier defaultMultiplier;

    public DefaultModifierSelectionDialog(List<MenuModifier> modifiers, List<DefaultMenuModifier> defaultModifiers, boolean pizzaModifierGroup) {
        super(POSUtil.getFocusedWindow(), "");
        this.modifiers = modifiers;
        this.init(defaultModifiers);
    }

    private void init(List<DefaultMenuModifier> defaultModifiers) {
        this.setTitle("Select default modifier");
        this.setCaption("Select default modifiers");
        this.defaultMultiplier = MultiplierDAO.getInstance().getDefaultMutltiplier();
        this.table = new DefaultModifierTable(defaultModifiers);
        if (defaultModifiers != null) {
            for (DefaultMenuModifier item : defaultModifiers) {
                this.addedDefaultMenuModifierMap.put(item.getId(), item);
            }
        }
        JPanel contentPane = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        JPanel tablePanel = new JPanel(new BorderLayout());
        tablePanel.setBorder(new EmptyBorder(10, 5, 0, 5));
        JScrollPane scroll = new JScrollPane(this.table);
        scroll.setPreferredSize(PosUIManager.getSize(500, 250));
        tablePanel.add(scroll);
        JButton btnAddModifiers = new JButton("Add Modifiers");
        btnAddModifiers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<MenuModifier> addedModifiers = new ArrayList<MenuModifier>();
                ArrayList addedDefaultModifierList = new ArrayList(DefaultModifierSelectionDialog.this.addedDefaultMenuModifierMap.values());
                for (DefaultMenuModifier defaultModifier : addedDefaultModifierList) {
                    addedModifiers.add(defaultModifier.getModifier());
                }
                ModifierSelectionDialog dialog = new ModifierSelectionDialog(addedModifiers, false);
                dialog.setModifiers(DefaultModifierSelectionDialog.this.modifiers);
                dialog.setSize(600, 500);
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                List<MenuModifier> modifiers = dialog.getSelectedMenuModifierList();
                if (modifiers != null) {
                    ArrayList<DefaultMenuModifier> defaultModifers = new ArrayList<DefaultMenuModifier>();
                    for (MenuModifier menuModifier : modifiers) {
                        DefaultMenuModifier defaultModifier = (DefaultMenuModifier)DefaultModifierSelectionDialog.this.addedDefaultMenuModifierMap.get(menuModifier.getId());
                        if (defaultModifier == null) {
                            defaultModifier = new DefaultMenuModifier();
                            defaultModifier.setModifier(menuModifier);
                            defaultModifier.setMultiplier(DefaultModifierSelectionDialog.this.defaultMultiplier);
                            defaultModifier.setQuantity(1.0);
                        }
                        defaultModifers.add(defaultModifier);
                    }
                    DefaultModifierSelectionDialog.this.addedDefaultMenuModifierMap.clear();
                    for (DefaultMenuModifier defaultMenuModifier : defaultModifers) {
                        DefaultModifierSelectionDialog.this.addedDefaultMenuModifierMap.put(defaultMenuModifier.getId(), defaultMenuModifier);
                    }
                    DefaultModifierSelectionDialog.this.table.setItems(defaultModifers);
                }
            }
        });
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("fillx,ins 5 0 0 0", "", ""));
        paginationButtonPanel.add((Component)btnAddModifiers, "left");
        tablePanel.add((Component)paginationButtonPanel, "South");
        this.resizeColumnWidth(this.table);
        contentPane.add((Component)tablePanel, "grow,span");
        JPanel contentPanel = this.getContentPanel();
        contentPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        contentPanel.add(contentPane);
    }

    @Override
    public void doOk() {
        List<DefaultMenuModifier> menuModifiers = this.getSelectedDefaultMenuModifierList();
        if (menuModifiers == null || menuModifiers.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select modifier");
            return;
        }
        this.setCanceled(false);
        this.dispose();
    }

    @Override
    public void doCancel() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand = e.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(actionCommand)) {
            this.doCancel();
        } else if (POSConstants.OK.equalsIgnoreCase(actionCommand)) {
            this.doOk();
        }
    }

    public List<DefaultMenuModifier> getSelectedDefaultModifierList() {
        return this.getSelectedDefaultMenuModifierList();
    }

    public void resizeColumnWidth(JTable table) {
        TableColumnModel columnModel = table.getColumnModel();
        for (int column = 0; column < table.getColumnCount(); ++column) {
            columnModel.getColumn(column).setPreferredWidth((Integer)this.getColumnWidth().get(column));
        }
    }

    private List getColumnWidth() {
        ArrayList<Integer> columnWidth = new ArrayList<Integer>();
        columnWidth.add(250);
        columnWidth.add(100);
        columnWidth.add(50);
        return columnWidth;
    }

    public List<DefaultMenuModifier> getSelectedDefaultMenuModifierList() {
        return new ArrayList<DefaultMenuModifier>(this.addedDefaultMenuModifierMap.values());
    }

    public void repaintTable() {
        this.table.repaint();
    }
}

