/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.Messages;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.explorer.PageSelectionListener;
import com.floreantpos.bo.ui.modifierdesigner.ModifierActionSelectorDialog;
import com.floreantpos.bo.ui.modifierdesigner.ModifierSelectionDialog;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuModifierForm;
import com.floreantpos.ui.model.PizzaModifierForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ModifierPageDesignView
extends TransparentPanel {
    public static final String VIEW_NAME = "ITEM_VIEW";
    private static final int HORIZONTAL_GAP = 5;
    private static final int VERTICAL_GAP = 5;
    private List<MenuItemModifierPageItem> items;
    private final Dimension buttonSize;
    private MenuItemModifierPage menuItemModifierPage;
    private final JPanel buttonPanelContainer = new JPanel((LayoutManager)new MigLayout("center,wrap 4"));
    private PageSelectionListener pageListener;
    private Integer cols;
    private Integer rows;
    private boolean pizzaItem;
    private MenuItemModifierPageItem dropItem = null;

    public ModifierPageDesignView() {
        this.buttonSize = new Dimension(TerminalConfig.getMenuItemButtonWidth(), TerminalConfig.getMenuItemButtonHeight());
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.buttonPanelContainer);
    }

    public void setPageListener(PageSelectionListener listener) {
        this.pageListener = listener;
    }

    public void setPizzaItem(boolean pizzaItem) {
        this.pizzaItem = pizzaItem;
    }

    public MenuItemModifierPage getMenuPage() {
        return this.menuItemModifierPage;
    }

    public void setMenuItemModifierPage(MenuItemModifierPage page) {
        this.menuItemModifierPage = page;
        this.reset();
        try {
            if (this.menuItemModifierPage == null) {
                return;
            }
            this.cols = this.menuItemModifierPage.getCols();
            if (this.cols <= 0) {
                this.cols = 4;
            }
            this.rows = this.menuItemModifierPage.getRows();
            if (this.rows <= 0) {
                this.rows = 4;
            }
            MigLayout migLayout = new MigLayout("center,wrap " + this.cols);
            if (this.menuItemModifierPage.isFlixibleButtonSize().booleanValue()) {
                migLayout.setLayoutConstraints((Object)"fill");
                migLayout.setColumnConstraints((Object)"fill,grow");
                migLayout.setRowConstraints((Object)"fill,grow");
            }
            this.buttonPanelContainer.setLayout((LayoutManager)migLayout);
            this.items = this.menuItemModifierPage.getPageItems();
            this.renderItems();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    public void setMenuItems(List<MenuItemModifierPageItem> items) {
        this.items = items;
        try {
            this.renderItems();
        }
        catch (Exception e) {
            POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
        }
    }

    protected void renderItems() {
        this.reset();
        if (this.items == null) {
            this.items = new ArrayList<MenuItemModifierPageItem>();
        }
        try {
            String cellKey;
            HashMap<String, ModifierButton> cellItemMap = new HashMap<String, ModifierButton>();
            for (int row = 0; row < this.rows; ++row) {
                for (int col = 0; col < this.cols; ++col) {
                    cellKey = String.valueOf(col) + String.valueOf(row);
                    MenuItemModifierPageItem itemForCell = this.getMenuPageModifierItemForCell(row, col, this.items);
                    ModifierButton modifierButton = (ModifierButton)this.createItemButton(itemForCell);
                    cellItemMap.put(cellKey, modifierButton);
                    String constraint = String.format("cell %s %s", col, row);
                    if (!this.menuItemModifierPage.isFlixibleButtonSize().booleanValue()) {
                        constraint = constraint + String.format(", w %s!, h %s!", this.menuItemModifierPage.getButtonWidth(), this.menuItemModifierPage.getButtonHeight());
                    }
                    this.buttonPanelContainer.add((Component)modifierButton, constraint);
                }
            }
            for (MenuItemModifierPageItem item : this.items) {
                cellKey = String.valueOf(item.getCol()) + String.valueOf(item.getRow());
                ModifierButton itemCellButton = (ModifierButton)cellItemMap.get(cellKey);
                if (itemCellButton == null) continue;
                itemCellButton.setMenuModifier(item.getMenuModifier());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.revalidate();
        this.repaint();
    }

    private MenuItemModifierPageItem getMenuPageModifierItemForCell(int row, int col, List<MenuItemModifierPageItem> modifierPageItems) {
        for (MenuItemModifierPageItem modifierPageItem : modifierPageItems) {
            if (modifierPageItem.getCol() != col || modifierPageItem.getRow() != row) continue;
            return modifierPageItem;
        }
        MenuItemModifierPageItem menuItemModifierPageItem = new MenuItemModifierPageItem(col, row);
        menuItemModifierPageItem.setParentPage(this.menuItemModifierPage);
        return menuItemModifierPageItem;
    }

    public void reset() {
        this.buttonPanelContainer.removeAll();
    }

    public void fillSelectedPageItems(List<MenuItemModifierPageItem> items) {
        int count = 0;
        for (int i = 0; i < this.buttonPanelContainer.getComponents().length; ++i) {
            ModifierButton button = (ModifierButton)this.buttonPanelContainer.getComponent(i);
            if (button.isEmptyItem()) {
                MenuItemModifierPageItem pageItem = items.get(count);
                button.setMenuModifier(pageItem.getMenuModifier());
                this.menuItemModifierPage.addTopageItems(button.getMenuItemModifierPageItem());
                ++count;
            }
            if (count == items.size()) break;
        }
    }

    protected AbstractButton createItemButton(Object item) {
        MenuItemModifierPageItem menuPageItem = (MenuItemModifierPageItem)item;
        ModifierButton modifierButton = new ModifierButton(menuPageItem);
        return modifierButton;
    }

    public class ModifierButton
    extends PosButton
    implements MouseMotionListener,
    MouseListener,
    Transferable {
        MenuItemModifierPageItem menuItemModifierPageItem;
        private DataFlavor dataFlavor = new DataFlavor(MenuItemModifierPageItem.class, "menuItemModifierPageItem");
        private final DataFlavor[] flavors = new DataFlavor[]{this.dataFlavor};
        private DragAndDropTransferHandler dragDropTransferHandler;

        ModifierButton(MenuItemModifierPageItem menuItemModifierPageItem) {
            this.menuItemModifierPageItem = menuItemModifierPageItem;
            this.setFocusable(false);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setIconTextGap(0);
            this.setText("+");
            this.setPreferredSize(ModifierPageDesignView.this.buttonSize);
            this.updateView();
            this.dragDropTransferHandler = new DragAndDropTransferHandler(this);
            this.setTransferHandler(this.dragDropTransferHandler);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        int getRow() {
            return this.menuItemModifierPageItem.getRow();
        }

        int getCol() {
            return this.menuItemModifierPageItem.getCol();
        }

        public void setMenuItemModifierPageItem(MenuItemModifierPageItem item) {
            this.menuItemModifierPageItem = item;
        }

        public MenuItemModifierPageItem getMenuItemModifierPageItem() {
            return this.menuItemModifierPageItem;
        }

        public void setMenuModifier(MenuModifier menuModifier) {
            this.menuItemModifierPageItem.setMenuModifier(menuModifier);
            this.menuItemModifierPageItem.setParentPage(ModifierPageDesignView.this.menuItemModifierPage);
            this.updateView();
        }

        public boolean isEmptyItem() {
            return this.menuItemModifierPageItem.getMenuModifier() == null;
        }

        private void updateView() {
            if (StringUtils.isEmpty((String)this.menuItemModifierPageItem.getMenuModifierId())) {
                this.setText("+");
                return;
            }
            ImageIcon image = this.menuItemModifierPageItem.getImage();
            if (image != null) {
                if (this.menuItemModifierPageItem.isShowImageOnly().booleanValue()) {
                    this.setText("");
                    this.setIcon(image);
                } else {
                    this.setIcon(image);
                    this.setText("<html><body><center>" + this.menuItemModifierPageItem.getMenuModifierName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + this.menuItemModifierPageItem.getMenuModifierName() + "</center></body></html>");
            }
            this.setBackground(this.menuItemModifierPageItem.getButtonColor());
            this.setForeground(this.menuItemModifierPageItem.getTextColor());
        }

        private void doSelectMenuItem() {
            try {
                MenuModifier menuModifier = this.menuItemModifierPageItem.getMenuModifier();
                ArrayList<MenuModifier> existingItems = new ArrayList<MenuModifier>();
                if (menuModifier != null) {
                    existingItems.add(menuModifier);
                }
                if (menuModifier == null) {
                    menuModifier = this.doAddMenuModifier();
                    if (menuModifier == null) {
                        return;
                    }
                } else {
                    ModifierActionSelectorDialog dialog = new ModifierActionSelectorDialog(this.menuItemModifierPageItem);
                    dialog.setSize(PosUIManager.getSize(500, 350));
                    dialog.open();
                    if (dialog.isCanceled()) {
                        return;
                    }
                    String actionCommand = dialog.getActionCommand();
                    if (actionCommand.equals("REPLACE")) {
                        menuModifier = this.doAddMenuModifier();
                        if (menuModifier == null) {
                            return;
                        }
                    } else if (actionCommand.equals("EDIT")) {
                        if (menuModifier.isPizzaModifier().booleanValue()) {
                            PizzaModifierForm editor = new PizzaModifierForm();
                            BeanEditorDialog dialog2 = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                            dialog2.open();
                            if (dialog2.isCanceled()) {
                                return;
                            }
                        } else {
                            MenuModifierDAO.getInstance().initialize(menuModifier);
                            MenuModifierForm editor = new MenuModifierForm(menuModifier);
                            BeanEditorDialog formDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)editor);
                            formDialog.open();
                            if (formDialog.isCanceled()) {
                                return;
                            }
                        }
                    } else if (actionCommand.equals("DETACH")) {
                        MenuItemModifierPage modifierPage = ModifierPageDesignView.this.getMenuPage();
                        List<MenuItemModifierPageItem> pageItems = modifierPage.getPageItems();
                        Iterator<MenuItemModifierPageItem> iterator = pageItems.iterator();
                        while (iterator.hasNext()) {
                            MenuItemModifierPageItem pageItem = iterator.next();
                            if (pageItem.getRow() != this.menuItemModifierPageItem.getRow() || pageItem.getCol() != this.menuItemModifierPageItem.getCol() || pageItem.getId() != this.menuItemModifierPageItem.getId()) continue;
                            iterator.remove();
                            break;
                        }
                        ModifierPageDesignView.this.renderItems();
                        if (ModifierPageDesignView.this.pageListener == null) {
                            return;
                        }
                        ModifierPageDesignView.this.pageListener.itemSelected(null);
                        return;
                    }
                }
                this.menuItemModifierPageItem.setMenuModifier(menuModifier);
                this.menuItemModifierPageItem.setParentPage(ModifierPageDesignView.this.menuItemModifierPage);
                this.updateView();
                if (ModifierPageDesignView.this.pageListener == null) {
                    return;
                }
                ModifierPageDesignView.this.menuItemModifierPage.addTopageItems(this.menuItemModifierPageItem);
                ModifierPageDesignView.this.pageListener.itemSelected(this.menuItemModifierPageItem);
            }
            catch (Exception e) {
                PosLog.error(this.getClass(), e);
            }
        }

        private MenuModifier doAddMenuModifier() {
            MenuItemModifierSpec menuItemModifierSpec = ModifierPageDesignView.this.menuItemModifierPage.getModifierSpec();
            ModifierSelectionDialog dialog = ModifierSelectionDialog.getInstance(new ArrayList<MenuModifier>(), ModifierPageDesignView.this.pizzaItem, true);
            if (menuItemModifierSpec != null) {
                dialog.setSelectedGroup(menuItemModifierSpec.getModifierGroup());
            }
            dialog.setSize(PosUIManager.getSize(600, 500));
            dialog.open();
            if (dialog.isCanceled()) {
                return null;
            }
            return dialog.getSelectedRowData();
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            try {
                ModifierButton modifierButton = (ModifierButton)e.getSource();
                TransferHandler transferHandler = modifierButton.getTransferHandler();
                transferHandler.exportAsDrag(modifierButton, e, 2);
            }
            catch (Exception exp) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exp.getMessage());
            }
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            this.doSelectMenuItem();
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.flavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            for (int i = 0; i < this.flavors.length; ++i) {
                if (!flavor.equals(this.flavors[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (flavor.equals(this.dataFlavor)) {
                return this.menuItemModifierPageItem;
            }
            throw new UnsupportedFlavorException(flavor);
        }
    }

    public class DragAndDropTransferHandler
    extends TransferHandler {
        private ModifierButton modifierButton = null;

        public DragAndDropTransferHandler(ModifierButton modifierButton) {
            this.modifierButton = modifierButton;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent c) {
            return this.modifierButton;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport support) {
            return support.isDataFlavorSupported(this.modifierButton.dataFlavor);
        }

        @Override
        protected void exportDone(JComponent source, Transferable data, int action) {
            super.exportDone(source, data, action);
            try {
                if (source instanceof ModifierButton && ModifierPageDesignView.this.dropItem != null) {
                    this.modifierButton.setMenuItemModifierPageItem(ModifierPageDesignView.this.dropItem);
                    MenuItemModifierPage menuModifierPage = ModifierPageDesignView.this.getMenuPage();
                    List<MenuItemModifierPageItem> pageItems = menuModifierPage.getPageItems();
                    for (MenuItemModifierPageItem menuPageItem : pageItems) {
                        if (menuPageItem == null || !menuPageItem.getRandomId().equals(ModifierPageDesignView.this.dropItem.getRandomId())) continue;
                        menuPageItem.setRow(this.modifierButton.getRow());
                        menuPageItem.setCol(this.modifierButton.getCol());
                        break;
                    }
                    ModifierPageDesignView.this.dropItem = null;
                    this.modifierButton.updateView();
                    ModifierPageDesignView.this.pageListener.uiUpdate();
                    this.modifierButton.getModel().setPressed(false);
                }
            }
            catch (Exception e) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"), e);
                return;
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport support) {
            boolean accept = false;
            if (!this.canImport(support)) {
                return false;
            }
            try {
                Transferable importTransferable = support.getTransferable();
                MenuItemModifierPageItem transferData = (MenuItemModifierPageItem)importTransferable.getTransferData(this.modifierButton.dataFlavor);
                ModifierPageDesignView.this.dropItem = this.modifierButton.menuItemModifierPageItem;
                if (transferData != null) {
                    int sourceRow = transferData.getRow();
                    int sourceCol = transferData.getCol();
                    transferData.setRow(this.modifierButton.getRow());
                    transferData.setCol(this.modifierButton.getCol());
                    this.modifierButton.setMenuItemModifierPageItem(transferData);
                    MenuItemModifierPage menuPage = ModifierPageDesignView.this.getMenuPage();
                    List<MenuItemModifierPageItem> pageItems = menuPage.getPageItems();
                    for (MenuItemModifierPageItem menuPageItem : pageItems) {
                        if (menuPageItem == null || !menuPageItem.getRandomId().equals(transferData.getRandomId())) continue;
                        menuPageItem.setRow(this.modifierButton.getRow());
                        menuPageItem.setCol(this.modifierButton.getCol());
                        break;
                    }
                    ModifierPageDesignView.this.dropItem.setRow(sourceRow);
                    ModifierPageDesignView.this.dropItem.setCol(sourceCol);
                }
                this.modifierButton.updateView();
                ModifierPageDesignView.this.pageListener.uiUpdate();
                accept = true;
            }
            catch (Exception exp) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"));
            }
            return accept;
        }
    }
}

