/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.modifierdesigner;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.PageSelectionListener;
import com.floreantpos.bo.ui.modifierdesigner.DefaultModifierSelectionDialog;
import com.floreantpos.bo.ui.modifierdesigner.ModifierPageDesignView;
import com.floreantpos.bo.ui.modifierdesigner.ModifierPageForm;
import com.floreantpos.model.DefaultMenuModifier;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.swing.PaginatedListModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class ModifierPageDesigner
extends TransparentPanel
implements PageSelectionListener {
    private ModifierPageDesignView itemView;
    private MenuItemModifierSpec menuItemModifierSpec;
    private ModifierGroup selectedGroup;
    private MenuItemModifierPage selectedModifierSpecPage;
    private JButton btnEditPage;
    private MenuItem menuItem;
    private PosButton btnNext;
    private PosButton btnPrev;
    private PaginatedListModel dataModel = new PaginatedListModel(1);
    private PosButton btnPageNum;

    public ModifierPageDesigner(MenuItem menuItem) {
        this.menuItem = menuItem;
        this.initComponents();
    }

    public void setMenuItemModifierSpec(MenuItemModifierSpec menuItemModifierSpec) {
        this.menuItemModifierSpec = menuItemModifierSpec;
        if (menuItemModifierSpec.getModifierPages() == null) {
            menuItemModifierSpec.setModifierPages(new HashSet<MenuItemModifierPage>());
        }
        this.dataModel.setCurrentRowIndex(0);
        this.initDataModel();
        this.setDataModel(this.dataModel);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(5, 0));
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.itemView = new ModifierPageDesignView();
        this.itemView.setPageListener(this);
        if (this.menuItem != null) {
            this.itemView.setPizzaItem(this.menuItem.isPizzaType());
        }
        JPanel southItemActionPanel = new JPanel((LayoutManager)new MigLayout("center,fillx", "[33%][33%][33%]", ""));
        JButton btnDefaultModifiers = new JButton("Default Modifiers");
        btnDefaultModifiers.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (ModifierPageDesigner.this.menuItemModifierSpec == null) {
                    return;
                }
                ArrayList<MenuModifier> items = new ArrayList<MenuModifier>(ModifierPageDesigner.this.menuItemModifierSpec.getModifiers());
                if (items == null || items.isEmpty()) {
                    return;
                }
                List<DefaultMenuModifier> defaultModifierLIst = ModifierPageDesigner.this.menuItemModifierSpec.getDefaultModifierList();
                DefaultModifierSelectionDialog dialog = new DefaultModifierSelectionDialog(items, defaultModifierLIst, (boolean)ModifierPageDesigner.this.menuItem.isPizzaType());
                dialog.setSize(600, 500);
                dialog.open();
                if (dialog.isCanceled()) {
                    return;
                }
                ModifierPageDesigner.this.menuItemModifierSpec.setDefaultModifierList(dialog.getSelectedDefaultModifierList());
            }
        });
        JButton btnDetachedAll = new JButton("Detach All");
        btnDetachedAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageDesigner.this.doDetachAllItems();
            }
        });
        JButton btnAutoBuild = new JButton("Auto Build");
        btnAutoBuild.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageDesigner.this.doGenenateMenuItemModifierPageItems();
            }
        });
        this.btnEditPage = new JButton("Edit page");
        this.btnEditPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageDesigner.this.editPage();
            }
        });
        southItemActionPanel.add((Component)new JLabel(""), "grow");
        southItemActionPanel.add((Component)btnDefaultModifiers, "split 5");
        southItemActionPanel.add(this.btnEditPage);
        southItemActionPanel.add(btnAutoBuild);
        southItemActionPanel.add(btnDetachedAll);
        JPanel paginationButtonPanel = new JPanel((LayoutManager)new MigLayout("ins 0,hidemode 3", "", ""));
        Dimension btnSize = new Dimension(20, 20);
        this.btnPrev = new PosButton();
        this.btnPrev.setIcon(IconFactory.getIcon("/ui_icons/", "previous.png", btnSize));
        paginationButtonPanel.add((Component)this.btnPrev, "split 3,w 40!, h 35!");
        this.btnPageNum = new PosButton();
        this.btnPageNum.setBorder(null);
        this.btnPageNum.setOpaque(false);
        this.btnPageNum.setContentAreaFilled(false);
        this.btnPageNum.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ModifierPageDesigner.this.editPage();
            }
        });
        paginationButtonPanel.add((Component)this.btnPageNum, "h 35!");
        this.btnPageNum.setVisible(false);
        this.btnNext = new PosButton();
        this.btnNext.setIcon(IconFactory.getIcon("/ui_icons/", "next.png", btnSize));
        paginationButtonPanel.add((Component)this.btnNext, "w 40!,h 35!");
        southItemActionPanel.add((Component)paginationButtonPanel, "right");
        this.add((Component)southItemActionPanel, "South");
        ActionListener action = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Object source = e.getSource();
                    if (source == ModifierPageDesigner.this.btnPrev) {
                        ModifierPageDesigner.this.scrollUp();
                    } else if (source == ModifierPageDesigner.this.btnNext) {
                        ModifierPageDesigner.this.scrollDown();
                    }
                }
                catch (Exception e2) {
                    POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), e2.getMessage(), e2);
                }
            }
        };
        this.btnPrev.addActionListener(action);
        this.btnNext.addActionListener(action);
        this.btnNext.setEnabled(false);
        this.btnPrev.setEnabled(false);
        TitledBorder border = new TitledBorder(POSConstants.MODIFIERS);
        border.setTitleJustification(2);
        this.itemView.setBorder(new CompoundBorder(border, null));
        contentPanel.add(this.itemView);
        this.add(contentPanel);
    }

    private void rendererSelectedGroup() {
        if (this.selectedGroup != null) {
            MenuItemModifierSpec modifierSpec = this.selectedModifierSpecPage.getModifierSpec();
            if (modifierSpec == null) {
                modifierSpec = new MenuItemModifierSpec();
                modifierSpec.setModifierGroup(this.selectedGroup);
                this.selectedModifierSpecPage.setModifierSpec(modifierSpec);
            }
            this.itemView.setMenuItemModifierPage(this.selectedModifierSpecPage);
        }
    }

    private void doDetachAllItems() {
        if (this.selectedModifierSpecPage == null || this.selectedModifierSpecPage.getPageItems() == null) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No item to detach.");
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Are you sure you want to detach all?", "Confirm") != 0) {
            return;
        }
        if (this.selectedModifierSpecPage.getPageItems() != null) {
            this.selectedModifierSpecPage.getPageItems().clear();
        }
        this.itemView.setMenuItemModifierPage(this.selectedModifierSpecPage);
    }

    public void doGenenateMenuItemModifierPageItems() {
        if (this.selectedGroup == null) {
            return;
        }
        List<MenuModifier> items = this.selectedGroup.getModifiers();
        if (items == null || items.isEmpty()) {
            return;
        }
        try {
            if (this.selectedModifierSpecPage == null) {
                this.doCreateNewPage();
            }
            int pageItemCount = this.selectedModifierSpecPage.getRows() * this.selectedModifierSpecPage.getCols();
            int itemSize = items.size();
            ArrayList<MenuItemModifierPageItem> pageItems = new ArrayList<MenuItemModifierPageItem>();
            if (items.size() > 0) {
                int count = 1;
                for (MenuModifier modifier : items) {
                    MenuItemModifierPageItem pageItem = new MenuItemModifierPageItem();
                    pageItem.setMenuModifier(modifier);
                    pageItem.setParentPage(this.selectedModifierSpecPage);
                    pageItems.add(pageItem);
                    if (count == pageItemCount || itemSize == count) {
                        this.itemView.fillSelectedPageItems(pageItems);
                        if (itemSize == count) break;
                        this.doCreateNewPage();
                        pageItems = new ArrayList();
                        itemSize -= count;
                        count = 1;
                        this.setDataModel(this.dataModel);
                        this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
                        continue;
                    }
                    ++count;
                }
                this.setDataModel(this.dataModel);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BOMessageDialog.showError(ex.getMessage());
        }
    }

    private void doCreateNewPage() {
        this.selectedModifierSpecPage = new MenuItemModifierPage();
        this.selectedModifierSpecPage.setName("Page " + (this.menuItemModifierSpec.getModifierPages().size() + 1));
        this.selectedModifierSpecPage.setButtonHeight(100);
        this.selectedModifierSpecPage.setButtonWidth(100);
        this.selectedModifierSpecPage.setRows(4);
        this.selectedModifierSpecPage.setCols(4);
        this.selectedModifierSpecPage.setVisible(true);
        this.selectedModifierSpecPage.setSortOrder(this.menuItemModifierSpec.getModifierPages().size() + 1);
        this.selectedModifierSpecPage.setFlixibleButtonSize(false);
        this.selectedModifierSpecPage.setModifierSpecId(this.menuItemModifierSpec.getId());
        this.menuItemModifierSpec.addTomodifierPages(this.selectedModifierSpecPage);
        this.dataModel.getDataList().add(this.selectedModifierSpecPage);
        this.dataModel.setNumRows(this.menuItemModifierSpec.getModifierPages().size());
    }

    private void setDataModel(PaginatedListModel dataModel) {
        this.rendererSelectedGroup();
        this.btnNext.setEnabled(true);
        this.btnPrev.setEnabled(dataModel.hasPrevious());
        this.btnPageNum.setText(this.selectedModifierSpecPage.getName());
        this.btnPageNum.setVisible(StringUtils.isNotEmpty((String)this.selectedModifierSpecPage.getName()));
    }

    private void initDataModel() {
        this.selectedGroup = this.menuItemModifierSpec.getModifierGroup();
        Set<MenuItemModifierPage> modifierPages = this.menuItemModifierSpec.getModifierPages();
        if (modifierPages == null) {
            modifierPages = new HashSet<MenuItemModifierPage>();
        }
        ArrayList<MenuItemModifierPage> pages = new ArrayList<MenuItemModifierPage>();
        for (MenuItemModifierPage page : modifierPages) {
            pages.add(page);
        }
        Collections.sort(pages, new Comparator<MenuItemModifierPage>(){

            @Override
            public int compare(MenuItemModifierPage o1, MenuItemModifierPage o2) {
                return o1.getSortOrder() - o2.getSortOrder();
            }
        });
        this.dataModel.setNumRows(pages.size());
        this.dataModel.setData(pages);
        if (this.dataModel.getSize() > 0) {
            this.selectedModifierSpecPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
        } else {
            this.doCreateNewPage();
        }
    }

    private void scrollDown() {
        if (this.dataModel.getNextRowIndex() >= this.dataModel.getSize()) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to create new page?", "Confirm") != 0) {
                return;
            }
            this.doCreateNewPage();
            this.itemSelected(this.selectedModifierSpecPage);
            this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
            this.setDataModel(this.dataModel);
        } else {
            this.dataModel.setCurrentRowIndex(this.dataModel.getNextRowIndex());
            this.selectedModifierSpecPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
            this.setDataModel(this.dataModel);
        }
    }

    private void scrollUp() {
        this.dataModel.setCurrentRowIndex(this.dataModel.getPreviousRowIndex());
        this.selectedModifierSpecPage = (MenuItemModifierPage)this.dataModel.getElementAt(this.dataModel.getCurrentRowIndex());
        this.setDataModel(this.dataModel);
    }

    public MenuItemModifierSpec getMenuItemModifierSpec() {
        return this.menuItemModifierSpec;
    }

    public void reset() {
        this.itemView.reset();
        this.itemView.revalidate();
        this.itemView.repaint();
    }

    public void editPage() {
        if (this.selectedModifierSpecPage == null) {
            POSMessageDialog.showMessage(this, "Please select modifier group first.");
            return;
        }
        ModifierPageForm form = new ModifierPageForm(this.selectedModifierSpecPage);
        BeanEditorDialog dialog = new BeanEditorDialog(form);
        dialog.open();
        if (dialog.isCanceled()) {
            return;
        }
        this.rendererSelectedGroup();
    }

    @Override
    public void itemSelected(Object item) {
    }

    @Override
    public void uiUpdate() {
    }
}

