/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.extension.MercuryGatewayPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class CardConfigurationView
extends ConfigurationView {
    private JComboBox cbGateway;
    private DoubleTextField tfBarTabLimit = new DoubleTextField(10);
    private DoubleTextField tfAdvanceTipsPercentage = new DoubleTextField(10);
    private JPanel pluginConfigPanel = new JPanel(new BorderLayout());
    private JCheckBox chkPreAuthBarTab;

    public CardConfigurationView() {
        this.createUI();
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", ""));
        JLabel lblMerchantGateway = new JLabel(Messages.getString("CardConfigurationView.2"));
        contentPanel.add((Component)lblMerchantGateway, "cell 0 4,alignx leading");
        this.cbGateway = new JComboBox();
        this.cbGateway.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    CardConfigurationView.this.updatePluginConfigUI();
                }
                catch (Exception e1) {
                    POSMessageDialog.showError(CardConfigurationView.this, e1.getMessage(), e1);
                }
            }
        });
        this.chkPreAuthBarTab = new JCheckBox();
        this.chkPreAuthBarTab.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBox chkbox = (JCheckBox)e.getSource();
                CardConfigurationView.this.tfBarTabLimit.setEnabled(chkbox.isSelected());
            }
        });
        contentPanel.add((Component)this.cbGateway, "cell 1 4,growx");
        contentPanel.add((Component)this.pluginConfigPanel, "newline,span,wrap,growx");
        contentPanel.add((Component)new JLabel("Preauthorization of bar tab"), "cell 0 6");
        contentPanel.add((Component)this.chkPreAuthBarTab, "cell 1 6");
        contentPanel.add((Component)new JLabel(Messages.getString("CardConfigurationView.1")), "cell 0 7");
        contentPanel.add((Component)this.tfBarTabLimit, "cell 1 7");
        contentPanel.add((Component)new JLabel(Messages.getString("CardConfigurationView.4")), "cell 0 8");
        contentPanel.add((Component)this.tfAdvanceTipsPercentage, "cell 1 8");
        contentPanel.add((Component)new JLabel(Messages.getString("CardConfigurationView.10")), "cell 1 8");
        JSeparator separator = new JSeparator(0);
        contentPanel.add((Component)separator, "newline, growx, span 10, wrap");
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }

    private void initialMerchantGateways() {
        DefaultComboBoxModel<PaymentGatewayPlugin> model = new DefaultComboBoxModel<PaymentGatewayPlugin>();
        List<FloreantPlugin> plugins = ExtensionManager.getPlugins(PaymentGatewayPlugin.class);
        for (FloreantPlugin plugin : plugins) {
            if (plugin instanceof MercuryGatewayPlugin) continue;
            model.addElement((PaymentGatewayPlugin)plugin);
        }
        this.cbGateway.setModel(model);
        this.cbGateway.setSelectedItem(CardConfig.getPaymentGateway());
    }

    @Override
    public boolean save() throws Exception {
        PaymentGatewayPlugin plugin = (PaymentGatewayPlugin)this.cbGateway.getSelectedItem();
        if (!plugin.getConfigurationPane().save()) {
            return false;
        }
        CardConfig.setPaymentGateway(plugin);
        CardConfig.setPreAuthBartab(this.chkPreAuthBarTab.isSelected());
        CardConfig.setBartabLimit(this.tfBarTabLimit.getDouble());
        CardConfig.setAdvanceTipsPercentage(this.tfAdvanceTipsPercentage.getDouble());
        return true;
    }

    @Override
    public void initialize() throws Exception {
        this.initialMerchantGateways();
        this.chkPreAuthBarTab.setSelected(CardConfig.isPreAuthBartab());
        this.tfBarTabLimit.setEnabled(this.chkPreAuthBarTab.isSelected());
        this.tfBarTabLimit.setText(String.valueOf(CardConfig.getBartabLimit()));
        this.tfAdvanceTipsPercentage.setText(String.valueOf(CardConfig.getAdvanceTipsPercentage()));
        this.updatePluginConfigUI();
        this.setInitialized(true);
    }

    private void updatePluginConfigUI() throws Exception {
        PaymentGatewayPlugin plugin = (PaymentGatewayPlugin)this.cbGateway.getSelectedItem();
        this.pluginConfigPanel.removeAll();
        if (plugin == null) {
            return;
        }
        ConfigurationView configurationPane = plugin.getConfigurationPane();
        configurationPane.initialize();
        this.pluginConfigPanel.add(configurationPane);
        this.revalidate();
        this.repaint();
    }

    @Override
    public String getName() {
        return Messages.getString("CardConfigurationView.6");
    }
}

