/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.mailservices.MailService;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class EmailConfigurationView
extends ConfigurationView {
    private JTextField tfSMTP = new JTextField(25);
    private IntegerTextField tfSMTPPort = new IntegerTextField(8);
    private JTextField tfSenderEmail = new JTextField(25);
    private JPasswordField tfPassword = new JPasswordField(25);
    private static String encryptedPassword;
    private Terminal terminal;

    public EmailConfigurationView(Terminal terminal) {
        this.terminal = terminal;
        this.initializeComponents();
    }

    private void initializeComponents() {
        this.setLayout(new BorderLayout());
        JLabel lblSMTP_Host = new JLabel(Messages.getString("TerminalConfigurationView.26"));
        JLabel lblSMTP_Port = new JLabel(Messages.getString("EmailConfigurationView.0"));
        JLabel lblSender = new JLabel(Messages.getString("TerminalConfigurationView.28"));
        JLabel lblPassword = new JLabel(Messages.getString("TerminalConfigurationView.48"));
        JPanel emailSetupJPanel = new JPanel((LayoutManager)new MigLayout("wrap 2", "[][grow]", ""));
        emailSetupJPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("TerminalConfigurationView.44")));
        emailSetupJPanel.add(lblSMTP_Host);
        emailSetupJPanel.add(this.tfSMTP);
        emailSetupJPanel.add(lblSMTP_Port);
        emailSetupJPanel.add(this.tfSMTPPort);
        emailSetupJPanel.add(lblSender);
        emailSetupJPanel.add(this.tfSenderEmail);
        emailSetupJPanel.add(lblPassword);
        emailSetupJPanel.add(this.tfPassword);
        JButton btnEmailTest = new JButton(Messages.getString("EmailConfigurationView.4"));
        btnEmailTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EmailConfigurationView.this.doSendTestEmail();
            }
        });
        emailSetupJPanel.add((Component)btnEmailTest, "skip 1");
        JScrollPane scrollPane = new JScrollPane(emailSetupJPanel, 20, 31);
        scrollPane.setBorder(null);
        this.add((Component)scrollPane, "Center");
    }

    private void doSendTestEmail() {
        try {
            String smtpHost = this.tfSMTP.getText();
            Integer smtpPort = this.tfSMTPPort.getInteger();
            String senderEmail = this.tfSenderEmail.getText();
            String password = new String(this.tfPassword.getPassword());
            MailService.sendMail(smtpHost.trim(), smtpPort, senderEmail.trim(), password.trim(), senderEmail.trim(), Messages.getString("EmailConfigurationView.6"), Messages.getString("EmailConfigurationView.7"), null, null);
            POSMessageDialog.showMessage(this, Messages.getString("EmailConfigurationView.8"));
        }
        catch (Exception e2) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("EmailConfigurationView.9"), e2);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            TerminalDAO termDAO = new TerminalDAO();
            termDAO.saveOrUpdate(this.terminal);
            return true;
        }
        catch (Exception e) {
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    public void updateView() {
        try {
            if (this.terminal == null) {
                return;
            }
            String smtpHost = this.terminal.getSmtpHost();
            Integer smtpPort = this.terminal.getSmtpPort();
            this.tfSMTP.setText(StringUtils.isEmpty((String)smtpHost) ? Messages.getString("EmailConfigurationView.10") : smtpHost);
            this.tfSMTPPort.setText(String.valueOf(smtpPort == 0 ? 465 : smtpPort));
            this.tfSenderEmail.setText(this.terminal.getSmtpSender());
            encryptedPassword = this.terminal.getSmtpPassword();
            if (encryptedPassword != null) {
                this.tfPassword.setText(AESencrp.decrypt(encryptedPassword));
            }
            this.setInitialized(true);
        }
        catch (Exception e) {
            PosLog.error(EmailConfigurationView.class, e);
        }
    }

    public boolean updateModel() {
        try {
            Terminal term = this.terminal;
            term.setSmtpHost(this.tfSMTP.getText());
            term.setSmtpPort(this.tfSMTPPort.getInteger());
            term.setSmtpSender(this.tfSenderEmail.getText());
            term.setSmtpPassword(AESencrp.encrypt(new String(this.tfPassword.getPassword())));
            return true;
        }
        catch (Exception e) {
            PosLog.error(EmailConfigurationView.class, e);
            return false;
        }
    }

    @Override
    public void initialize() throws Exception {
        this.updateView();
    }

    @Override
    public String getName() {
        return POSConstants.CONFIG_TAB_EMAIL;
    }
}

