/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.Store;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class LabelConfigurationView
extends TransparentPanel {
    private Store store;
    private JCheckBox chkBarcode;
    private JCheckBox chkMemberPrice;
    private JCheckBox chkRetailPrice;
    private JComboBox<PriceTable> cbPriceTable;
    private JLabel lblPriceTable;
    private PosButton btnSave;

    public LabelConfigurationView() {
        this.createUI();
        this.initData();
        this.updateView();
        this.initHandler();
    }

    private void initData() {
        ArrayList<PriceTable> priceTableList = new ArrayList<PriceTable>();
        priceTableList.add(null);
        priceTableList.addAll(PriceTableDAO.getInstance().findAll());
        this.cbPriceTable.setModel(new ComboBoxModel(priceTableList));
    }

    private void initHandler() {
        this.chkRetailPrice.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                JCheckBox chkBox = (JCheckBox)e.getSource();
                LabelConfigurationView.this.cbPriceTable.setVisible(chkBox.isSelected());
                LabelConfigurationView.this.lblPriceTable.setVisible(chkBox.isSelected());
            }
        });
        this.btnSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LabelConfigurationView.this.save();
            }
        });
    }

    private void createUI() {
        this.setLayout(new BorderLayout());
        JPanel itemInfoPanel = new JPanel((LayoutManager)new MigLayout("hidemode 3", "[][grow][]", ""));
        JScrollPane scrollPane = new JScrollPane(itemInfoPanel, 20, 31);
        TitledBorder border = BorderFactory.createTitledBorder(null, "Label Configuration", 2, 0);
        itemInfoPanel.setBorder(border);
        this.chkBarcode = new JCheckBox("Print barcode");
        this.chkMemberPrice = new JCheckBox("Print member price");
        this.chkRetailPrice = new JCheckBox("Print retail price");
        this.cbPriceTable = new JComboBox();
        this.lblPriceTable = new JLabel("Select retail price: ");
        itemInfoPanel.add((Component)this.chkBarcode, "wrap");
        itemInfoPanel.add((Component)this.chkMemberPrice, "wrap");
        itemInfoPanel.add((Component)this.chkRetailPrice, "wrap");
        itemInfoPanel.add((Component)this.lblPriceTable, "gapleft 20");
        itemInfoPanel.add(this.cbPriceTable, "w 100!");
        this.cbPriceTable.setVisible(false);
        this.lblPriceTable.setVisible(false);
        scrollPane.setBorder(null);
        JPanel buttonPanel = new JPanel((LayoutManager)new MigLayout("center"));
        this.btnSave = new PosButton("Save");
        buttonPanel.add(this.btnSave);
        this.add((Component)scrollPane, "Center");
        this.add((Component)buttonPanel, "South");
    }

    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            StoreDAO.getInstance().saveOrUpdate(this.store);
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Label configuration successfully updated.");
            return true;
        }
        catch (Exception e) {
            PosLog.error(LabelConfigurationView.class, e.getMessage(), e);
            POSMessageDialog.showError(e.getMessage());
            return false;
        }
    }

    public void updateView() {
        try {
            this.store = Application.getInstance().getStore();
            boolean isPrintBarcode = this.store.getProperty("label.barcode") == null ? true : Boolean.valueOf(this.store.getProperty("label.barcode"));
            boolean isPrintMemberPrice = this.store.getProperty("label.member.price") == null ? true : Boolean.valueOf(this.store.getProperty("label.member.price"));
            boolean isPrintRetailPrice = this.store.getProperty("label.isPrint.retail.price") == null ? true : Boolean.valueOf(this.store.getProperty("label.isPrint.retail.price"));
            String retailPriceId = this.store.getProperty("label.retail.price");
            this.chkBarcode.setSelected(isPrintBarcode);
            this.chkMemberPrice.setSelected(isPrintMemberPrice);
            this.chkRetailPrice.setSelected(isPrintRetailPrice);
            this.lblPriceTable.setVisible(isPrintRetailPrice);
            this.cbPriceTable.setVisible(isPrintRetailPrice);
            if (StringUtils.isNotEmpty((String)retailPriceId)) {
                PriceTable priceTable = PriceTableDAO.getInstance().get(retailPriceId);
                this.cbPriceTable.setSelectedItem(priceTable);
            }
        }
        catch (Exception e) {
            PosLog.error(LabelConfigurationView.class, e);
        }
    }

    public boolean updateModel() {
        try {
            boolean isPrintBarcode = this.chkBarcode.isSelected();
            boolean isPrintMemberPrice = this.chkMemberPrice.isSelected();
            boolean isPrintRetailPrice = this.chkRetailPrice.isSelected();
            PriceTable priceTable = (PriceTable)this.cbPriceTable.getSelectedItem();
            this.store.addProperty("label.barcode", String.valueOf(isPrintBarcode));
            this.store.addProperty("label.member.price", String.valueOf(isPrintMemberPrice));
            this.store.addProperty("label.isPrint.retail.price", String.valueOf(isPrintRetailPrice));
            this.store.addProperty("label.retail.price", priceTable.getId());
        }
        catch (Exception e) {
            PosLog.error(LabelConfigurationView.class, e.getMessage(), e);
        }
        return true;
    }

    @Override
    public String getName() {
        return "Label";
    }
}

