/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.config.ui;

import com.floreantpos.Messages;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.ConfigurationSubEditor;
import com.floreantpos.config.ui.ConfigurationView;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.SerialPortUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;

public class PeripheralConfigurationView
extends ConfigurationView {
    public static final String CONFIG_TAB_PERIPHERAL = Messages.getString("PeripheralConfigurationView.0");
    private JCheckBox chkHasCashDrawer;
    private JTextField tfDrawerName = new JTextField(10);
    private JTextField tfDrawerCodes = new JTextField(15);
    private DoubleTextField tfDrawerInitialBalance = new DoubleTextField(6);
    private JCheckBox cbCustomerDisplay;
    private JTextField tfCustomerDisplayPort;
    private JTextField tfCustomerDisplayMessage;
    private JCheckBox cbScaleActive;
    private JTextField tfScalePort;
    private FixedLengthTextField tfScaleDisplayMessage;
    private List<ConfigurationSubEditor> subEditors = new ArrayList<ConfigurationSubEditor>();

    public PeripheralConfigurationView() {
        this.initComponents();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[grow]", "[][]"));
        JPanel drawerConfigPanel = new JPanel((LayoutManager)new MigLayout());
        drawerConfigPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PeripheralConfigurationView.4")));
        this.chkHasCashDrawer = new JCheckBox(Messages.getString("TerminalConfigurationView.15"));
        drawerConfigPanel.add((Component)this.chkHasCashDrawer, "span 5, wrap");
        drawerConfigPanel.add(new JLabel(Messages.getString("TerminalConfigurationView.25")));
        drawerConfigPanel.add((Component)this.tfDrawerName, "");
        drawerConfigPanel.add((Component)new JLabel(Messages.getString("TerminalConfigurationView.27")), "newline");
        drawerConfigPanel.add((Component)this.tfDrawerCodes, Messages.getString("TerminalConfigurationView.29"));
        JButton btnDrawerTest = new JButton(Messages.getString("TerminalConfigurationView.11"));
        btnDrawerTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = PeripheralConfigurationView.this.tfDrawerCodes.getText();
                if (StringUtils.isEmpty((String)text)) {
                    text = TerminalConfig.getDefaultDrawerControlCodes();
                }
                String[] split = text.split(",");
                char[] codes = new char[split.length];
                for (int i = 0; i < split.length; ++i) {
                    try {
                        codes[i] = (char)Integer.parseInt(split[i]);
                        continue;
                    }
                    catch (Exception x) {
                        codes[i] = 48;
                    }
                }
                DrawerUtil.kickDrawer(PeripheralConfigurationView.this.tfDrawerName.getText(), codes);
            }
        });
        drawerConfigPanel.add(btnDrawerTest);
        JButton btnRestoreDrawerDefault = new JButton(Messages.getString("TerminalConfigurationView.32"));
        btnRestoreDrawerDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeripheralConfigurationView.this.tfDrawerName.setText("COM1");
                PeripheralConfigurationView.this.tfDrawerCodes.setText(TerminalConfig.getDefaultDrawerControlCodes());
            }
        });
        drawerConfigPanel.add(btnRestoreDrawerDefault);
        contentPanel.add((Component)drawerConfigPanel, "span 3, grow, wrap");
        this.chkHasCashDrawer.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeripheralConfigurationView.this.doEnableDisableDrawerPull();
            }
        });
        JPanel customerDisplayPanel = new JPanel((LayoutManager)new MigLayout());
        customerDisplayPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PeripheralConfigurationView.5")));
        this.cbCustomerDisplay = new JCheckBox(Messages.getString("PeripheralConfigurationView.6"));
        this.tfCustomerDisplayPort = new JTextField(20);
        this.tfCustomerDisplayMessage = new FixedLengthTextField(20);
        JButton btnTest = new JButton(Messages.getString("PeripheralConfigurationView.7"));
        btnTest.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DrawerUtil.setCustomerDisplayMessage(PeripheralConfigurationView.this.tfCustomerDisplayPort.getText(), String.format("%200s", ""));
                DrawerUtil.setCustomerDisplayMessage(PeripheralConfigurationView.this.tfCustomerDisplayPort.getText(), PeripheralConfigurationView.this.tfCustomerDisplayMessage.getText());
            }
        });
        JButton btnRestoreCustomerDefault = new JButton(Messages.getString("TerminalConfigurationView.32"));
        btnRestoreCustomerDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeripheralConfigurationView.this.tfCustomerDisplayPort.setText(Messages.getString("PeripheralConfigurationView.8"));
                PeripheralConfigurationView.this.tfCustomerDisplayMessage.setText(Messages.getString("PeripheralConfigurationView.9"));
            }
        });
        customerDisplayPanel.add((Component)this.cbCustomerDisplay, "wrap");
        customerDisplayPanel.add(new JLabel(Messages.getString("PeripheralConfigurationView.11")));
        customerDisplayPanel.add((Component)this.tfCustomerDisplayPort, "wrap");
        customerDisplayPanel.add(new JLabel(Messages.getString("PeripheralConfigurationView.13")));
        customerDisplayPanel.add(this.tfCustomerDisplayMessage);
        customerDisplayPanel.add(btnTest);
        customerDisplayPanel.add(btnRestoreCustomerDefault);
        contentPanel.add((Component)customerDisplayPanel, "grow,wrap");
        JPanel scaleDisplayPanel = new JPanel((LayoutManager)new MigLayout());
        scaleDisplayPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PeripheralConfigurationView.15")));
        this.cbScaleActive = new JCheckBox(Messages.getString("PeripheralConfigurationView.16"));
        this.tfScalePort = new JTextField(20);
        this.tfScaleDisplayMessage = new FixedLengthTextField(20);
        JButton btnTestScale = new JButton(Messages.getString("PeripheralConfigurationView.17"));
        btnTestScale.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeripheralConfigurationView.this.testScaleMachine();
            }
        });
        JButton btnRestoreScaleDefault = new JButton(Messages.getString("TerminalConfigurationView.32"));
        btnRestoreScaleDefault.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeripheralConfigurationView.this.tfScalePort.setText(Messages.getString("PeripheralConfigurationView.18"));
            }
        });
        scaleDisplayPanel.add((Component)this.cbScaleActive, "wrap");
        scaleDisplayPanel.add(new JLabel(Messages.getString("PeripheralConfigurationView.20")));
        scaleDisplayPanel.add(this.tfScalePort);
        scaleDisplayPanel.add(btnTestScale);
        scaleDisplayPanel.add(btnRestoreScaleDefault);
        if (TerminalConfig.getScaleActivationValue().equals("cas10")) {
            contentPanel.add((Component)scaleDisplayPanel, "grow,wrap");
        }
        for (FloreantPlugin plugin : ExtensionManager.getPlugins()) {
            List<ConfigurationSubEditor> subEditorComponents = plugin.getSubEditors();
            if (subEditorComponents == null) continue;
            this.subEditors.addAll(subEditorComponents);
            for (ConfigurationSubEditor subEditor : subEditorComponents) {
                contentPanel.add((Component)subEditor, "grow,wrap");
            }
        }
        JScrollPane scrollPane = new JScrollPane(contentPanel);
        scrollPane.setBorder(null);
        this.add(scrollPane);
    }

    protected void doEnableDisableDrawerPull() {
        boolean selected = this.chkHasCashDrawer.isSelected();
        this.tfDrawerName.setEnabled(selected);
        this.tfDrawerCodes.setEnabled(selected);
        this.tfDrawerInitialBalance.setEnabled(selected);
    }

    @Override
    public boolean save() throws Exception {
        TerminalConfig.setDrawerPortName(this.tfDrawerName.getText());
        String drawerControlCodes = this.tfDrawerCodes.getText();
        if (StringUtils.isNotEmpty((String)drawerControlCodes)) {
            drawerControlCodes = drawerControlCodes.replaceAll(",", "_");
        }
        TerminalConfig.setDrawerControlCodes(drawerControlCodes);
        TerminalConfig.setCustomerDisplay(this.cbCustomerDisplay.isSelected());
        TerminalConfig.setCustomerDisplayPort(this.tfCustomerDisplayPort.getText());
        TerminalConfig.setCustomerDisplayMessage(this.tfCustomerDisplayMessage.getText());
        TerminalConfig.setScaleDisplay(this.cbScaleActive.isSelected());
        TerminalConfig.setScalePort(this.tfScalePort.getText());
        TerminalConfig.setScaleDisplayMessage(this.tfScaleDisplayMessage.getText());
        TerminalDAO terminalDAO = TerminalDAO.getInstance();
        Terminal terminal = terminalDAO.get(TerminalConfig.getTerminalId());
        if (terminal == null) {
            terminal = new Terminal();
            terminal.setId(TerminalConfig.getTerminalId());
            terminal.setName(String.valueOf(TerminalConfig.getTerminalId()));
        }
        terminal.setHasCashDrawer(this.chkHasCashDrawer.isSelected());
        terminalDAO.saveOrUpdate(terminal);
        if (this.subEditors != null) {
            for (ConfigurationSubEditor subEditor : this.subEditors) {
                subEditor.save();
            }
        }
        return true;
    }

    @Override
    public void initialize() throws Exception {
        Terminal terminal = Application.getInstance().refreshAndGetTerminal();
        this.chkHasCashDrawer.setSelected(terminal.isHasCashDrawer());
        this.tfDrawerName.setText(TerminalConfig.getDrawerPortName());
        String drawerControlCodes = TerminalConfig.getDrawerControlCodes();
        if (StringUtils.isNotEmpty((String)drawerControlCodes)) {
            drawerControlCodes = drawerControlCodes.replaceAll("_", ",");
        }
        this.tfDrawerCodes.setText(drawerControlCodes);
        this.cbCustomerDisplay.setSelected(TerminalConfig.isActiveCustomerDisplay());
        this.tfCustomerDisplayPort.setText(TerminalConfig.getCustomerDisplayPort());
        this.tfCustomerDisplayMessage.setText(TerminalConfig.getCustomerDisplayMessage());
        this.cbScaleActive.setSelected(TerminalConfig.isActiveScaleDisplay());
        this.tfScalePort.setText(TerminalConfig.getScalePort());
        this.tfScaleDisplayMessage.setText(TerminalConfig.getScaleDisplayMessage());
        this.doEnableDisableDrawerPull();
        if (this.subEditors != null) {
            for (ConfigurationSubEditor subEditor : this.subEditors) {
                subEditor.initialize();
            }
        }
        this.setInitialized(true);
    }

    private void testScaleMachine() {
        try {
            String string = SerialPortUtil.readWeight(this.tfScalePort.getText());
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string);
        }
        catch (Exception ex) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), ex.getMessage());
            LogFactory.getLog(PeripheralConfigurationView.class).error((Object)ex);
        }
    }

    @Override
    public String getName() {
        return CONFIG_TAB_PERIPHERAL;
    }
}

