/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customer;

import com.floreantpos.Messages;
import com.floreantpos.config.AppProperties;
import com.floreantpos.customer.CustomerSelector;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Frame;
import java.awt.HeadlessException;
import javax.swing.JFrame;

public class CustomerSelectorDialog
extends POSDialog {
    private final CustomerSelector customerSelector;

    public CustomerSelectorDialog(CustomerSelector customerSelector) throws HeadlessException {
        super((Frame)POSUtil.getBackOfficeWindow(), true);
        this.customerSelector = customerSelector;
        this.init(POSUtil.getBackOfficeWindow());
    }

    public CustomerSelectorDialog(JFrame parent, CustomerSelector customerSelector) throws HeadlessException {
        super((Frame)parent, true);
        this.customerSelector = customerSelector;
        this.init(parent);
    }

    private void init(JFrame parent) {
        this.setTitle(AppProperties.getAppName());
        TitlePanel titlePane = new TitlePanel();
        titlePane.setTitle(Messages.getString("CustomerSelectorDialog.0"));
        this.getContentPane().add((Component)titlePane, "North");
        this.getContentPane().add(this.customerSelector);
        if (parent == null) {
            parent = Application.getPosWindow();
        }
        this.setSize(parent.getSize());
        this.setLocationRelativeTo(parent);
    }

    public void setCreateNewTicket(boolean createNewTicket) {
        this.customerSelector.setCreateNewTicket(createNewTicket);
    }

    public void updateView(boolean update) {
        this.customerSelector.updateView(update);
    }

    public Customer getSelectedCustomer() {
        return this.customerSelector.getSelectedCustomer();
    }

    public void setTicket(Ticket thisTicket) {
        this.customerSelector.setTicket(thisTicket);
    }

    public void setCustomer(Customer customer) {
        this.customerSelector.setCustomer(customer);
    }

    public void setCallerId(String callerId) {
        this.customerSelector.setCallerId(callerId);
    }

    public void setVisibleOnlySelectionButtons(boolean b) {
        this.customerSelector.setVisibleOnlySelectionButtons(b);
        this.customerSelector.updateView(true);
    }
}

