/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.db.update;

import com.floreantpos.PosLog;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemTax;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.POSUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.resource.ClassLoaderResourceAccessor;
import liquibase.resource.ResourceAccessor;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.jdbc.Work;

public class UpdateDBTo101 {
    private long INCREMENT = 1000L;
    private SessionFactory sessionFactory;
    private String dbConnectString;
    private String user;
    private String password;

    public UpdateDBTo101(String dbConnectString, String user, String password, SessionFactory sf) {
        this.dbConnectString = dbConnectString;
        this.user = user;
        this.password = password;
        this.sessionFactory = sf;
    }

    public void update() throws Exception {
        this.executeLiquibaseUpdate();
        this.executeUpdateSql();
        this.updateMenuPageItems();
        this.updateTicketItem();
        this.updateTicketItemModifier();
        this.updateTicket();
    }

    private void updateMenuPageItems() {
        List<MenuCategory> categories = MenuCategoryDAO.getInstance().findAll();
        for (MenuCategory menuCategory : categories) {
            List<MenuGroup> menuGroups = MenuGroupDAO.getInstance().findByParent(menuCategory);
            for (MenuGroup menuGroup : menuGroups) {
                menuGroup.setMenuCategory(menuCategory);
                MenuGroupDAO.getInstance().update(menuGroup);
            }
        }
    }

    private void executeLiquibaseUpdate() throws SQLException, DatabaseException, LiquibaseException {
        Connection connection = DriverManager.getConnection(this.dbConnectString, this.user, this.password);
        Database database = DatabaseFactory.getInstance().findCorrectDatabaseImplementation((DatabaseConnection)new JdbcConnection(connection));
        Liquibase liquibase = new Liquibase("db-changelog.xml", (ResourceAccessor)new ClassLoaderResourceAccessor(), database);
        liquibase.update(new Contexts(), new LabelExpression());
    }

    private void executeUpdateSql() {
        String[] sql = new String[]{"update menu_page_item set menu_item_name=(select m.name from menu_item as m where m.id=menu_item_id)", "update menu_page_item set btn_color=(select m.btn_color from menu_item as m where m.id=menu_item_id)", "update menu_page_item set TEXT_COLOR=(select m.TEXT_COLOR from menu_item as m where m.id=menu_item_id)", "update menu_page_item set IMAGE_ID=(select m.IMAGE_ID from menu_item as m where m.id=menu_item_id)", "update menu_page_item set SHOW_IMAGE_ONLY=(select m.SHOW_IMAGE_ONLY from menu_item as m where m.id=menu_item_id)", "UPDATE ticket SET owner_type_id=(select n_user_type from users where users.id=ticket.owner_id)"};
        Session session = this.sessionFactory.openSession();
        Transaction transaction = session.beginTransaction();
        for (int i = 0; i < sql.length; ++i) {
            try {
                session.createSQLQuery(sql[i]).executeUpdate();
                continue;
            }
            catch (Exception e) {
                PosLog.error(DatabaseUtil.class, e);
            }
        }
        transaction.commit();
        session.close();
    }

    private void updateTicketItem() {
        this.sessionFactory.openSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DatabaseMetaData metaData = connection.getMetaData();
                if (UpdateDBTo101.this.hasTable(metaData, "ticket_item_tax")) {
                    UpdateDBTo101.this.doConvertTicketItemTaxToProperties();
                }
                if (UpdateDBTo101.this.hasTable(metaData, "ticket_item_discount")) {
                    UpdateDBTo101.this.doConvertTicketItemDiscountToProperties();
                }
                if (UpdateDBTo101.this.hasTable(metaData, "ticket_item_cooking_instruction")) {
                    UpdateDBTo101.this.doConvertTicketItemCookingInstructionToProperties();
                }
            }
        });
    }

    private void updateTicketItemModifier() {
        this.sessionFactory.openSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DatabaseMetaData metaData = connection.getMetaData();
                if (UpdateDBTo101.this.hasTable(metaData, "ticket_item_tax")) {
                    UpdateDBTo101.this.doConvertTicketItemModifierTaxToProperties();
                }
            }
        });
    }

    private void updateTicket() {
        this.sessionFactory.openSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DatabaseMetaData metaData = connection.getMetaData();
                if (UpdateDBTo101.this.hasTable(metaData, "ticket_discount")) {
                    UpdateDBTo101.this.doConvertTicketDiscountToProperties();
                }
                if (UpdateDBTo101.this.hasTable(metaData, "ticket_table_num")) {
                    UpdateDBTo101.this.doCopyTicketTableNumbersToStringProperty();
                }
            }
        });
    }

    private void doConvertTicketItemTaxToProperties() {
        long count = this.getRowCount("ticket_item_tax");
        if (count == 0L) {
            return;
        }
        long startIndex = 0L;
        do {
            TerminalDAO dao;
            List list;
            if ((list = (dao = TerminalDAO.getInstance()).executeSqlQuery("select id,name,rate,tax_amount,ticket_itemid from ticket_item_tax", startIndex, this.INCREMENT)) == null || list.size() <= 0) {
                return;
            }
            HashMap<String, ArrayList<TicketItemTax>> ticketItemMap = new HashMap<String, ArrayList<TicketItemTax>>();
            for (Object[] object : list) {
                String ticketItemId;
                int index = 0;
                TicketItemTax ticketItemTax = new TicketItemTax();
                ticketItemTax.setId(String.valueOf(object[index++]));
                ticketItemTax.setName(String.valueOf(object[index++]));
                ticketItemTax.setRate(POSUtil.parseDouble("" + object[index++]));
                ticketItemTax.setTaxAmount(POSUtil.parseDouble("" + object[index++]));
                if (StringUtils.isEmpty((String)(ticketItemId = String.valueOf(object[index++])))) continue;
                ArrayList<TicketItemTax> ticketItemTaxList = (ArrayList<TicketItemTax>)ticketItemMap.get(ticketItemId);
                if (ticketItemTaxList == null) {
                    ticketItemTaxList = new ArrayList<TicketItemTax>();
                    ticketItemMap.put(ticketItemId, ticketItemTaxList);
                }
                ticketItemTaxList.add(ticketItemTax);
            }
            ArrayList<String> deleteSqlList = new ArrayList<String>();
            ArrayList<String> insertSqlList = new ArrayList<String>();
            for (String ticketItemId : ticketItemMap.keySet()) {
                List ticketItemTaxes = (List)ticketItemMap.get(ticketItemId);
                TicketItem tmpTicketItem = new TicketItem(ticketItemId);
                tmpTicketItem.setTaxes(ticketItemTaxes);
                tmpTicketItem.buildTaxes();
                String propertyValue = tmpTicketItem.getTaxesProperty();
                String updateSql = "Update ticket_item set taxes_property='" + propertyValue + "' where id='" + ticketItemId + "'";
                insertSqlList.add(updateSql);
                PosLog.debug(UpdateDBTo101.class, updateSql);
            }
            dao.executeSqlQuery(deleteSqlList);
            dao.executeSqlQuery(insertSqlList);
            startIndex += this.INCREMENT;
        } while ((count -= this.INCREMENT) > 0L);
    }

    private long getRowCount(String tableName) {
        PosLog.debug(UpdateDBTo101.class, "Searching table data from " + tableName);
        TerminalDAO dao = TerminalDAO.getInstance();
        List list2 = dao.executeSqlQuery("select count(*) from " + tableName);
        long count = 0L;
        if (list2 != null && list2.size() > 0) {
            count = ((Number)list2.get(0)).longValue();
        }
        PosLog.debug(UpdateDBTo101.class, "Found row count " + count + " from " + tableName);
        return count;
    }

    private void doConvertTicketItemDiscountToProperties() {
        long count = this.getRowCount("ticket_item_discount");
        if (count == 0L) {
            return;
        }
        long startIndex = 0L;
        do {
            String sql;
            TerminalDAO dao;
            List list;
            if ((list = (dao = TerminalDAO.getInstance()).executeSqlQuery(sql = "select id,discount_id,name,type,auto_apply,coupon_quanity,minimum_amount,value,amount,ticket_itemid from ticket_item_discount", startIndex, this.INCREMENT)) == null || list.size() <= 0) {
                return;
            }
            HashMap<String, ArrayList<TicketItemDiscount>> ticketItemMap = new HashMap<String, ArrayList<TicketItemDiscount>>();
            for (Object[] object : list) {
                if (StringUtils.isEmpty((String)String.valueOf(object[5]))) continue;
                int index = 0;
                TicketItemDiscount ticketItemDiscount = new TicketItemDiscount();
                ticketItemDiscount.setId(String.valueOf(object[index++]));
                ticketItemDiscount.setDiscountId(String.valueOf(object[index++]));
                ticketItemDiscount.setName(String.valueOf(object[index++]));
                ticketItemDiscount.setType(POSUtil.parseInteger("" + object[index++]));
                ticketItemDiscount.setAutoApply(Boolean.valueOf("" + object[index++]));
                ticketItemDiscount.setCouponQuantity(POSUtil.parseDouble("" + object[index++]));
                ticketItemDiscount.setMinimumAmount(POSUtil.parseDouble("" + object[index++]));
                ticketItemDiscount.setValue(POSUtil.parseDouble("" + object[index++]));
                ticketItemDiscount.setAmount(POSUtil.parseDouble("" + object[index++]));
                ticketItemDiscount.setTicketItemId(String.valueOf(object[index++]));
                ArrayList<TicketItemDiscount> ticketItemDiscountList = (ArrayList<TicketItemDiscount>)ticketItemMap.get(ticketItemDiscount.getTicketItemId());
                if (ticketItemDiscountList == null) {
                    ticketItemDiscountList = new ArrayList<TicketItemDiscount>();
                    ticketItemMap.put(ticketItemDiscount.getTicketItemId(), ticketItemDiscountList);
                }
                ticketItemDiscountList.add(ticketItemDiscount);
            }
            ArrayList<String> updateSqlList = new ArrayList<String>();
            for (String ticketItemId : ticketItemMap.keySet()) {
                List ticketItemDiscounts = (List)ticketItemMap.get(ticketItemId);
                TicketItem tmpTicketItem = new TicketItem();
                tmpTicketItem.setId(ticketItemId);
                tmpTicketItem.setDiscounts(ticketItemDiscounts);
                tmpTicketItem.buildDiscounts();
                String propertyValue = tmpTicketItem.getDiscountsProperty();
                String updateSql = "Update ticket_item set discounts_property='" + propertyValue + "' where id='" + ticketItemId + "'";
                updateSqlList.add(updateSql);
                PosLog.debug(UpdateDBTo101.class, updateSql);
            }
            dao.executeSqlQuery(updateSqlList);
            startIndex += this.INCREMENT;
        } while ((count -= this.INCREMENT) > 0L);
    }

    private void doConvertTicketItemCookingInstructionToProperties() {
        long count = this.getRowCount("ticket_item_cooking_instruction");
        if (count == 0L) {
            return;
        }
        long startIndex = 0L;
        do {
            TerminalDAO dao = TerminalDAO.getInstance();
            String sql = "select description,printedtokitchen,ticket_item_id,saved from ticket_item_cooking_instruction";
            List list = null;
            try {
                list = dao.executeSqlQuery(sql, startIndex, this.INCREMENT);
            }
            catch (Exception e) {
                sql = "select description,printedtokitchen,ticket_item_id from ticket_item_cooking_instruction";
                list = dao.executeSqlQuery(sql, startIndex, this.INCREMENT);
            }
            if (list == null || list.size() <= 0) {
                return;
            }
            HashMap<String, ArrayList<TicketItemCookingInstruction>> ticketItemMap = new HashMap<String, ArrayList<TicketItemCookingInstruction>>();
            for (Object[] object : list) {
                TicketItemCookingInstruction ticketItemCookingInstruction = new TicketItemCookingInstruction();
                int index = 0;
                ticketItemCookingInstruction.setDescription(String.valueOf(object[index++]));
                ticketItemCookingInstruction.setPrintedToKitchen(Boolean.valueOf("" + object[index++]));
                ticketItemCookingInstruction.setTicketItemId(String.valueOf(object[index++]));
                try {
                    ticketItemCookingInstruction.setSaved(Boolean.valueOf("" + object[index++]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (StringUtils.isEmpty((String)ticketItemCookingInstruction.getTicketItemId())) continue;
                ArrayList<TicketItemCookingInstruction> ticketItemCookingInstructionList = (ArrayList<TicketItemCookingInstruction>)ticketItemMap.get(ticketItemCookingInstruction.getTicketItemId());
                if (ticketItemCookingInstructionList == null) {
                    ticketItemCookingInstructionList = new ArrayList<TicketItemCookingInstruction>();
                    ticketItemMap.put(ticketItemCookingInstruction.getTicketItemId(), ticketItemCookingInstructionList);
                }
                ticketItemCookingInstructionList.add(ticketItemCookingInstruction);
            }
            ArrayList<String> updateSqlList = new ArrayList<String>();
            for (String ticketItemId : ticketItemMap.keySet()) {
                List ticketItemCookingInstructiones = (List)ticketItemMap.get(ticketItemId);
                TicketItem tmpTicketItem = new TicketItem();
                tmpTicketItem.setId(ticketItemId);
                tmpTicketItem.setCookingInstructions(ticketItemCookingInstructiones);
                tmpTicketItem.buildCoookingInstructions();
                String propertyValue = tmpTicketItem.getCookingInstructionsProperty();
                String updateSql = "Update ticket_item set cooking_instructions_property='" + propertyValue + "' where id='" + ticketItemId + "'";
                updateSqlList.add(updateSql);
                PosLog.debug(UpdateDBTo101.class, updateSql);
            }
            dao.executeSqlQuery(updateSqlList);
            startIndex += this.INCREMENT;
        } while ((count -= this.INCREMENT) > 0L);
    }

    private void doCopyTicketTableNumbersToStringProperty() {
        long count = this.getRowCount("ticket_table_num");
        if (count == 0L) {
            return;
        }
        long startIndex = 0L;
        do {
            String sql;
            TerminalDAO dao;
            List list;
            if ((list = (dao = TerminalDAO.getInstance()).executeSqlQuery(sql = "select table_id,ticket_id from ticket_table_num", startIndex, this.INCREMENT)) == null || list.size() <= 0) {
                return;
            }
            HashMap<String, ArrayList<Integer>> ticketMap = new HashMap<String, ArrayList<Integer>>();
            for (Object[] object : list) {
                String ticketId;
                ArrayList<Integer> tableNumberList;
                int index = 0;
                Integer tableNumber = POSUtil.parseInteger("" + object[index++]);
                if ((tableNumberList = (ArrayList<Integer>)ticketMap.get(ticketId = String.valueOf(object[index++]))) == null) {
                    tableNumberList = new ArrayList<Integer>();
                    ticketMap.put(ticketId, tableNumberList);
                }
                tableNumberList.add(tableNumber);
            }
            ArrayList<String> updateSqlList = new ArrayList<String>();
            for (String ticketId : ticketMap.keySet()) {
                String ticketTableNumbers = "";
                List tableNumbers = (List)ticketMap.get(ticketId);
                if (tableNumbers != null && tableNumbers.size() > 0) {
                    Iterator iterator = tableNumbers.iterator();
                    while (iterator.hasNext()) {
                        Integer tableNo = (Integer)iterator.next();
                        ticketTableNumbers = ticketTableNumbers + tableNo;
                        if (!iterator.hasNext()) continue;
                        ticketTableNumbers = ticketTableNumbers + ",";
                    }
                }
                String updateSql = "Update ticket set table_num='" + ticketTableNumbers + "' where id='" + ticketId + "'";
                updateSqlList.add(updateSql);
                PosLog.debug(UpdateDBTo101.class, updateSql);
            }
            dao.executeSqlQuery(updateSqlList);
            startIndex += this.INCREMENT;
        } while ((count -= this.INCREMENT) > 0L);
    }

    private void doConvertTicketDiscountToProperties() {
        long count = this.getRowCount("ticket_discount");
        if (count == 0L) {
            return;
        }
        long startIndex = 0L;
        do {
            String sql;
            TerminalDAO dao;
            List list;
            if ((list = (dao = TerminalDAO.getInstance()).executeSqlQuery(sql = "select id,discount_id,name,type,auto_apply,coupon_quanity,minimum_tamount,value,total_amount,ticket_id from ticket_discount", startIndex, this.INCREMENT)) == null || list.size() <= 0) {
                return;
            }
            HashMap<String, ArrayList<TicketDiscount>> ticketMap = new HashMap<String, ArrayList<TicketDiscount>>();
            for (Object[] object : list) {
                if (StringUtils.isEmpty((String)String.valueOf(object[5]))) continue;
                int index = 0;
                TicketDiscount ticketDiscount = new TicketDiscount();
                ticketDiscount.setId(String.valueOf(object[index++]));
                ticketDiscount.setDiscountId(String.valueOf(object[index++]));
                ticketDiscount.setName(String.valueOf(object[index++]));
                ticketDiscount.setType(POSUtil.parseInteger("" + object[index++]));
                ticketDiscount.setAutoApply(Boolean.valueOf("" + object[index++]));
                ticketDiscount.setCouponQuantity(POSUtil.parseDouble("" + object[index++]));
                ticketDiscount.setMinimumAmount(POSUtil.parseDouble("" + object[index++]));
                ticketDiscount.setValue(POSUtil.parseDouble("" + object[index++]));
                ticketDiscount.setTotalDiscountAmount(POSUtil.parseDouble("" + object[index++]));
                ticketDiscount.setTicketId(String.valueOf(object[index++]));
                ArrayList<TicketDiscount> ticketDiscountList = (ArrayList<TicketDiscount>)ticketMap.get(ticketDiscount.getTicketId());
                if (ticketDiscountList == null) {
                    ticketDiscountList = new ArrayList<TicketDiscount>();
                    ticketMap.put(ticketDiscount.getTicketId(), ticketDiscountList);
                }
                ticketDiscountList.add(ticketDiscount);
            }
            ArrayList<String> updateSqlList = new ArrayList<String>();
            for (String ticketId : ticketMap.keySet()) {
                List ticketDiscounts = (List)ticketMap.get(ticketId);
                Ticket tmpTicket = new Ticket(ticketId);
                tmpTicket.setDiscounts(ticketDiscounts);
                tmpTicket.buildDiscounts();
                String propertyValue = tmpTicket.getDiscountsProperty();
                String updateSql = "Update ticket set discounts_property='" + propertyValue + "' where id='" + ticketId + "'";
                updateSqlList.add(updateSql);
                PosLog.debug(UpdateDBTo101.class, updateSql);
            }
            dao.executeSqlQuery(updateSqlList);
            startIndex += this.INCREMENT;
        } while ((count -= this.INCREMENT) > 0L);
    }

    private void doConvertTicketItemModifierTaxToProperties() {
        long count = this.getRowCount("ticket_item_tax");
        if (count == 0L) {
            return;
        }
        long startIndex = 0L;
        do {
            TerminalDAO dao;
            List list;
            if ((list = (dao = TerminalDAO.getInstance()).executeSqlQuery("select id,name,rate,tax_amount,ticket_item_modifier_id from ticket_item_tax", startIndex, this.INCREMENT)) == null || list.size() <= 0) {
                return;
            }
            HashMap<String, ArrayList<TicketItemTax>> ticketItemMap = new HashMap<String, ArrayList<TicketItemTax>>();
            for (Object[] object : list) {
                String ticketItemModifierId;
                int index = 0;
                TicketItemTax ticketItemTax = new TicketItemTax();
                ticketItemTax.setId(String.valueOf(object[index++]));
                ticketItemTax.setName(String.valueOf(object[index++]));
                ticketItemTax.setRate(POSUtil.parseDouble("" + object[index++]));
                ticketItemTax.setTaxAmount(POSUtil.parseDouble("" + object[index++]));
                if (StringUtils.isEmpty((String)(ticketItemModifierId = String.valueOf(object[index++])))) continue;
                ArrayList<TicketItemTax> ticketItemTaxList = (ArrayList<TicketItemTax>)ticketItemMap.get(ticketItemModifierId);
                if (ticketItemTaxList == null) {
                    ticketItemTaxList = new ArrayList<TicketItemTax>();
                    ticketItemMap.put(ticketItemModifierId, ticketItemTaxList);
                }
                ticketItemTaxList.add(ticketItemTax);
            }
            ArrayList<String> updateSqlList = new ArrayList<String>();
            for (String ticketItemModifierId : ticketItemMap.keySet()) {
                List ticketItemTaxes = (List)ticketItemMap.get(ticketItemModifierId);
                TicketItem tmpTicketItem = new TicketItem(ticketItemModifierId);
                tmpTicketItem.setTaxes(ticketItemTaxes);
                tmpTicketItem.buildTaxes();
                String propertyValue = tmpTicketItem.getTaxesProperty();
                String updateSql = "Update ticket_item_modifier set taxes_property='" + propertyValue + "' where id='" + ticketItemModifierId + "'";
                updateSqlList.add(updateSql);
                PosLog.debug(UpdateDBTo101.class, updateSql);
            }
            dao.executeSqlQuery(updateSqlList);
            startIndex += this.INCREMENT;
        } while ((count -= this.INCREMENT) > 0L);
    }

    private boolean hasTable(DatabaseMetaData metaData, String tableName) throws SQLException {
        ResultSet resultSet = metaData.getTables(null, null, null, new String[]{"TABLE"});
        ArrayList<String> tableNameList = new ArrayList<String>();
        while (resultSet.next()) {
            String tableName2 = resultSet.getString("TABLE_NAME");
            tableNameList.add(tableName2.toLowerCase());
        }
        return tableNameList.contains(tableName.toLowerCase());
    }
}

