/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.db.update;

import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Projections;

public class UpdateDBTo104 {
    public void update() throws Exception {
        TicketDAO dao = TicketDAO.getInstance();
        Session session = null;
        Transaction transaction = null;
        try {
            session = dao.createNewSession();
            transaction = session.beginTransaction();
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.setProjection(Projections.rowCount());
            Object result = criteria.uniqueResult();
            int numTickets = 0;
            if (result instanceof Number) {
                numTickets = ((Number)result).intValue();
            }
            int increment = 1000;
            criteria.setProjection(null);
            for (int count = 0; count < numTickets; count += 1000) {
                criteria.setFirstResult(count);
                criteria.setMaxResults(1000);
                List list = criteria.list();
                for (Ticket ticket : list) {
                    ticket.calculatePrice();
                    session.update((Object)ticket);
                }
            }
            transaction.commit();
        }
        catch (Exception e) {
            transaction.rollback();
            throw e;
        }
        finally {
            dao.closeSession(session);
        }
    }
}

