/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.db.update;

import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.ext.CardTypeEnum;
import java.util.Date;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.query.Query;

public class UpdateDBTo129 {
    public void update() throws Exception {
        this.doSetStoreSessionInTicketAndTransaction();
    }

    private void doSetStoreSessionInTicketAndTransaction() throws Exception {
        StoreSessionDAO dao = StoreSessionDAO.getInstance();
        List<StoreSession> storeSessions = dao.findAll();
        Session session = null;
        Transaction tx = null;
        try {
            session = dao.createNewSession();
            tx = session.beginTransaction();
            for (StoreSession storeSession : storeSessions) {
                if (storeSession.getCloseTime() == null) continue;
                this.doUpdateTicket(session, storeSession);
                this.doUpdateTransactions(session, storeSession);
            }
            for (StoreSession storeSession : storeSessions) {
                if (storeSession.getCloseTime() != null) continue;
                this.doUpdateTicket(session, storeSession);
                this.doUpdateTransactions(session, storeSession);
            }
            this.doUpdateTransactionsPaymentType(session);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw e;
        }
        finally {
            dao.closeSession(session);
        }
    }

    private void doUpdateTicket(Session session, StoreSession storeSession) {
        String hql = "update Ticket set " + Ticket.PROP_STORE_SESSION_ID + "= :storeSession where " + Ticket.PROP_CREATE_DATE + " between :sessionOpenTime and :sessionCloseTime and " + Ticket.PROP_STORE_SESSION_ID + " is null";
        Query query = session.createQuery(hql);
        query.setParameter("storeSession", (Object)storeSession.getId());
        query.setParameter("sessionOpenTime", (Object)storeSession.getOpenTime());
        query.setParameter("sessionCloseTime", (Object)(storeSession.getCloseTime() != null ? storeSession.getCloseTime() : new Date()));
        query.executeUpdate();
    }

    private void doUpdateTransactions(Session session, StoreSession storeSession) {
        String hql = "update PosTransaction set " + PosTransaction.PROP_STORE_SESSION_ID + "= :storeSession where " + PosTransaction.PROP_TRANSACTION_TIME + " between :sessionOpenTime and :sessionCloseTime and " + PosTransaction.PROP_STORE_SESSION_ID + " is null";
        Query query = session.createQuery(hql);
        query.setParameter("storeSession", (Object)storeSession.getId());
        query.setParameter("sessionOpenTime", (Object)storeSession.getOpenTime());
        query.setParameter("sessionCloseTime", (Object)(storeSession.getCloseTime() != null ? storeSession.getCloseTime() : new Date()));
        query.executeUpdate();
    }

    private void doUpdateTransactionsPaymentType(Session session) {
        String hql = "update CustomerAccountTransaction set " + PosTransaction.PROP_PAYMENT_TYPE_STRING + "= :paymentType where " + PosTransaction.PROP_PAYMENT_TYPE_STRING + "='CUSTOMER_ACCOUNT' or " + PosTransaction.PROP_PAYMENT_TYPE_STRING + "='CUSTOMER ACCOUNT' or " + PosTransaction.PROP_PAYMENT_TYPE_STRING + "='MEMBER ACCOUNT'";
        Query query = session.createQuery(hql);
        query.setParameter("paymentType", (Object)PaymentType.MEMBER_ACCOUNT.name());
        query.executeUpdate();
        this.updateCreditCardTypeField(session, "VISA", CardTypeEnum.VISA.name());
        this.updateCreditCardTypeField(session, "MASTER CARD", CardTypeEnum.MASTER_CARD.name());
        this.updateCreditCardTypeField(session, "MASTERCARD", CardTypeEnum.MASTER_CARD.name());
        this.updateCreditCardTypeField(session, "AMEX", CardTypeEnum.AMERICAN_EXPRESS.name());
        this.updateCreditCardTypeField(session, "DISCOVER", CardTypeEnum.DISCOVER.name());
        this.updateDebitCardTypeField(session, "VISA", CardTypeEnum.VISA.name());
        this.updateDebitCardTypeField(session, "MASTER CARD", CardTypeEnum.MASTER_CARD.name());
    }

    private void updateCreditCardTypeField(Session session, String oldCardType, String newCardType) {
        String hql = "update CreditCardTransaction set " + PosTransaction.PROP_CARD_TYPE + "= :newCardType where " + PosTransaction.PROP_PAYMENT_TYPE_STRING + "= :oldCardType";
        Query query = session.createQuery(hql);
        query.setParameter("newCardType", (Object)newCardType);
        query.setParameter("oldCardType", (Object)oldCardType);
        query.executeUpdate();
        hql = "update CreditCardTransaction set " + PosTransaction.PROP_CARD_TYPE + "= :newCardType where " + PosTransaction.PROP_CARD_TYPE + "= :oldCardType";
        query = session.createQuery(hql);
        query.setParameter("newCardType", (Object)newCardType);
        query.setParameter("oldCardType", (Object)oldCardType);
        query.executeUpdate();
        hql = "update CreditCardTransaction set " + PosTransaction.PROP_PAYMENT_TYPE_STRING + "= :paymentType";
        query = session.createQuery(hql);
        query.setParameter("paymentType", (Object)PaymentType.CREDIT_CARD.name());
        query.executeUpdate();
    }

    private void updateDebitCardTypeField(Session session, String oldCardType, String newCardType) {
        String hql = "update DebitCardTransaction set " + PosTransaction.PROP_CARD_TYPE + "= :newCardType where " + PosTransaction.PROP_PAYMENT_TYPE_STRING + "= :oldCardType";
        Query query = session.createQuery(hql);
        query.setParameter("newCardType", (Object)newCardType);
        query.setParameter("oldCardType", (Object)oldCardType);
        query.executeUpdate();
        hql = "update DebitCardTransaction set " + PosTransaction.PROP_CARD_TYPE + "= :newCardType where " + PosTransaction.PROP_CARD_TYPE + "= :oldCardType";
        query = session.createQuery(hql);
        query.setParameter("newCardType", (Object)newCardType);
        query.setParameter("oldCardType", (Object)oldCardType);
        query.executeUpdate();
        hql = "update DebitCardTransaction set " + PosTransaction.PROP_PAYMENT_TYPE_STRING + "= :paymentType";
        query = session.createQuery(hql);
        query.setParameter("paymentType", (Object)PaymentType.DEBIT_CARD.name());
        query.executeUpdate();
    }
}

