/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.db.update;

import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.util.DatabaseUtil;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.commons.lang.StringUtils;
import org.hibernate.SessionFactory;
import org.hibernate.jdbc.Work;

public class UpdateDBTo155 {
    SessionFactory sessionFactory;

    public UpdateDBTo155(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public void update() throws Exception {
        this.sessionFactory.openSession().doWork(new Work(){

            public void execute(Connection connection) throws SQLException {
                DatabaseMetaData metaData = connection.getMetaData();
                Statement statement = connection.createStatement();
                String ticketTableName = DatabaseUtil.getActualTableName(metaData, "ticket");
                String lastUpdateColName = DatabaseUtil.getActualColumnName(metaData, ticketTableName, "lastUpdateTime");
                ResultSet resultSet = statement.executeQuery(String.format("select count(*) from %s where %s is null", ticketTableName, lastUpdateColName));
                resultSet.next();
                long long1 = resultSet.getLong(1);
                if (long1 == 0L) {
                    return;
                }
                this.updateTable(connection, metaData, "ATTENDENCE_HISTORY", new DateHour("CLOCK_IN_TIME", "CLOCK_IN_HOUR"), new DateHour("CLOCK_OUT_TIME", "CLOCK_OUT_HOUR"));
                this.updateTable(connection, metaData, "EMPLOYEE_IN_OUT_HISTORY", new DateHour("IN_TIME", "IN_HOUR"), new DateHour("OUT_TIME", "OUT_HOUR"));
                this.updateTable(connection, metaData, "TICKET", new DateHour("CREATE_DATE", "CREATION_HOUR"));
                Calendar cal = Calendar.getInstance();
                cal.setTimeZone(TimeZone.getTimeZone("UTC"));
                PreparedStatement pst = connection.prepareStatement("update " + ticketTableName + " set " + lastUpdateColName + "?");
                pst.setTimestamp(1, new Timestamp(System.currentTimeMillis()), cal);
                pst.execute();
                connection.commit();
            }

            private void updateTable(Connection connection, DatabaseMetaData metaData, String tableName, String ... columnNames) throws SQLException {
                String actualTableName = DatabaseUtil.getActualTableName(metaData, tableName);
                if (StringUtils.isEmpty((String)actualTableName)) {
                    return;
                }
                String idCol = DatabaseUtil.getActualColumnName(metaData, actualTableName, "id");
                String[] actualColNames = new String[columnNames.length];
                Timestamp[] timestamps = new Timestamp[columnNames.length];
                System.out.println("Table " + actualTableName + "=========================================");
                for (int i = 0; i < columnNames.length; ++i) {
                    actualColNames[i] = DatabaseUtil.getActualColumnName(metaData, actualTableName, columnNames[i]);
                }
                String sql = "select ";
                for (int i = 0; i < actualColNames.length; ++i) {
                    sql = sql + actualColNames[i];
                    sql = sql + ", ";
                }
                sql = sql + idCol + " from " + tableName;
                Statement statement = connection.createStatement();
                statement.setFetchSize(100);
                ResultSet resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    String id = resultSet.getString(timestamps.length + 1);
                    System.out.print("id=" + id + " (");
                    for (int i = 0; i < timestamps.length; ++i) {
                        timestamps[i] = resultSet.getTimestamp(i + 1);
                        System.out.print(actualColNames[i] + "=" + timestamps[i]);
                        if (i >= timestamps.length - 1) continue;
                        System.out.print(", ");
                    }
                    System.out.println(")");
                    Calendar calendar = Calendar.getInstance();
                    calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                    String updateSql = "update " + actualTableName + " set ";
                    for (int i = 0; i < actualColNames.length; ++i) {
                        updateSql = updateSql + actualColNames[i] + "=?";
                        updateSql = i < actualColNames.length - 1 ? updateSql + ", " : updateSql + " ";
                    }
                    updateSql = updateSql + " where " + idCol + "=?";
                    PreparedStatement preparedStatement = connection.prepareStatement(updateSql);
                    for (int i = 0; i < timestamps.length; ++i) {
                        preparedStatement.setTimestamp(i + 1, timestamps[i], calendar);
                    }
                    preparedStatement.setString(timestamps.length + 1, id);
                }
            }

            private void updateTable(Connection connection, DatabaseMetaData metaData, String tableName, DateHour ... dateHours) throws SQLException {
                String actualTableName = DatabaseUtil.getActualTableName(metaData, tableName);
                if (StringUtils.isEmpty((String)actualTableName)) {
                    return;
                }
                String idCol = DatabaseUtil.getActualColumnName(metaData, actualTableName, "id");
                System.out.println("Table " + actualTableName + "=========================================");
                for (int i = 0; i < dateHours.length; ++i) {
                    DateHour dateHour = dateHours[i];
                    dateHour.actualDateColName = DatabaseUtil.getActualColumnName(metaData, actualTableName, dateHour.dateColName);
                    dateHour.actualHourColName = DatabaseUtil.getActualColumnName(metaData, actualTableName, dateHour.hourColName);
                }
                String sql = "select ";
                for (int i = 0; i < dateHours.length; ++i) {
                    DateHour dateHour = dateHours[i];
                    sql = sql + dateHour.actualDateColName;
                    sql = sql + ", ";
                }
                sql = sql + idCol + " from " + tableName;
                Statement statement = connection.createStatement();
                statement.setFetchSize(100);
                ResultSet resultSet = statement.executeQuery(sql);
                while (resultSet.next()) {
                    String id = resultSet.getString(dateHours.length + 1);
                    System.out.print("id=" + id + " (");
                    for (int i = 0; i < dateHours.length; ++i) {
                        DateHour dateHour = dateHours[i];
                        dateHour.timestamp = resultSet.getTimestamp(i + 1);
                        System.out.print(dateHour.actualDateColName + "=" + dateHour.timestamp);
                        if (i >= dateHours.length - 1) continue;
                        System.out.print(", ");
                    }
                    System.out.println(")");
                    Calendar calendar = Calendar.getInstance();
                    String updateSql = "update " + actualTableName + " set ";
                    for (int i = 0; i < dateHours.length; ++i) {
                        updateSql = updateSql + dateHours[i].actualHourColName + "=?";
                        updateSql = i < dateHours.length - 1 ? updateSql + ", " : updateSql + " ";
                    }
                    updateSql = updateSql + " where " + idCol + "=?";
                    PreparedStatement preparedStatement = connection.prepareStatement(updateSql);
                    for (int i = 0; i < dateHours.length; ++i) {
                        DateHour dateHour = dateHours[i];
                        if (dateHour.timestamp != null) {
                            calendar.setTime(dateHour.timestamp);
                            preparedStatement.setInt(i + 1, calendar.get(10));
                            continue;
                        }
                        preparedStatement.setNull(i + 1, 5);
                    }
                    preparedStatement.setString(dateHours.length + 1, id);
                    preparedStatement.execute();
                }
            }

            private void updaateTickets(Connection connection, DatabaseMetaData metaData, String ticketTableName, String lastUpdateColName) throws SQLException {
                String createDateCol = DatabaseUtil.getActualColumnName(metaData, ticketTableName, "lastUpdate");
                String closingDateCol = DatabaseUtil.getActualColumnName(metaData, ticketTableName, "closing_date");
                String activeDateCol = DatabaseUtil.getActualColumnName(metaData, ticketTableName, "active_date");
                String deliveryDateCol = DatabaseUtil.getActualColumnName(metaData, ticketTableName, "deliveery_date");
                String idCol = DatabaseUtil.getActualColumnName(metaData, ticketTableName, "id");
            }
        });
    }

    public static void main(String[] args) throws Exception {
        DatabaseUtil.initialize();
        SessionFactory sessionFactory2 = StoreDAO.getInstance().getSession().getSessionFactory();
        UpdateDBTo155 updateDBTo155 = new UpdateDBTo155(sessionFactory2);
        updateDBTo155.update();
    }

    class DateHour {
        String dateColName;
        String actualDateColName;
        String hourColName;
        String actualHourColName;
        Timestamp timestamp;

        public DateHour(String dateColName, String hourColName) {
            this.dateColName = dateColName;
            this.hourColName = hourColName;
        }
    }
}

