/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.mailservices;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.util.AESencrp;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang.StringUtils;

public class MailService {
    public static void checkEmailConfiguration() throws Exception {
        Terminal terminal = Application.getInstance().refreshAndGetTerminal();
        String smtpHost = terminal.getSmtpHost();
        String senderEmail = terminal.getSmtpSender();
        String encryptedPassword = terminal.getSmtpPassword();
        String password = null;
        if (!StringUtils.isEmpty((String)encryptedPassword)) {
            password = AESencrp.decrypt(encryptedPassword);
        }
        if (StringUtils.isEmpty((String)smtpHost)) {
            throw new PosException("SMTP Host not found! Please set configuration!");
        }
        if (StringUtils.isEmpty((String)senderEmail)) {
            throw new PosException("Sender email not found! Please set configuration!");
        }
        if (StringUtils.isEmpty((String)password)) {
            throw new PosException("Password not found! Please set configuration!");
        }
    }

    public static void sendTicket(String email, Ticket ticket) throws Exception {
        if (!MailService.isValidEmail(email)) {
            throw new PosException("Invalid email address");
        }
        MailService.checkEmailConfiguration();
        byte[] bytes = ReceiptPrintService.createPDFStream(ticket);
        ByteArrayDataSource bads = new ByteArrayDataSource(bytes, "application/pdf");
        if (!MailService.sendMail(email, "Ticket Receipt", "Ticket Receipt", "TICKET_RECEIPT_" + ticket.getId() + ".pdf", bads)) {
            throw new PosException("Email sending failed.");
        }
    }

    public static boolean isValidEmail(String email) {
        Pattern validEmailRegExp = Pattern.compile("^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$", 2);
        Matcher matcher = validEmailRegExp.matcher(email);
        return matcher.find();
    }

    public static boolean sendMail(String to, String subject, String text, String fileName, ByteArrayDataSource attachments) {
        try {
            Terminal terminal = Application.getInstance().getTerminal();
            String host = terminal.getSmtpHost();
            Integer hostPort = terminal.getSmtpPort();
            String email = terminal.getSmtpSender();
            String encryptedPassword = terminal.getSmtpPassword();
            if (encryptedPassword != null) {
                encryptedPassword = AESencrp.decrypt(encryptedPassword);
            }
            return MailService.sendMail(host, hostPort, email, encryptedPassword, to, subject, text, fileName, attachments);
        }
        catch (Exception e) {
            PosLog.error(MailService.class, e);
            return false;
        }
    }

    public static boolean sendMail(String smtpHost, Integer smtpPort, final String senderEmail, final String senderPassword, String to, String subject, String text, String fileName, final ByteArrayDataSource attachments) {
        Properties props = new Properties();
        props.put("mail.smtp.host", smtpHost);
        props.put("mail.smtp.socketFactory.port", String.valueOf(smtpPort));
        props.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.port", String.valueOf(smtpPort));
        Session session = Session.getDefaultInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(senderEmail, senderPassword);
            }
        });
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(senderEmail));
            message.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to));
            message.setSubject(subject);
            MimeBodyPart messageBodyPart1 = new MimeBodyPart();
            messageBodyPart1.setText(text);
            MimeBodyPart messageBodyPart2 = new MimeBodyPart();
            DataSource source = new DataSource(){

                public OutputStream getOutputStream() throws IOException {
                    return attachments.getOutputStream();
                }

                public String getName() {
                    return attachments.getName();
                }

                public InputStream getInputStream() throws IOException {
                    return attachments.getInputStream();
                }

                public String getContentType() {
                    return attachments.getContentType();
                }
            };
            MimeMultipart multipart = new MimeMultipart();
            if (attachments != null) {
                messageBodyPart2.setDataHandler(new DataHandler(source));
                messageBodyPart2.setFileName(fileName);
                multipart.addBodyPart((BodyPart)messageBodyPart2);
            }
            multipart.addBodyPart((BodyPart)messageBodyPart1);
            message.setContent((Multipart)multipart);
            Transport.send((Message)message);
            PosLog.info(MailService.class, Messages.getString("MailService.11"));
            return true;
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        MailService.sendMail("cto@orocube.net", "Test", "Test", "Test", null);
    }
}

