/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.main;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BackOfficeWindow;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.extension.ExtensionManager;
import com.floreantpos.extension.FloreantPlugin;
import com.floreantpos.main.PosWindow;
import com.floreantpos.main.UpdateManager;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.Store;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao._RootDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.OroLicenceActivationDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.ClockInOutDialog;
import com.floreantpos.ui.views.LoginView;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.DatabaseUtil;
import com.floreantpos.util.LicenseValidationUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.versioning.VersionInfo;
import com.jgoodies.looks.plastic.PlasticTheme;
import com.jgoodies.looks.plastic.PlasticXPLookAndFeel;
import com.jgoodies.looks.plastic.theme.ExperienceBlue;
import com.orocube.common.util.TerminalUtil;
import com.orocube.licensemanager.InvalidLicenseException;
import com.orocube.licensemanager.LicenseUtil;
import com.orocube.licensemanager.OroLicense;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.Font;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import jiconfont.IconFont;
import jiconfont.icons.FontAwesome;
import jiconfont.icons.GoogleMaterialDesignIcons;
import jiconfont.swing.IconFontSwing;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;

public class Application {
    private static Log logger = LogFactory.getLog(Application.class);
    private boolean developmentMode = false;
    private PosWindow posWindow;
    private User currentUser;
    private RootView rootView;
    private static Application instance;
    private static SimpleDateFormat dateFormat;
    private static ImageIcon applicationIcon;
    private boolean systemInitialized;
    private boolean viewInitialized;
    private boolean headLess = false;
    private static final String PRODUCT_NAME = "OROPOS";
    public static final String OROPOS_LICENSE_PIN = "OROPOS.license.pin";
    private OroLicense license;
    private UpdateManager updateManager;

    static {
        dateFormat = new SimpleDateFormat("dd MMM, yyyy");
    }

    protected Application() {
    }

    public void start() {
        System.setProperty("data.provider.class", "com.floreantpos.model.dao.util.PosCacheManager");
        this.updateManager = new UpdateManager();
        this.updateManager.checkHasRemainingUpdates();
        UIManager.put("OptionPane.yesButtonText", Messages.getString("Application.10"));
        UIManager.put("OptionPane.noButtonText", Messages.getString("Application.12"));
        UIManager.put("OptionPane.cancelButtonText", Messages.getString("Application.14"));
        UIManager.put("OptionPane.titleText", Messages.getString("Application.16"));
        UIManager.put("OptionPane.okButtonText", Messages.getString("Application.18"));
        this.setApplicationLook();
        applicationIcon = new ImageIcon(this.getClass().getResource("/icons/icon.png"));
        this.posWindow = new PosWindow();
        this.posWindow.setTitle(Application.getTitle());
        this.posWindow.setIconImage(applicationIcon.getImage());
        this.posWindow.setupSizeAndLocation();
        if (TerminalConfig.isKioskMode()) {
            this.posWindow.enterFullScreenMode();
        }
        this.updateManager.setParentWindow(this.posWindow);
        this.posWindow.setVisible(true);
        this.initLicense();
        this.rootView = RootView.getInstance();
        this.rootView.initDefaultViews();
        this.posWindow.getContentPane().add(this.rootView);
        this.initializeSystem();
        this.initMqtt();
        this.updateManager.publishIfNewUpdateAvailable();
        if (TerminalConfig.isCheckUpdateOnStartUp()) {
            this.checkForUpdate();
        }
    }

    private void initMqtt() {
        try {
            OroMqttClient.getInstance(TerminalUtil.getSystemUID()).initMqttClient();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void checkForUpdate() {
        this.updateManager.checkForUpdate();
    }

    public String getUpdateServerURL() {
        String updateUrl = TerminalConfig.getUpdateServerURL();
        if (StringUtils.isEmpty((String)updateUrl)) {
            updateUrl = "https://orodev.net/update/oropos";
        }
        return updateUrl;
    }

    public void initLicense() {
        try {
            this.license = LicenseUtil.loadAndValidate((String)this.getProductName(), (String)this.getProductVersion(), (String)TerminalUtil.getSystemUID());
            LicenseValidationUtil.doCheckPinNumber(this.license, OROPOS_LICENSE_PIN);
        }
        catch (InvalidLicenseException e) {
            LogFactory.getLog(this.getClass()).error((Object)e);
            this.license = OroLicenceActivationDialog.showDialog(this.posWindow, this.getProductName(), this.getProductVersion());
            LicenseValidationUtil.doCheckPinNumber(this.license, OROPOS_LICENSE_PIN);
        }
        catch (Exception e) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), e.getMessage(), e);
        }
    }

    public void startInvisible() {
        this.setApplicationLook();
        applicationIcon = new ImageIcon(this.getClass().getResource("/icons/icon_updated.png"));
        this.posWindow = new PosWindow();
        this.posWindow.setTitle(Application.getTitle());
        this.posWindow.setIconImage(applicationIcon.getImage());
        this.rootView = RootView.getInstance();
        this.posWindow.getContentPane().add(this.rootView);
        this.initializeSystem();
    }

    private void setApplicationLook() {
        try {
            PlasticXPLookAndFeel.setPlasticTheme((PlasticTheme)new ExperienceBlue());
            UIManager.setLookAndFeel((LookAndFeel)new PlasticXPLookAndFeel());
            this.initializeFont();
            IconFontSwing.register((IconFont)FontAwesome.getIconFont());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void initializeSystem() {
        if (this.isSystemInitialized()) {
            return;
        }
        try {
            try {
                this.posWindow.setGlassPaneVisible(true);
                this.updateManager.performDatabaseUpgrade();
                DatabaseUtil.initialize();
                DatabaseUtil.updateLegacyDatabase();
                DataProvider.get().initialize();
                if (!this.viewInitialized) {
                    this.initPlugins();
                    this.viewInitialized = true;
                }
                LoginView.getInstance().initializeOrderButtonPanel();
                Application.getPosWindow().updateView();
                this.setSystemInitialized(true);
            }
            catch (DatabaseConnectionException | HibernateException e) {
                PosLog.error(this.getClass(), (Exception)e);
                int option = JOptionPane.showConfirmDialog(Application.getPosWindow(), Messages.getString("Application.0"), Messages.getString("PosMessage.Error"), 0);
                if (option == 0) {
                    DatabaseConfigurationDialog.show(Application.getPosWindow());
                }
                Application.getPosWindow().setGlassPaneVisible(false);
            }
            catch (Exception e) {
                POSMessageDialog.showError(Application.getPosWindow(), e.getMessage(), e);
                logger.error((Object)e);
                Application.getPosWindow().setGlassPaneVisible(false);
            }
        }
        finally {
            Application.getPosWindow().setGlassPaneVisible(false);
        }
    }

    public void initializeHeadless() {
        this.headLess = true;
        _RootDAO.initialize();
        DataProvider.get().initialize();
        this.initStore();
        this.refreshStore();
        this.setSystemInitialized(true);
    }

    private void initPlugins() {
        List<FloreantPlugin> plugins = ExtensionManager.getPlugins();
        for (FloreantPlugin floreantPlugin : plugins) {
            floreantPlugin.initUI(Application.getPosWindow());
        }
    }

    private void initStore() {
        try {
            Store store = DataProvider.get().getStore();
            if (!this.headLess) {
                if (store.isItemPriceIncludesTax().booleanValue()) {
                    this.posWindow.setStatus(Messages.getString("Application.41"));
                } else {
                    this.posWindow.setStatus(Messages.getString("Application.42"));
                }
                this.posWindow.setRestaurantName(store.getName());
            }
        }
        catch (Exception e) {
            throw new DatabaseConnectionException(e);
        }
    }

    public void refreshStore() {
        DataProvider.get().refreshStore();
    }

    public List<OrderType> getOrderTypes() {
        return DataProvider.get().getOrderTypes();
    }

    public static synchronized Application getInstance() {
        if (instance == null) {
            instance = new Application();
        }
        return instance;
    }

    public static void setInstance(Application application) {
        instance = application;
    }

    public synchronized void doLogin(User user) {
        this.initializeSystem();
        if (user == null) {
            return;
        }
        boolean userClockIn = this.initCurrentUser(user);
        RootView rootView = this.getRootView();
        if (!rootView.hasView("ORDER_VIEW")) {
            rootView.addView(OrderView.getInstance());
        }
        if (userClockIn) {
            rootView.showDefaultView();
        }
        this.posWindow.rendererUserInfo();
        this.posWindow.startAutoLogoffTimer();
    }

    public boolean initCurrentUser(User user) {
        if (!user.isClockedIn().booleanValue()) {
            ClockInOutDialog dialog = ClockInOutDialog.getInstance(user, true);
            dialog.openUndecoratedFullScreen();
            if (dialog.isCanceled()) {
                return false;
            }
        }
        this.setCurrentUser(user);
        return true;
    }

    public void doLogout() {
        BackOfficeWindow window = POSUtil.getBackOfficeWindow();
        if (window != null && window.isVisible()) {
            window.dispose();
        }
        this.setCurrentUser(null);
        RootView.getInstance().showView(LoginView.getInstance());
        this.posWindow.rendererUserInfo();
        this.posWindow.stopAutoLogoffTimer();
    }

    public void doAutoLogout() {
        this.doLogout();
    }

    public void doAutoLogin(User user) {
        this.setCurrentUser(user);
    }

    public static User getCurrentUser() {
        return Application.getInstance().currentUser;
    }

    public void setCurrentUser(User currentUser) {
        this.currentUser = currentUser;
    }

    public RootView getRootView() {
        return this.rootView;
    }

    public void setRootView(RootView rootView) {
        this.rootView = rootView;
    }

    public static PosWindow getPosWindow() {
        return Application.getInstance().posWindow;
    }

    public Terminal getTerminal() {
        return DataProvider.get().getCurrentTerminal();
    }

    public synchronized Terminal refreshAndGetTerminal() {
        DataProvider.get().refreshCurrentTerminal();
        return DataProvider.get().getCurrentTerminal();
    }

    public static PosPrinters getPrinters() {
        return DataProvider.get().getPrinters();
    }

    public OrderType getCurrentOrderType() {
        return DataProvider.get().getOrderTypes().get(0);
    }

    public static String getTitle() {
        return String.valueOf(VersionInfo.getAppName()) + " " + VersionInfo.getVersion();
    }

    public static ImageIcon getApplicationIcon() {
        return applicationIcon;
    }

    public static void setApplicationIcon(ImageIcon applicationIcon) {
        Application.applicationIcon = applicationIcon;
    }

    public static String formatDate(Date date) {
        return dateFormat.format(date);
    }

    public boolean isSystemInitialized() {
        return this.systemInitialized;
    }

    public void setSystemInitialized(boolean systemInitialized) {
        this.systemInitialized = systemInitialized;
    }

    public Store getStore() {
        return DataProvider.get().getStore();
    }

    public static Outlet getOutlet() {
        return DataProvider.get().getOutlet();
    }

    public static File getWorkingDir() {
        File file = new File(Application.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return file.getParentFile();
    }

    public boolean isDevelopmentMode() {
        return this.developmentMode;
    }

    public void setDevelopmentMode(boolean developmentMode) {
        this.developmentMode = developmentMode;
    }

    public boolean isPriceIncludesTax() {
        Store store = this.getStore();
        if (store == null) {
            return false;
        }
        return POSUtil.getBoolean(store.isItemPriceIncludesTax());
    }

    public String getLocation() {
        File file = new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getFile());
        return file.getParent();
    }

    private void initializeFont() {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (value == null || !(value instanceof FontUIResource)) continue;
            FontUIResource f = (FontUIResource)value;
            String fontName = f.getFontName();
            fontName = "Sans";
            Font font = new Font(fontName, f.getStyle(), PosUIManager.getDefaultFontSize());
            UIManager.put(key, new FontUIResource(font));
        }
        IconFontSwing.register((IconFont)FontAwesome.getIconFont());
        IconFontSwing.register((IconFont)GoogleMaterialDesignIcons.getIconFont());
    }

    public void shutdownPOS() {
        int option = POSMessageDialog.showYesNoQuestionDialog(this.posWindow, POSConstants.CONFIRM_SHUTDOWN_MESSAGE, POSConstants.CONFIRM);
        if (option == 0) {
            this.posWindow.saveSizeAndLocation();
            _RootDAO.releaseConnection();
            System.exit(0);
        }
    }

    public OroLicense getLicense() {
        return this.license;
    }

    public String getProductName() {
        return PRODUCT_NAME;
    }

    public String getProductVersion() {
        return VersionInfo.getVersion();
    }

    public void refreshCurrentUser() {
        if (this.currentUser != null) {
            this.currentUser = UserDAO.getInstance().get(this.currentUser.getId());
        }
    }

    public String getHibernateConfigurationFileName() {
        return "oropos.hibernate.cfg.xml";
    }

    @Deprecated
    public static String getLengthUnit() {
        return "MILE";
    }

    public UpdateManager getUpdateManager() {
        return this.updateManager;
    }
}

